/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.s3.sdk;

import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressEventType;
import com.amazonaws.event.ProgressListener;

public class SdkTransferProgressListenerAdapter<T>
implements ProgressListener {
    private final net.solarnetwork.service.ProgressListener<T> delegate;
    private final T context;
    private final boolean trackRequest;
    private long totalBytes;
    private long totalBytesTransferred;

    public SdkTransferProgressListenerAdapter(net.solarnetwork.service.ProgressListener<T> delegate, T context, boolean trackRequest) {
        this.delegate = delegate;
        this.context = context;
        this.trackRequest = trackRequest;
        this.totalBytes = 0L;
        this.totalBytesTransferred = 0L;
    }

    public void progressChanged(ProgressEvent progressEvent) {
        if (this.delegate == null) {
            return;
        }
        ProgressEventType type = progressEvent.getEventType();
        if (!type.isByteCountEvent()) {
            return;
        }
        switch (type) {
            case REQUEST_CONTENT_LENGTH_EVENT: {
                if (this.trackRequest) {
                    this.totalBytes = progressEvent.getBytes();
                }
                return;
            }
            case RESPONSE_CONTENT_LENGTH_EVENT: {
                if (!this.trackRequest) {
                    this.totalBytes = progressEvent.getBytes();
                }
                return;
            }
        }
        this.totalBytesTransferred += progressEvent.getBytesTransferred();
        double progress = this.totalBytes > 0L ? (double)this.totalBytesTransferred / (double)this.totalBytes : 0.0;
        this.delegate.progressChanged(this.context, progress);
    }
}

