/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.s3.sdk;

import com.amazonaws.services.s3.model.ObjectMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import net.solarnetwork.common.s3.S3Object;
import net.solarnetwork.common.s3.S3ObjectMetadata;
import org.springframework.util.MimeType;

public class SdkS3Object
implements S3Object,
S3ObjectMetadata {
    private final com.amazonaws.services.s3.model.S3Object s3Object;
    private final URL url;

    public SdkS3Object(com.amazonaws.services.s3.model.S3Object s3Object, URL url) {
        this.s3Object = s3Object;
        this.url = url;
    }

    public InputStream getInputStream() throws IOException {
        return this.s3Object.getObjectContent();
    }

    public S3ObjectMetadata getMetadata() {
        return this;
    }

    public Date getModified() {
        ObjectMetadata m = this.s3Object.getObjectMetadata();
        return m != null ? m.getLastModified() : null;
    }

    public long getSize() {
        ObjectMetadata m = this.s3Object.getObjectMetadata();
        return m != null ? Long.valueOf(m.getContentLength()) : null;
    }

    public String getStorageClass() {
        ObjectMetadata m = this.s3Object.getObjectMetadata();
        return m != null ? m.getStorageClass() : null;
    }

    public URL getURL() {
        return this.url;
    }

    public MimeType getContentType() {
        ObjectMetadata m = this.s3Object.getObjectMetadata();
        return m != null && m.getContentType() != null ? MimeType.valueOf((String)m.getContentType()) : S3ObjectMetadata.DEFAULT_CONTENT_TYPE;
    }

    public void populateMap(Map<String, Object> map) {
        Map extra;
        ObjectMetadata m = this.s3Object.getObjectMetadata();
        Map map2 = extra = m != null ? m.getRawMetadata() : null;
        if (extra != null) {
            map.putAll(extra);
        }
        super.populateMap(map);
    }
}

