/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.s3.sdk;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.DeleteObjectsResult;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.solarnetwork.common.s3.S3Client;
import net.solarnetwork.common.s3.S3Object;
import net.solarnetwork.common.s3.S3ObjectMetadata;
import net.solarnetwork.common.s3.S3ObjectRef;
import net.solarnetwork.common.s3.S3ObjectReference;
import net.solarnetwork.common.s3.sdk.SdkS3Object;
import net.solarnetwork.common.s3.sdk.SdkTransferProgressListenerAdapter;
import net.solarnetwork.service.ProgressListener;
import net.solarnetwork.service.RemoteServiceException;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.SettingsChangeObserver;
import net.solarnetwork.settings.support.BaseSettingsSpecifierLocalizedServiceInfoProvider;
import net.solarnetwork.settings.support.BasicTextFieldSettingSpecifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkS3Client
extends BaseSettingsSpecifierLocalizedServiceInfoProvider<String>
implements S3Client,
SettingsChangeObserver {
    public static final String DEFAULT_REGION_NAME = Regions.US_WEST_2.getName();
    public static final int DEFAULT_MAXIMUM_KEYS_PER_REQUEST = 500;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String accessToken;
    private String accessSecret;
    private String bucketName;
    private String regionName = DEFAULT_REGION_NAME;
    private int maximumKeysPerRequest = 500;
    private AWSCredentialsProvider credentialsProvider;
    private AWSCredentialsProvider tokenCredentialsProvider;
    private AmazonS3 s3Client;

    public SdkS3Client() {
        this(SdkS3Client.class.getName());
    }

    public SdkS3Client(String id) {
        super((Comparable)((Object)id));
    }

    public synchronized void configurationChanged(Map<String, Object> properties) {
        if (this.accessToken != null && this.accessSecret != null) {
            this.tokenCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.accessToken, this.accessSecret));
        }
        if (this.s3Client != null) {
            this.s3Client = null;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("S3Client{region=");
        builder.append(this.regionName);
        builder.append(",bucket=");
        builder.append(this.bucketName);
        builder.append("}");
        return builder.toString();
    }

    private synchronized AmazonS3 getClient() {
        AmazonS3 result = this.s3Client;
        if (result == null) {
            AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withRegion(this.regionName);
            AWSCredentialsProvider provider = null;
            if (this.credentialsProvider != null && this.tokenCredentialsProvider != null) {
                provider = new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{this.tokenCredentialsProvider, this.credentialsProvider});
            } else if (this.tokenCredentialsProvider != null) {
                provider = this.tokenCredentialsProvider;
            } else if (this.credentialsProvider != null) {
                provider = this.credentialsProvider;
            }
            if (provider != null) {
                builder.withCredentials(provider);
            }
            this.s3Client = result = (AmazonS3)builder.build();
        }
        return result;
    }

    public boolean isConfigured() {
        return this.bucketName != null && this.bucketName.length() > 0 && this.regionName != null && this.regionName.length() > 0 && (this.credentialsProvider != null || this.tokenCredentialsProvider != null);
    }

    public Set<S3ObjectReference> listObjects(String prefix) throws IOException {
        AmazonS3 client = this.getClient();
        LinkedHashSet<S3ObjectReference> result = new LinkedHashSet<S3ObjectReference>(100);
        try {
            ListObjectsV2Result listResult;
            ListObjectsV2Request req = new ListObjectsV2Request();
            req.setBucketName(this.bucketName);
            req.setMaxKeys(Integer.valueOf(this.maximumKeysPerRequest));
            req.setPrefix(prefix);
            do {
                listResult = client.listObjectsV2(req);
                for (S3ObjectSummary objectSummary : listResult.getObjectSummaries()) {
                    URL url = client.getUrl(objectSummary.getBucketName(), objectSummary.getKey());
                    result.add((S3ObjectReference)new S3ObjectRef(objectSummary.getKey(), objectSummary.getSize(), objectSummary.getLastModified(), url));
                }
                req.setContinuationToken(listResult.getNextContinuationToken());
            } while (listResult.isTruncated());
        }
        catch (AmazonServiceException e) {
            this.log.warn("AWS error: {}; HTTP code {}; AWS code {}; type {}; request ID {}", new Object[]{e.getMessage(), e.getStatusCode(), e.getErrorCode(), e.getErrorType(), e.getRequestId()});
            throw new RemoteServiceException("Error listing S3 objects at " + prefix, (Throwable)e);
        }
        catch (AmazonClientException e) {
            this.log.debug("Error communicating with AWS: {}", (Object)e.getMessage());
            throw new IOException("Error communicating with AWS", e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Listed {} S3 objects: {}", (Object)result.size(), result.stream().map(r -> r.getKey()).collect(Collectors.toList()));
        }
        return result;
    }

    public String getObjectAsString(String key) throws IOException {
        AmazonS3 client = this.getClient();
        try {
            String result = client.getObjectAsString(this.bucketName, key);
            this.log.debug("Got S3 string {}/{} ({})", new Object[]{this.bucketName, key, result.length()});
            return result;
        }
        catch (AmazonServiceException e) {
            this.log.warn("AWS error: {}; HTTP code {}; AWS code {}; type {}; request ID {}", new Object[]{e.getMessage(), e.getStatusCode(), e.getErrorCode(), e.getErrorType(), e.getRequestId()});
            throw new RemoteServiceException("Error getting S3 object at " + key, (Throwable)e);
        }
        catch (AmazonClientException e) {
            this.log.debug("Error communicating with AWS: {}", (Object)e.getMessage());
            throw new IOException("Error communicating with AWS", e);
        }
    }

    public <P> S3Object getObject(String key, ProgressListener<P> progressListener, P progressContext) throws IOException {
        AmazonS3 client = this.getClient();
        try {
            GetObjectRequest req = new GetObjectRequest(this.bucketName, key);
            if (progressListener != null) {
                SdkTransferProgressListenerAdapter<P> adapter = new SdkTransferProgressListenerAdapter<P>(progressListener, progressContext, false);
                req.setGeneralProgressListener(adapter);
            }
            com.amazonaws.services.s3.model.S3Object obj = client.getObject(req);
            this.log.debug("Got S3 object {}/{} ({})", new Object[]{this.bucketName, key, obj.getObjectMetadata().getContentLength()});
            return new SdkS3Object(obj, client.getUrl(this.bucketName, key));
        }
        catch (AmazonServiceException e) {
            this.log.warn("AWS error: {}; HTTP code {}; AWS code {}; type {}; request ID {}", new Object[]{e.getMessage(), e.getStatusCode(), e.getErrorCode(), e.getErrorType(), e.getRequestId()});
            throw new RemoteServiceException("Error getting S3 object at " + key, (Throwable)e);
        }
        catch (AmazonClientException e) {
            this.log.debug("Error communicating with AWS: {}", (Object)e.getMessage());
            throw new IOException("Error communicating with AWS", e);
        }
    }

    public URL getObjectURL(String key) {
        AmazonS3 client = this.getClient();
        return client.getUrl(this.bucketName, key);
    }

    public <P> S3ObjectReference putObject(String key, InputStream in, S3ObjectMetadata objectMetadata, ProgressListener<P> progressListener, P progressContext) throws IOException {
        AmazonS3 client = this.getClient();
        try {
            ObjectMetadata meta = new ObjectMetadata();
            Map customMap = objectMetadata.asCustomMap();
            for (Map.Entry me : customMap.entrySet()) {
                meta.setHeader((String)me.getKey(), me.getValue());
            }
            if (objectMetadata.getModified() != null) {
                meta.setLastModified(objectMetadata.getModified());
            }
            meta.setContentLength(objectMetadata.getSize());
            meta.setContentType(objectMetadata.getContentType().toString());
            PutObjectRequest req = new PutObjectRequest(this.bucketName, key, in, meta);
            if (progressListener != null) {
                SdkTransferProgressListenerAdapter<P> adapter = new SdkTransferProgressListenerAdapter<P>(progressListener, progressContext, true);
                req.setGeneralProgressListener(adapter);
            }
            if (objectMetadata.getStorageClass() != null) {
                req.setStorageClass(objectMetadata.getStorageClass());
            }
            client.putObject(req);
            this.log.debug("Put S3 object {}/{} ({})", new Object[]{this.bucketName, key, meta.getContentLength()});
            return new S3ObjectRef(key, objectMetadata.getSize(), objectMetadata.getModified(), client.getUrl(this.bucketName, key));
        }
        catch (AmazonServiceException e) {
            this.log.warn("AWS error: {}; HTTP code {}; AWS code {}; type {}; request ID {}", new Object[]{e.getMessage(), e.getStatusCode(), e.getErrorCode(), e.getErrorType(), e.getRequestId()});
            throw new RemoteServiceException("Error putting S3 object at " + key, (Throwable)e);
        }
        catch (AmazonClientException e) {
            this.log.debug("Error communicating with AWS: {}", (Object)e.getMessage());
            throw new IOException("Error communicating with AWS", e);
        }
    }

    public Set<String> deleteObjects(Iterable<String> keys) throws IOException {
        AmazonS3 client = this.getClient();
        try {
            DeleteObjectsRequest req = new DeleteObjectsRequest(this.bucketName).withKeys(StreamSupport.stream(keys.spliterator(), false).map(k -> new DeleteObjectsRequest.KeyVersion(k)).collect(Collectors.toList()));
            if (req.getKeys().isEmpty()) {
                return Collections.emptySet();
            }
            DeleteObjectsResult res = client.deleteObjects(req);
            List deleted = res.getDeletedObjects();
            if (deleted == null) {
                return Collections.emptySet();
            }
            return deleted.stream().map(d -> d.getKey()).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        catch (AmazonServiceException e) {
            this.log.warn("AWS error: {}; HTTP code {}; AWS code {}; type {}; request ID {}", new Object[]{e.getMessage(), e.getStatusCode(), e.getErrorCode(), e.getErrorType(), e.getRequestId()});
            throw new RemoteServiceException("Error deleting S3 objects " + keys, (Throwable)e);
        }
        catch (AmazonClientException e) {
            this.log.debug("Error communicating with AWS: {}", (Object)e.getMessage());
            throw new IOException("Error communicating with AWS", e);
        }
    }

    public String getDisplayName() {
        return "AWS SDK S3 Client";
    }

    public List<SettingSpecifier> getSettingSpecifiers() {
        ArrayList<SettingSpecifier> result = new ArrayList<SettingSpecifier>(5);
        result.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("accessToken", ""));
        result.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("accessSecret", "", true));
        result.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("regionName", DEFAULT_REGION_NAME));
        result.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("bucketName", ""));
        result.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("maximumKeysPerRequest", String.valueOf(500)));
        return result;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public void setMaximumKeysPerRequest(int maximumKeysPerRequest) {
        this.maximumKeysPerRequest = maximumKeysPerRequest;
    }

    public void setCredentialsProvider(AWSCredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setAccessSecret(String accessSecret) {
        this.accessSecret = accessSecret;
    }
}

