/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.web.json;

import java.net.URI;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.solarnetwork.ocpp.dao.SystemUserDao;
import net.solarnetwork.ocpp.domain.SystemUser;
import net.solarnetwork.service.PasswordEncoder;
import net.solarnetwork.util.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.socket.SubProtocolCapable;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketHttpHeaders;
import org.springframework.web.socket.handler.WebSocketHandlerDecorator;
import org.springframework.web.socket.server.HandshakeInterceptor;

public class OcppWebSocketHandshakeInterceptor
implements HandshakeInterceptor {
    public static final String REQUEST_URI_ATTR = "requestUri";
    public static final String DEFAULT_CLIENT_ID_URI_PATTERN = "/ocpp/v16/cs/json/(.*)";
    public static final String CLIENT_ID_ATTR = "clientId";
    private static final Logger log = LoggerFactory.getLogger(OcppWebSocketHandshakeInterceptor.class);
    private final SystemUserDao systemUserDao;
    private final PasswordEncoder passwordEncoder;
    private Pattern clientIdUriPattern;
    private BiFunction<ServerHttpRequest, String, String[]> clientCredentialsExtractor = OcppWebSocketHandshakeInterceptor::extractBasicAuthentication;
    private String fixedIdentityUsername;

    public OcppWebSocketHandshakeInterceptor(SystemUserDao systemUserDao, PasswordEncoder passwordEncoder) {
        this.systemUserDao = systemUserDao;
        this.passwordEncoder = passwordEncoder;
        this.setClientIdUriPattern(Pattern.compile(DEFAULT_CLIENT_ID_URI_PATTERN));
    }

    public boolean beforeHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Map<String, Object> attributes) throws Exception {
        List subProtocols;
        URI uri = request.getURI();
        Matcher m = this.clientIdUriPattern.matcher(uri.getPath());
        if (!m.find()) {
            log.debug("OCPP handshake request rejected, client ID not found in URI path: {}", (Object)uri.getPath());
            response.setStatusCode(HttpStatus.NOT_FOUND);
            return false;
        }
        String identifier = m.group(1);
        WebSocketHandler handler = WebSocketHandlerDecorator.unwrap((WebSocketHandler)wsHandler);
        if (handler instanceof SubProtocolCapable && (subProtocols = ((SubProtocolCapable)handler).getSubProtocols()) != null && !subProtocols.isEmpty()) {
            WebSocketHttpHeaders headers = new WebSocketHttpHeaders(request.getHeaders());
            List clientSubProtocols = headers.getSecWebSocketProtocol();
            boolean match = false;
            if (clientSubProtocols != null) {
                for (String clientProtocol : clientSubProtocols) {
                    if (!subProtocols.contains(clientProtocol)) continue;
                    match = true;
                    break;
                }
            }
            if (!match) {
                log.debug("OCPP handshake request rejected, supported sub-protocol(s) {}, requested: {}", (Object)subProtocols, (Object)clientSubProtocols);
                response.setStatusCode(HttpStatus.BAD_REQUEST);
                return false;
            }
        }
        if (this.systemUserDao != null) {
            String[] httpAuthComponents = this.clientCredentialsExtractor.apply(request, identifier);
            if (httpAuthComponents == null || httpAuthComponents.length < 2) {
                log.warn("OCPP handshake request rejected for {}, invalid Authorization provided", (Object)identifier);
                response.setStatusCode(HttpStatus.FORBIDDEN);
                return false;
            }
            String username = httpAuthComponents[0];
            String password = httpAuthComponents[1];
            SystemUser user = this.systemUserDao.getForUsernameAndChargePoint(username, identifier);
            if (user == null) {
                log.warn("OCPP handshake request rejected for {}, system user {} not found.", (Object)identifier, (Object)username);
                response.setStatusCode(HttpStatus.FORBIDDEN);
                return false;
            }
            Set allowedChargePoints = user.getAllowedChargePoints();
            if (allowedChargePoints != null && !allowedChargePoints.isEmpty() && !allowedChargePoints.contains(identifier)) {
                log.warn("OCPP handshake request rejected for {}, system user {} does not allow identifier.", (Object)identifier, (Object)username);
                response.setStatusCode(HttpStatus.FORBIDDEN);
                this.didForbidChargerConnection(user, String.format("System user [%s] does not allow identifier [%s]", username, identifier));
                return false;
            }
            if (!(user.getPassword() == null || this.passwordEncoder != null && this.passwordEncoder.matches((CharSequence)password, user.getPassword()) || user.getPassword().equals(password))) {
                log.warn("OCPP handshake request rejected for {}, system user {} password does not match.", (Object)identifier, (Object)username);
                response.setStatusCode(HttpStatus.FORBIDDEN);
                this.didForbidChargerConnection(user, String.format("System user [%s] password mismatch by identifier [%s].", username, identifier));
                return false;
            }
            attributes.putIfAbsent(CLIENT_ID_ATTR, user.chargePointIdentity(identifier));
        }
        return true;
    }

    protected void didForbidChargerConnection(SystemUser user, String reason) {
    }

    public static String[] extractBasicAuthentication(ServerHttpRequest request, String identifier) {
        String httpAuth = request.getHeaders().getFirst("Authorization");
        if (httpAuth == null) {
            log.warn("OCPP handshake request rejected for {}, Authorization header not provided.", (Object)identifier);
            return null;
        }
        String[] httpAuthComponents = OcppWebSocketHandshakeInterceptor.decodeBasicAuthorizationHeader(httpAuth);
        if (httpAuthComponents == null) {
            log.warn("OCPP handshake request rejected for {}, invalid Basic Authorization header provided: [{}]", (Object)identifier, (Object)httpAuth);
            return null;
        }
        return httpAuthComponents;
    }

    private static String[] decodeBasicAuthorizationHeader(String header) {
        byte[] decoded;
        Charset utf8 = Charset.forName("UTF-8");
        int space = header.indexOf(32);
        if (space < 0 || space + 1 >= header.length()) {
            return null;
        }
        byte[] base64Token = header.substring(space + 1).getBytes(utf8);
        try {
            decoded = Base64.getDecoder().decode(base64Token);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        String token = new String(decoded, utf8);
        int delim = token.indexOf(":");
        if (delim == -1) {
            return null;
        }
        return new String[]{token.substring(0, delim), token.substring(delim + 1)};
    }

    public void afterHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Exception exception) {
    }

    public Pattern getClientIdUriPattern() {
        return this.clientIdUriPattern;
    }

    public void setClientIdUriPattern(Pattern clientIdUriPattern) {
        this.clientIdUriPattern = (Pattern)ObjectUtils.requireNonNullArgument((Object)clientIdUriPattern, (String)"clientIdUriPattern");
    }

    public String getFixedIdentityUsername() {
        return this.fixedIdentityUsername;
    }

    public void setFixedIdentityUsername(String fixedIdentityUsername) {
        this.fixedIdentityUsername = fixedIdentityUsername;
    }

    public BiFunction<ServerHttpRequest, String, String[]> getClientCredentialsExtractor() {
        return this.clientCredentialsExtractor;
    }

    public void setClientCredentialsExtractor(BiFunction<ServerHttpRequest, String, String[]> clientCredentialsExtractor) {
        this.clientCredentialsExtractor = (BiFunction)ObjectUtils.requireNonNullArgument(clientCredentialsExtractor, (String)"clientCredentialsExtractor");
    }
}

