/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.web.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.websocket.Session;
import net.solarnetwork.ocpp.domain.Action;
import net.solarnetwork.ocpp.domain.ActionMessage;
import net.solarnetwork.ocpp.domain.BasicActionMessage;
import net.solarnetwork.ocpp.domain.ChargePointIdentity;
import net.solarnetwork.ocpp.domain.ErrorCode;
import net.solarnetwork.ocpp.domain.ErrorCodeException;
import net.solarnetwork.ocpp.domain.ErrorHolder;
import net.solarnetwork.ocpp.domain.PendingActionMessage;
import net.solarnetwork.ocpp.domain.SchemaValidationException;
import net.solarnetwork.ocpp.json.ActionPayloadDecoder;
import net.solarnetwork.ocpp.json.MessageType;
import net.solarnetwork.ocpp.json.RpcError;
import net.solarnetwork.ocpp.json.WebSocketSubProtocol;
import net.solarnetwork.ocpp.service.ActionMessageProcessor;
import net.solarnetwork.ocpp.service.ActionMessageQueue;
import net.solarnetwork.ocpp.service.ActionMessageResultHandler;
import net.solarnetwork.ocpp.service.ChargePointBroker;
import net.solarnetwork.ocpp.service.ErrorCodeResolver;
import net.solarnetwork.ocpp.service.SimpleActionMessageQueue;
import net.solarnetwork.security.AuthorizationException;
import net.solarnetwork.settings.SettingsChangeObserver;
import net.solarnetwork.util.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.SubProtocolCapable;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.adapter.NativeWebSocketSession;
import org.springframework.web.socket.handler.AbstractWebSocketHandler;

public class OcppWebSocketHandler<C extends Enum<C>, S extends Enum<S>>
extends AbstractWebSocketHandler
implements WebSocketHandler,
SubProtocolCapable,
SettingsChangeObserver,
ChargePointBroker {
    public static final long DEFAULT_PENDING_MESSAGE_TIMEOUT = TimeUnit.SECONDS.toMillis(120L);
    public static final int DEFAULT_PING_FREQUENCY_SECS = 50;
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final AsyncTaskExecutor executor;
    private final Class<C> chargePointActionClass;
    private final Class<S> centralSystemActionClass;
    private final ErrorCodeResolver errorCodeResolver;
    private final Map<Action, Set<ActionMessageProcessor<Object, Object>>> processors;
    private final ConcurrentMap<ChargePointIdentity, WebSocketSession> clientSessions;
    private final ActionMessageQueue pendingMessages;
    private final ObjectMapper mapper;
    private TaskScheduler taskScheduler;
    private ActionPayloadDecoder centralServiceActionPayloadDecoder;
    private ActionPayloadDecoder chargePointActionPayloadDecoder;
    private long pendingMessageTimeout = DEFAULT_PENDING_MESSAGE_TIMEOUT;
    private int pingFrequencySecs = 50;
    private Future<?> startupTask;
    private ScheduledFuture<?> pendingTimeoutChore;
    private ScheduledFuture<?> pingChore;

    public OcppWebSocketHandler(Class<C> chargePointActionClass, Class<S> centralSystemActionClass, ErrorCodeResolver errorCodeResolver, AsyncTaskExecutor executor, ObjectMapper mapper) {
        this.chargePointActionClass = chargePointActionClass;
        this.centralSystemActionClass = centralSystemActionClass;
        this.errorCodeResolver = errorCodeResolver;
        this.executor = executor;
        this.processors = new ConcurrentHashMap<Action, Set<ActionMessageProcessor<Object, Object>>>(16, 0.9f, 1);
        this.clientSessions = new ConcurrentHashMap<ChargePointIdentity, WebSocketSession>(8, 0.7f, 2);
        this.pendingMessages = new SimpleActionMessageQueue();
        this.mapper = mapper;
    }

    public OcppWebSocketHandler(Class<C> chargePointActionClass, Class<S> centralSystemActionClass, ErrorCodeResolver errorCodeResolver, AsyncTaskExecutor executor, ObjectMapper mapper, ActionMessageQueue pendingMessageQueue, ActionPayloadDecoder centralServiceActionPayloadDecoder, ActionPayloadDecoder chargePointActionPayloadDecoder) {
        this.chargePointActionClass = (Class)ObjectUtils.requireNonNullArgument(chargePointActionClass, (String)"chargePointActionClass");
        this.centralSystemActionClass = (Class)ObjectUtils.requireNonNullArgument(centralSystemActionClass, (String)"centralSystemActionClass");
        this.errorCodeResolver = (ErrorCodeResolver)ObjectUtils.requireNonNullArgument((Object)errorCodeResolver, (String)"errorCodeResolver");
        this.executor = (AsyncTaskExecutor)ObjectUtils.requireNonNullArgument((Object)executor, (String)"executor");
        this.mapper = (ObjectMapper)ObjectUtils.requireNonNullArgument((Object)mapper, (String)"mapper");
        this.pendingMessages = (ActionMessageQueue)ObjectUtils.requireNonNullArgument((Object)pendingMessageQueue, (String)"pendingMessageQueue");
        this.processors = new ConcurrentHashMap<Action, Set<ActionMessageProcessor<Object, Object>>>(16, 0.9f, 1);
        this.clientSessions = new ConcurrentHashMap<ChargePointIdentity, WebSocketSession>(8, 0.7f, 2);
        this.setCentralServiceActionPayloadDecoder(centralServiceActionPayloadDecoder);
        this.setChargePointActionPayloadDecoder(chargePointActionPayloadDecoder);
    }

    public synchronized void startup() {
        this.configurationChanged(null);
    }

    public synchronized void shutdown() {
        if (this.startupTask != null) {
            this.startupTask.cancel(true);
        }
        this.unshceduleChores();
    }

    public synchronized void configurationChanged(Map<String, Object> properties) {
        if (this.startupTask != null) {
            return;
        }
        this.startupTask = this.executor.submit((Runnable)new StartupTask());
    }

    private synchronized void scheduleChores() {
        long freq;
        if (this.taskScheduler == null) {
            return;
        }
        if (this.pendingTimeoutChore == null) {
            freq = Math.max(1000L, this.pendingMessageTimeout / 10L);
            this.pendingTimeoutChore = this.taskScheduler.scheduleWithFixedDelay((Runnable)new PendingTimeoutChore(), new Date(System.currentTimeMillis() + this.pendingMessageTimeout), freq);
            this.log.info("Scheduled pending timeout cleaner task at rate {}s with timeout {}s", (Object)(freq / 1000L), (Object)(this.pendingMessageTimeout / 1000L));
        }
        if (this.pingChore == null && this.pingFrequencySecs > 0) {
            freq = TimeUnit.SECONDS.toMillis(this.pingFrequencySecs);
            this.pingChore = this.taskScheduler.scheduleWithFixedDelay((Runnable)new PingChore(), new Date(System.currentTimeMillis() + freq), freq);
            this.log.info("Scheduled PING task at rate {}s", (Object)this.pingFrequencySecs);
        }
    }

    private synchronized void unshceduleChores() {
        if (this.pendingTimeoutChore != null) {
            this.pendingTimeoutChore.cancel(true);
        }
        if (this.pingChore != null) {
            this.pingChore.cancel(true);
        }
    }

    public List<String> getSubProtocols() {
        return Collections.singletonList(WebSocketSubProtocol.OCPP_V16.getValue());
    }

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        ChargePointIdentity clientId = this.clientId(session);
        if (clientId != null) {
            this.clientSessions.put(clientId, session);
        }
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        ChargePointIdentity clientId = this.clientId(session);
        if (clientId != null) {
            this.clientSessions.remove(clientId, session);
        }
    }

    protected ChargePointIdentity clientId(WebSocketSession session) {
        Object id = session.getAttributes().get("clientId");
        return id instanceof ChargePointIdentity ? (ChargePointIdentity)id : null;
    }

    protected ErrorCode errorCode(RpcError error) {
        return this.errorCodeResolver.errorCodeForRpcError(error);
    }

    protected void handleTextMessage(WebSocketSession session, TextMessage message) throws Exception {
        JsonNode tree;
        ChargePointIdentity clientId = this.clientId(session);
        this.log.trace("OCPP {} <<< {}", (Object)clientId, message.getPayload());
        try {
            tree = this.mapper.readTree((String)message.getPayload());
        }
        catch (JsonProcessingException e) {
            this.sendCallError(session, clientId, null, this.errorCode(RpcError.PayloadProtocolError), "Message malformed JSON.", null);
            return;
        }
        if (tree.isArray()) {
            MessageType msgType;
            String messageId;
            JsonNode msgTypeNode = tree.path(0);
            JsonNode messageIdNode = tree.path(1);
            String string = messageId = messageIdNode.isTextual() ? messageIdNode.textValue() : "NULL";
            if (!msgTypeNode.isInt()) {
                this.sendCallError(session, clientId, messageId, this.errorCode(RpcError.MessageSyntaxError), "Message type not provided.", null);
                return;
            }
            try {
                msgType = MessageType.forNumber((int)msgTypeNode.intValue());
            }
            catch (IllegalArgumentException e) {
                this.log.info("OCPP {} <<< Ignoring message with unknown type: {}", (Object)clientId, message.getPayload());
                return;
            }
            switch (msgType) {
                case Call: {
                    this.handleCallMessage(session, clientId, messageId, message, tree);
                    break;
                }
                case CallError: {
                    this.handleCallErrorMessage(session, clientId, messageId, message, tree);
                    break;
                }
                case CallResult: {
                    this.handleCallResultMessage(session, clientId, messageId, message, tree);
                }
            }
        }
    }

    protected Action chargePointAction(String name) {
        for (Enum action : (Enum[])this.chargePointActionClass.getEnumConstants()) {
            if (!name.equals(((Action)action).getName())) continue;
            return (Action)action;
        }
        return null;
    }

    protected Action centralSystemAction(String name) {
        for (Enum action : (Enum[])this.centralSystemActionClass.getEnumConstants()) {
            if (!name.equals(((Action)action).getName())) continue;
            return (Action)action;
        }
        return null;
    }

    private boolean handleCallMessage(WebSocketSession session, ChargePointIdentity clientId, String messageId, TextMessage message, JsonNode tree) {
        JsonNode actionNode = tree.path(2);
        try {
            Object payload;
            Action action;
            Action action2 = action = actionNode.isTextual() ? this.centralSystemAction(actionNode.textValue()) : null;
            if (action == null) {
                if (actionNode.isTextual() && !actionNode.textValue().isEmpty()) {
                    return this.sendCallError(session, clientId, messageId, this.errorCode(RpcError.ActionNotImplemented), "Unknown action.", null);
                }
                return this.sendCallError(session, clientId, messageId, this.errorCode(RpcError.PayloadSyntaxError), actionNode.isMissingNode() ? "Missing action." : "Malformed action.", null);
            }
            try {
                payload = this.centralServiceActionPayloadDecoder.decodeActionPayload(action, false, tree.path(3));
            }
            catch (SchemaValidationException e) {
                return this.sendCallError(session, clientId, messageId, this.errorCode(RpcError.PayloadTypeConstraintViolation), "Schema validation error: " + e.getMessage(), null);
            }
            catch (IOException e) {
                return this.sendCallError(session, clientId, messageId, this.errorCode(RpcError.PayloadSyntaxError), "Error parsing payload: " + e.getMessage(), null);
            }
            this.pendingMessages.addPendingMessage(new PendingActionMessage((ActionMessage)new BasicActionMessage(clientId, messageId, action, payload)), this::processNextPendingMessage);
            return true;
        }
        catch (RuntimeException e) {
            return this.sendCallError(session, clientId, messageId, this.errorCode(RpcError.InternalError), "Internal error: " + e.toString(), null);
        }
    }

    public Set<ChargePointIdentity> availableChargePointsIds() {
        return this.clientSessions.keySet();
    }

    public boolean isChargePointAvailable(ChargePointIdentity clientId) {
        return this.clientSessions.containsKey(clientId);
    }

    public boolean isMessageSupported(ActionMessage<?> message) {
        if (message == null || !this.isChargePointAvailable(message.getClientId()) || message.getAction() == null) {
            return false;
        }
        String action = message.getAction().getName();
        if (this.chargePointAction(action) != null) {
            return true;
        }
        return this.centralSystemAction(action) != null;
    }

    public <T, R> boolean sendMessageToChargePoint(ActionMessage<T> message, ActionMessageResultHandler<T, R> resultHandler) {
        ChargePointIdentity clientId = message.getClientId();
        if (clientId == null || !this.clientSessions.containsKey(clientId)) {
            this.log.debug("Client ID [{}] not available; ignoring message {}", (Object)clientId, message);
            return false;
        }
        ActionMessage<T> a = message;
        ActionMessageResultHandler<T, R> h = resultHandler;
        this.pendingMessages.addPendingMessage(new PendingActionMessage(a, h), this::processNextPendingMessage);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCall(PendingActionMessage msg) {
        ActionMessage message = msg.getMessage();
        ActionMessageResultHandler resultHandler = msg.getHandler();
        WebSocketSession session = (WebSocketSession)this.clientSessions.get(message.getClientId());
        if (session == null) {
            this.log.debug("Web socket not available for CallMessage {}; ignoring", (Object)message);
            return;
        }
        boolean sent = this.sendCall(session, message.getClientId(), message.getMessageId(), message.getAction(), message.getMessage());
        if (!sent) {
            this.removePendingMessage(msg);
            ErrorCodeException err = new ErrorCodeException(this.errorCode(RpcError.SecurityError), "Client ID missing.");
            try {
                resultHandler.handleActionMessageResult(message, null, (Throwable)err);
            }
            catch (Exception e) {
                this.log.warn("Error handling OCPP CallError {}: {}", new Object[]{err, e.toString(), e});
            }
            finally {
                this.processNextPendingMessage(message.getClientId());
            }
        }
    }

    private void processNextPendingMessage(ChargePointIdentity clientId) {
        this.processNextPendingMessage(this.pendingMessages.pendingMessageQueue(clientId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNextPendingMessage(Deque<PendingActionMessage> q) {
        PendingActionMessage next = null;
        Deque<PendingActionMessage> deque = q;
        synchronized (deque) {
            PendingActionMessage msg = q.peek();
            if (msg != null && msg.doProcess()) {
                next = msg;
            }
        }
        if (next != null) {
            PendingActionMessage m = next;
            this.executor.execute(() -> {
                if (m.isOutbound()) {
                    this.sendCall(m);
                } else {
                    this.processRequest(m);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCallErrorMessage(WebSocketSession session, ChargePointIdentity clientId, String messageId, TextMessage message, JsonNode tree) {
        try {
            ErrorCode errorCode;
            PendingActionMessage msg = this.pendingMessages.pollPendingMessage(clientId, messageId);
            if (msg == null) {
                this.log.warn("OCPP {} <<< Original Call message {} not found; ignoring CallError message: {}", new Object[]{clientId, messageId, message.getPayload()});
                return;
            }
            try {
                errorCode = this.errorCodeResolver.errorCodeForName(tree.path(2).asText());
            }
            catch (IllegalArgumentException e) {
                this.log.warn("OCPP {} <<< Error code {} not valid; ignoring CallError message: {}", new Object[]{clientId, tree.path(2).asText(), message.getPayload()});
                this.processNextPendingMessage(clientId);
                return;
            }
            Map details = null;
            try {
                details = (Map)this.mapper.treeToValue((TreeNode)tree.path(4), Map.class);
            }
            catch (JsonProcessingException e) {
                this.log.warn("OCPP {} <<< Error parsing CallError details object {}, ignoring: {}", new Object[]{clientId, tree.path(4), e.toString()});
            }
            ErrorCodeException err = new ErrorCodeException(errorCode, details, tree.path(3).asText(), null);
            msg.getHandler().handleActionMessageResult(msg.getMessage(), null, (Throwable)err);
        }
        finally {
            this.processNextPendingMessage(clientId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCallResultMessage(WebSocketSession session, ChargePointIdentity clientId, String messageId, TextMessage message, JsonNode tree) {
        try {
            PendingActionMessage msg = this.pendingMessages.pollPendingMessage(clientId, messageId);
            if (msg == null) {
                this.log.warn("OCPP {} <<< Original Call message {} not found; ignoring CallError message: {}", new Object[]{clientId, messageId, message.getPayload()});
                return;
            }
            ErrorCodeException err = null;
            Object payload = null;
            try {
                payload = this.chargePointActionPayloadDecoder.decodeActionPayload(msg.getMessage().getAction(), true, tree.path(2));
            }
            catch (IOException e) {
                err = new ErrorCodeException(this.errorCode(RpcError.PayloadSyntaxError), null, "Error parsing payload: " + e.getMessage(), (Throwable)e);
            }
            this.willProcessCallResponse(msg, payload, (Throwable)err);
            msg.getHandler().handleActionMessageResult(msg.getMessage(), payload, (Throwable)err);
        }
        finally {
            this.processNextPendingMessage(clientId);
        }
    }

    private boolean sendCall(WebSocketSession session, ChargePointIdentity clientId, String messageId, Action action, Object payload) {
        Object[] msg = new Object[]{MessageType.Call.getNumber(), messageId, action.getName(), payload};
        String json = null;
        try {
            json = this.mapper.writeValueAsString((Object)msg);
            this.log.trace("OCPP {} >>> {}", (Object)clientId, (Object)json);
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)json));
            this.didSendCall(clientId, messageId, action, payload, json, null);
            return true;
        }
        catch (IOException e) {
            this.log.warn("OCPP {} >>> Communication error sending Call for message ID {}: {}", new Object[]{clientId, messageId, e.getMessage()});
            this.didSendCall(clientId, messageId, action, payload, json, e);
            return false;
        }
    }

    protected void didSendCall(ChargePointIdentity clientId, String messageId, Action action, Object payload, String json, Throwable exception) {
    }

    private boolean sendCallResult(WebSocketSession session, ChargePointIdentity clientId, String messageId, Object payload) {
        Object[] msg = new Object[]{MessageType.CallResult.getNumber(), messageId, payload};
        String json = null;
        try {
            json = this.mapper.writeValueAsString((Object)msg);
            this.log.trace("OCPP {} >>> {}", (Object)clientId, (Object)json);
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)json));
            this.didSendCallResult(clientId, messageId, payload, json, null);
            return true;
        }
        catch (IOException e) {
            this.log.warn("OCPP {} >>> Communication error sending CallResult for message ID {}: {}", new Object[]{clientId, messageId, e.getMessage()});
            this.didSendCallResult(clientId, messageId, payload, json, e);
            return false;
        }
    }

    protected void didSendCallResult(ChargePointIdentity clientId, String messageId, Object payload, String json, Throwable exception) {
    }

    private boolean sendCallError(WebSocketSession session, ChargePointIdentity clientId, String messageId, ErrorCode errorCode, String errorDescription, Map<String, ?> details) {
        Object[] msg = new Object[]{MessageType.CallError.getNumber(), messageId, errorCode.getName(), errorDescription, details != null ? details : Collections.emptyMap()};
        String json = null;
        try {
            json = this.mapper.writeValueAsString((Object)msg);
            this.log.trace("OCPP {} >>> {}", (Object)clientId, (Object)json);
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)json));
            this.didSendCallError(clientId, messageId, errorCode, errorDescription, details, json, null);
            return true;
        }
        catch (IOException e) {
            this.log.warn("OCPP {} >>> Communication error sending CallError for message ID {}: {}", new Object[]{clientId, messageId, e.getMessage()});
            this.didSendCallError(clientId, messageId, errorCode, errorDescription, details, json, e);
            return false;
        }
    }

    protected void didSendCallError(ChargePointIdentity clientId, String messageId, ErrorCode errorCode, String errorDescription, Map<String, ?> details, String json, Throwable exception) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(PendingActionMessage msg) {
        AtomicBoolean handled = new AtomicBoolean(false);
        try {
            ActionMessage message = msg.getMessage();
            Action action = message.getAction();
            ChargePointIdentity clientId = message.getClientId();
            String messageId = message.getMessageId();
            WebSocketSession session = (WebSocketSession)this.clientSessions.get(clientId);
            if (session == null) {
                this.log.debug("Web socket not available for client {}; ignoring ActionMessage {}", (Object)clientId, (Object)message);
                handled.set(true);
                return;
            }
            this.willProcessRequest(msg);
            Set<ActionMessageProcessor<Object, Object>> procs = this.processors.get(action);
            if (procs == null) {
                this.sendCallError(session, clientId, messageId, this.errorCode(RpcError.ActionNotImplemented), "Action not supported.", null);
                handled.set(true);
                return;
            }
            ActionMessageResultHandler handler = (am, result, error) -> {
                boolean shouldRespond = handled.compareAndSet(false, true);
                if (!shouldRespond) {
                    return false;
                }
                try {
                    if (error == null) {
                        this.sendCallResult(session, clientId, messageId, result);
                    } else {
                        ErrorCode errorCode = null;
                        String errorDescription = null;
                        Map errorDetails = null;
                        if (error instanceof ErrorHolder) {
                            errorCode = ((ErrorHolder)error).getErrorCode();
                            errorDescription = ((ErrorHolder)error).getErrorDescription();
                            errorDetails = ((ErrorHolder)error).getErrorDetails();
                        }
                        if (errorCode == null) {
                            errorCode = this.errorCode(RpcError.InternalError);
                        }
                        this.sendCallError(session, clientId, messageId, errorCode, errorDescription, errorDetails);
                    }
                }
                finally {
                    this.removePendingMessage(msg);
                }
                return true;
            };
            boolean processed = false;
            for (ActionMessageProcessor<Object, Object> p : procs) {
                try {
                    if (!p.isMessageSupported(message)) continue;
                    processed = true;
                    p.processActionMessage(message, handler);
                }
                catch (AuthorizationException e) {
                    if (!handled.compareAndSet(false, true)) continue;
                    this.sendCallError(session, clientId, messageId, this.errorCode(RpcError.SecurityError), "Authorization error handling action.", null);
                }
                catch (Throwable t) {
                    if (!handled.compareAndSet(false, true)) continue;
                    this.sendCallError(session, clientId, messageId, this.errorCode(RpcError.InternalError), "Error handling action.", null);
                }
            }
            if (!processed) {
                this.sendCallError(session, clientId, messageId, this.errorCode(RpcError.InternalError), "Action not supported.", null);
                handled.set(true);
            }
        }
        finally {
            if (handled.get()) {
                this.removePendingMessage(msg);
            }
        }
    }

    protected void willProcessRequest(PendingActionMessage msg) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePendingMessage(PendingActionMessage msg) {
        Deque q;
        ChargePointIdentity clientId = msg.getMessage().getClientId();
        Deque deque = q = this.pendingMessages.pendingMessageQueue(clientId);
        synchronized (deque) {
            q.removeFirstOccurrence(msg);
            this.processNextPendingMessage(q);
        }
    }

    protected void willProcessCallResponse(PendingActionMessage msg, Object payload, Throwable exception) {
    }

    public ActionPayloadDecoder getCentralServiceActionPayloadDecoder() {
        return this.centralServiceActionPayloadDecoder;
    }

    public void setCentralServiceActionPayloadDecoder(ActionPayloadDecoder centralServiceActionPayloadDecoder) {
        this.centralServiceActionPayloadDecoder = (ActionPayloadDecoder)ObjectUtils.requireNonNullArgument((Object)centralServiceActionPayloadDecoder, (String)"centralServiceActionPayloadDecoder");
    }

    public ActionPayloadDecoder getChargePointActionPayloadDecoder() {
        return this.chargePointActionPayloadDecoder;
    }

    public void setChargePointActionPayloadDecoder(ActionPayloadDecoder chargePointActionPayloadDecoder) {
        this.chargePointActionPayloadDecoder = (ActionPayloadDecoder)ObjectUtils.requireNonNullArgument((Object)chargePointActionPayloadDecoder, (String)"chargePointActionPayloadDecoder");
    }

    public void addActionMessageProcessor(ActionMessageProcessor<?, ?> processor) {
        if (processor == null) {
            return;
        }
        for (Action action : processor.getSupportedActions()) {
            this.processors.compute(action, (k, v) -> {
                LinkedHashSet<ActionMessageProcessor> procs = v;
                if (procs == null) {
                    procs = new LinkedHashSet<ActionMessageProcessor>();
                }
                procs.add(processor);
                return procs;
            });
        }
    }

    public void removeActionMessageProcessor(ActionMessageProcessor<?, ?> processor) {
        if (processor == null) {
            return;
        }
        for (Set<ActionMessageProcessor<Object, Object>> procs : this.processors.values()) {
            procs.remove(processor);
        }
    }

    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    public TaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    public void setTaskScheduler(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    public long getPendingMessageTimeout() {
        return this.pendingMessageTimeout;
    }

    public void setPendingMessageTimeout(long pendingMessageTimeout) {
        this.pendingMessageTimeout = pendingMessageTimeout;
    }

    public int getPingFrequency() {
        return this.pingFrequencySecs;
    }

    public void setPingFrequency(int pingFrequencySecs) {
        this.pingFrequencySecs = pingFrequencySecs;
    }

    private class StartupTask
    implements Runnable {
        private StartupTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Thread.sleep(2000L);
                OcppWebSocketHandler.this.scheduleChores();
                OcppWebSocketHandler ocppWebSocketHandler = OcppWebSocketHandler.this;
                synchronized (ocppWebSocketHandler) {
                    if (OcppWebSocketHandler.this.startupTask == this) {
                        OcppWebSocketHandler.this.startupTask = null;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class PendingTimeoutChore
    implements Runnable {
        private PendingTimeoutChore() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            OcppWebSocketHandler.this.log.debug("Looking for expired pending message to clean...");
            long expiration = System.currentTimeMillis() - OcppWebSocketHandler.this.pendingMessageTimeout;
            for (Map.Entry me : OcppWebSocketHandler.this.pendingMessages.allQueues()) {
                boolean processNext = false;
                ChargePointIdentity clientId = (ChargePointIdentity)me.getKey();
                Deque q = (Deque)me.getValue();
                PendingActionMessage msg = (PendingActionMessage)q.peek();
                if (msg != null && msg.getDate() < expiration) {
                    OcppWebSocketHandler.this.log.warn("Cleaning client {} expired pending message {}", (Object)clientId, (Object)msg);
                    Deque deque = q;
                    synchronized (deque) {
                        q.removeFirstOccurrence(msg);
                        processNext = true;
                    }
                    try {
                        msg.getHandler().handleActionMessageResult(msg.getMessage(), null, (Throwable)new TimeoutException("Message not handled within configured timeout."));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (!processNext) continue;
                OcppWebSocketHandler.this.processNextPendingMessage(q);
            }
        }
    }

    private final class PingChore
    implements Runnable {
        private PingChore() {
        }

        @Override
        public void run() {
            int count = 0;
            for (Map.Entry me : OcppWebSocketHandler.this.clientSessions.entrySet()) {
                WebSocketSession wss = (WebSocketSession)me.getValue();
                Session s = null;
                if (wss instanceof NativeWebSocketSession) {
                    s = (Session)((NativeWebSocketSession)wss).getNativeSession(Session.class);
                }
                if (s == null || !s.isOpen()) continue;
                try {
                    OcppWebSocketHandler.this.executor.execute((Runnable)new PingTask((ChargePointIdentity)me.getKey(), s));
                    ++count;
                }
                catch (TaskRejectedException e) {
                    OcppWebSocketHandler.this.log.warn("Unable to schedule PING task for charge point {}: {}", me.getKey(), (Object)e);
                }
            }
            if (count > 0) {
                OcppWebSocketHandler.this.log.info("Scheduled PING frames for {} connected charge points", (Object)count);
            }
        }
    }

    private final class PingTask
    implements Runnable {
        private final ChargePointIdentity cp;
        private final Session s;

        private PingTask(ChargePointIdentity cp, Session s) {
            this.cp = cp;
            this.s = s;
        }

        @Override
        public void run() {
            try {
                if (this.s.isOpen()) {
                    ByteBuffer msg = ByteBuffer.allocate(0);
                    OcppWebSocketHandler.this.log.trace("Sending PING to charge point {}", (Object)this.cp);
                    this.s.getBasicRemote().sendPing(msg);
                }
            }
            catch (IOException e) {
                OcppWebSocketHandler.this.log.debug("Communication problem sending PING to charge point {}: {}", (Object)this.cp, (Object)e);
            }
            catch (Exception e) {
                OcppWebSocketHandler.this.log.info("Exception sending PING to charge point {}: {}", (Object)this.cp, (Object)e);
            }
        }
    }
}

