/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.v201.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.networknt.schema.AbsoluteIri;
import com.networknt.schema.JsonMetaSchema;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.NonValidationKeyword;
import com.networknt.schema.SchemaLocation;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.solarnetwork.ocpp.domain.AuthorizationStatus;
import net.solarnetwork.ocpp.domain.ChargeSessionEndReason;
import net.solarnetwork.ocpp.domain.Location;
import net.solarnetwork.ocpp.domain.Measurand;
import net.solarnetwork.ocpp.domain.Phase;
import net.solarnetwork.ocpp.domain.ReadingContext;
import net.solarnetwork.ocpp.domain.SampledValue;
import net.solarnetwork.ocpp.domain.SchemaValidationException;
import ocpp.v201.AuthorizationStatusEnum;
import ocpp.v201.LocationEnum;
import ocpp.v201.MeasurandEnum;
import ocpp.v201.PhaseEnum;
import ocpp.v201.ReadingContextEnum;
import ocpp.v201.ReasonEnum;
import ocpp.v201.SampledValue;
import ocpp.v201.UnitOfMeasure;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public final class OcppUtils {
    public static final String ACTION_REQUEST_SUFFIX = "Request";
    public static final String ACTION_RESPONSE_SUFFIX = "Response";
    public static final Function<String, String> OCPP_ACTION_TO_JSON_SCHEMA_NAME = s -> {
        if (s == null) {
            return null;
        }
        return "urn:OCPP:Cp:2:2020:3:".concat((String)s);
    };
    public static final Map<AbsoluteIri, Resource> OCPP_ACTION_SCHEMA_RESOURCES;
    public static final Map<String, SchemaLocation> OCPP_ACTION_SCHEMA_LOCATIONS;
    public static final Map<String, Class<?>> OCPP_ACTION_CLASSES;
    private static final ObjectMapper OBJECT_MAPPER;

    private OcppUtils() {
    }

    public static ObjectMapper newObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.setDateFormat((DateFormat)new StdDateFormat().withColonInTimeZone(true));
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        return mapper;
    }

    public static JsonSchemaFactory ocppSchemaFactory_v201() {
        JsonMetaSchema baseSchema = JsonMetaSchema.getV6();
        JsonMetaSchema metaSchema = JsonMetaSchema.builder((String)baseSchema.getUri(), (JsonMetaSchema)baseSchema).addKeywords(Arrays.asList(new NonValidationKeyword("comment"), new NonValidationKeyword("javaType"))).build();
        return JsonSchemaFactory.builder().defaultMetaSchemaURI(metaSchema.getUri()).addMetaSchema(metaSchema).schemaLoaders(l -> l.add(iri -> {
            Resource r = OCPP_ACTION_SCHEMA_RESOURCES.get(iri);
            if (r == null) {
                return null;
            }
            return () -> r.getInputStream();
        })).build();
    }

    public static String actionClassName(String action, boolean request) {
        return action + (request ? ACTION_REQUEST_SUFFIX : ACTION_RESPONSE_SUFFIX);
    }

    public static Object parseOcppMessage(String action, boolean request, String message, JsonSchemaFactory validator) throws IOException {
        return OcppUtils.parseOcppMessage(action, request, message, validator, OBJECT_MAPPER);
    }

    public static Object parseOcppMessage(String action, boolean request, String message, JsonSchemaFactory validator, ObjectMapper objectMapper) throws IOException {
        ObjectNode jsonPayload;
        JsonNode jsonNode = objectMapper.readTree(message);
        if (jsonNode.isNull()) {
            jsonPayload = null;
        } else if (jsonNode instanceof ObjectNode) {
            jsonPayload = (ObjectNode)jsonNode;
        } else {
            throw new IOException("OCPP message must be a JSON object.");
        }
        return OcppUtils.parseOcppMessage(action, request, jsonPayload, validator, objectMapper);
    }

    public static Object parseOcppMessage(String action, boolean request, ObjectNode message, JsonSchemaFactory validator) {
        return OcppUtils.parseOcppMessage(action, request, message, validator, OBJECT_MAPPER);
    }

    public static Object parseOcppMessage(String action, boolean request, ObjectNode message, JsonSchemaFactory validator, ObjectMapper objectMapper) {
        String actionClassName = OcppUtils.actionClassName(action, request);
        Class<?> actionClass = OCPP_ACTION_CLASSES.get(actionClassName);
        if (actionClass == null) {
            throw new IllegalArgumentException("Unknown OCPP action [" + action + "]");
        }
        try {
            JsonSchema schema;
            Set errors;
            SchemaLocation loc;
            if (validator != null && (loc = OCPP_ACTION_SCHEMA_LOCATIONS.get(actionClassName)) != null && !(errors = (schema = validator.getSchema(loc)).validate((JsonNode)message)).isEmpty()) {
                throw new SchemaValidationException((Object)message, String.format("JSON schema validation error on [%s] OCPP action: %s.", actionClassName, errors.stream().map(Object::toString).collect(Collectors.joining(", "))));
            }
            return objectMapper.treeToValue((TreeNode)message, actionClass);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Invalid JSON for [%s] OCPP action: %s", actionClassName, e.getMessage()));
        }
    }

    public static AuthorizationStatusEnum statusForStatus(AuthorizationStatus status) {
        switch (status) {
            case Accepted: {
                return AuthorizationStatusEnum.ACCEPTED;
            }
            case Blocked: {
                return AuthorizationStatusEnum.BLOCKED;
            }
            case ConcurrentTx: {
                return AuthorizationStatusEnum.CONCURRENT_TX;
            }
            case Expired: {
                return AuthorizationStatusEnum.EXPIRED;
            }
            case Invalid: {
                return AuthorizationStatusEnum.INVALID;
            }
        }
        return AuthorizationStatusEnum.UNKNOWN;
    }

    public static net.solarnetwork.ocpp.domain.SampledValue sampledValue(UUID chargeSessionId, Instant timestamp, SampledValue value) {
        SampledValue.Builder result = net.solarnetwork.ocpp.domain.SampledValue.builder().withSessionId(chargeSessionId).withTimestamp(timestamp).withContext(OcppUtils.readingContext(value.getContext())).withLocation(OcppUtils.location(value.getLocation())).withMeasurand(OcppUtils.measurand(value.getMeasurand())).withPhase(OcppUtils.phase(value.getPhase())).withUnit(OcppUtils.unit(value.getUnitOfMeasure()));
        if (value.getValue() != null) {
            BigDecimal d = BigDecimal.valueOf(value.getValue());
            result.withValue(d.stripTrailingZeros().toPlainString());
        }
        return result.build();
    }

    public static net.solarnetwork.ocpp.domain.UnitOfMeasure unit(UnitOfMeasure unit) {
        try {
            return net.solarnetwork.ocpp.domain.UnitOfMeasure.valueOf((String)unit.getUnit());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return net.solarnetwork.ocpp.domain.UnitOfMeasure.Unknown;
        }
    }

    public static Phase phase(PhaseEnum phase) {
        if (phase == null) {
            return null;
        }
        try {
            return Phase.valueOf((String)phase.value().replace("-", ""));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return Phase.Unknown;
        }
    }

    public static Measurand measurand(MeasurandEnum measurand) {
        try {
            return Measurand.valueOf((String)measurand.value().replace(".", ""));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return Measurand.Unknown;
        }
    }

    public static Location location(LocationEnum location) {
        try {
            return Location.valueOf((String)location.value());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return Location.Outlet;
        }
    }

    public static ReadingContext readingContext(ReadingContextEnum context) {
        try {
            return ReadingContext.valueOf((String)context.value().replace(".", ""));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return ReadingContext.Unknown;
        }
    }

    public static ChargeSessionEndReason reason(ReasonEnum reason) {
        if (reason == null) {
            return ChargeSessionEndReason.Local;
        }
        try {
            return ChargeSessionEndReason.valueOf((String)reason.value());
        }
        catch (IllegalArgumentException e) {
            return ChargeSessionEndReason.Unknown;
        }
    }

    static {
        HashMap<AbsoluteIri, Resource> uriMappings = new HashMap<AbsoluteIri, Resource>();
        PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver(OcppUtils.class.getClassLoader());
        try {
            for (Resource r : resourceResolver.getResources("classpath:schema/json/ocpp/v201/*.json")) {
                String name = r.getFilename();
                name = name.substring(0, name.lastIndexOf(46));
                uriMappings.put(AbsoluteIri.of((String)OCPP_ACTION_TO_JSON_SCHEMA_NAME.apply(name)), r);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error loading OCPP 2.0.1 JSON schema resources from classpath:schema/json/ocpp/v201/*.json: " + e.getMessage(), e);
        }
        OCPP_ACTION_SCHEMA_RESOURCES = Collections.unmodifiableMap(uriMappings);
        HashMap classMappings = new HashMap();
        HashMap<String, SchemaLocation> locationMappings = new HashMap<String, SchemaLocation>();
        for (AbsoluteIri iri : OCPP_ACTION_SCHEMA_RESOURCES.keySet()) {
            String action = iri.toString();
            action = action.substring(action.lastIndexOf(58) + 1);
            String className = "ocpp.v201." + action;
            try {
                classMappings.put(action, OcppUtils.class.getClassLoader().loadClass(className));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Error loading OCPP 2.0.1 action class " + className + ": " + e.getMessage(), e);
            }
            locationMappings.put(action, SchemaLocation.of((String)iri.toString()));
        }
        OCPP_ACTION_CLASSES = Collections.unmodifiableMap(classMappings);
        OCPP_ACTION_SCHEMA_LOCATIONS = Collections.unmodifiableMap(locationMappings);
        OBJECT_MAPPER = OcppUtils.newObjectMapper();
    }
}

