/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.v201.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.JsonSchemaFactory;
import java.io.IOException;
import net.solarnetwork.ocpp.domain.Action;
import net.solarnetwork.ocpp.domain.SchemaValidationException;
import net.solarnetwork.ocpp.v201.util.OcppUtils;
import net.solarnetwork.util.ObjectUtils;

public class ActionPayloadDecoder
implements net.solarnetwork.ocpp.json.ActionPayloadDecoder {
    private final JsonSchemaFactory validator;
    private final ObjectMapper objectMapper;

    public ActionPayloadDecoder() {
        this(null);
    }

    public ActionPayloadDecoder(JsonSchemaFactory validator) {
        this(OcppUtils.newObjectMapper(), validator);
    }

    public ActionPayloadDecoder(ObjectMapper objectMapper, JsonSchemaFactory validator) {
        this.objectMapper = (ObjectMapper)ObjectUtils.requireNonNullArgument((Object)objectMapper, (String)"objectMapper");
        this.validator = validator;
    }

    public <T> T decodeActionPayload(Action action, boolean forResult, JsonNode payload) throws IOException {
        if (payload.isNull()) {
            return null;
        }
        if (!(payload instanceof ObjectNode)) {
            throw new SchemaValidationException((Object)payload, "Message is not a JSON object.");
        }
        Object result = OcppUtils.parseOcppMessage(action.getName(), !forResult, (ObjectNode)payload, this.validator, this.objectMapper);
        return (T)result;
    }
}

