/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.v201.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.solarnetwork.ocpp.domain.ActionMessage;
import net.solarnetwork.ocpp.domain.AuthorizationInfo;
import net.solarnetwork.ocpp.domain.ChargePointIdentity;
import net.solarnetwork.ocpp.domain.ChargeSession;
import net.solarnetwork.ocpp.domain.ChargeSessionEndInfo;
import net.solarnetwork.ocpp.domain.ChargeSessionStartInfo;
import net.solarnetwork.ocpp.domain.ErrorCode;
import net.solarnetwork.ocpp.domain.ErrorCodeException;
import net.solarnetwork.ocpp.service.ActionMessageResultHandler;
import net.solarnetwork.ocpp.service.AuthorizationException;
import net.solarnetwork.ocpp.service.BaseActionMessageProcessor;
import net.solarnetwork.ocpp.service.cs.ChargeSessionManager;
import net.solarnetwork.ocpp.v201.domain.Action;
import net.solarnetwork.ocpp.v201.domain.ActionErrorCode;
import net.solarnetwork.ocpp.v201.util.OcppUtils;
import net.solarnetwork.util.ObjectUtils;
import ocpp.v201.AuthorizationStatusEnum;
import ocpp.v201.EVSE;
import ocpp.v201.IdToken;
import ocpp.v201.IdTokenInfo;
import ocpp.v201.LocationEnum;
import ocpp.v201.MeasurandEnum;
import ocpp.v201.MeterValue;
import ocpp.v201.ReadingContextEnum;
import ocpp.v201.SampledValue;
import ocpp.v201.Transaction;
import ocpp.v201.TransactionEventEnum;
import ocpp.v201.TransactionEventRequest;
import ocpp.v201.TransactionEventResponse;
import ocpp.v201.UnitOfMeasure;

public class TransactionEventProcessor
extends BaseActionMessageProcessor<TransactionEventRequest, TransactionEventResponse> {
    public static final Set<net.solarnetwork.ocpp.domain.Action> SUPPORTED_ACTIONS = Collections.singleton(Action.TransactionEvent);
    private final ChargeSessionManager chargeSessionManager;

    public TransactionEventProcessor(ChargeSessionManager chargeSessionManager) {
        super(TransactionEventRequest.class, TransactionEventResponse.class, SUPPORTED_ACTIONS);
        this.chargeSessionManager = (ChargeSessionManager)ObjectUtils.requireNonNullArgument((Object)chargeSessionManager, (String)"chargeSessionManager");
    }

    public void processActionMessage(ActionMessage<TransactionEventRequest> message, ActionMessageResultHandler<TransactionEventRequest, TransactionEventResponse> resultHandler) {
        ChargePointIdentity chargePointId = message.getClientId();
        TransactionEventRequest req = (TransactionEventRequest)message.getMessage();
        if (req == null || chargePointId == null) {
            ErrorCodeException err = new ErrorCodeException((ErrorCode)ActionErrorCode.FormatViolation, "Missing StartTransactionRequest message.");
            resultHandler.handleActionMessageResult(message, null, (Throwable)err);
            return;
        }
        TransactionEventEnum eventType = req.getEventType();
        try {
            switch (eventType) {
                case STARTED: {
                    this.processStartTransaction(message, resultHandler, chargePointId, req);
                    break;
                }
                case UPDATED: {
                    this.processUpdateTransaction(message, resultHandler, chargePointId, req);
                    break;
                }
                case ENDED: {
                    this.processEndTransaction(message, resultHandler, chargePointId, req);
                }
            }
        }
        catch (AuthorizationException e) {
            IdTokenInfo tagInfo = new IdTokenInfo(OcppUtils.statusForStatus(e.getInfo().getStatus()));
            TransactionEventResponse res = new TransactionEventResponse();
            res.setIdTokenInfo(tagInfo);
            resultHandler.handleActionMessageResult(message, (Object)res, null);
        }
        catch (Throwable t) {
            ErrorCodeException err = new ErrorCodeException((ErrorCode)ActionErrorCode.InternalError, "Internal error: " + t.getMessage());
            resultHandler.handleActionMessageResult(message, null, (Throwable)err);
        }
    }

    protected void processStartTransaction(ActionMessage<TransactionEventRequest> message, ActionMessageResultHandler<TransactionEventRequest, TransactionEventResponse> resultHandler, ChargePointIdentity chargePointId, TransactionEventRequest request) {
        Transaction tx;
        IdToken idToken = request.getIdToken();
        long meterStartValue = this.findEnergyReadingSampledValue(request.getMeterValue(), ReadingContextEnum.TRANSACTION_BEGIN);
        ChargeSessionStartInfo.Builder startInfoDetails = ChargeSessionStartInfo.builder().withChargePointId(chargePointId).withAuthorizationId(idToken != null ? idToken.getIdToken() : null).withTimestampStart(request.getTimestamp()).withReservationId(request.getReservationId()).withMeterStart(meterStartValue);
        EVSE evse = request.getEvse();
        if (evse != null) {
            if (evse.getId() != null) {
                startInfoDetails.withEvseId(evse.getId().intValue());
            }
            if (evse.getConnectorId() != null) {
                startInfoDetails.withConnectorId(evse.getConnectorId().intValue());
            }
        }
        if ((tx = request.getTransactionInfo()) != null) {
            startInfoDetails.withTransactionId(tx.getTransactionId());
        }
        ChargeSessionStartInfo startInfo = startInfoDetails.build();
        this.log.trace("Received transaction start request: {}", (Object)startInfo);
        ChargeSession session = this.chargeSessionManager.startChargingSession(startInfo);
        this.log.info("Charge session {} started for tx {}", (Object)session.getId(), (Object)session.getTransactionId());
        IdTokenInfo tagInfo = new IdTokenInfo(AuthorizationStatusEnum.ACCEPTED);
        TransactionEventResponse res = new TransactionEventResponse();
        res.setIdTokenInfo(tagInfo);
        resultHandler.handleActionMessageResult(message, (Object)res, null);
    }

    protected void processUpdateTransaction(ActionMessage<TransactionEventRequest> message, ActionMessageResultHandler<TransactionEventRequest, TransactionEventResponse> resultHandler, ChargePointIdentity chargePointId, TransactionEventRequest request) {
        EVSE evse = request.getEvse();
        List values = request.getMeterValue();
        ArrayList newReadings = new ArrayList();
        if (values != null && !values.isEmpty()) {
            for (MeterValue mv : values) {
                mv.getSampledValue().stream().map(v -> OcppUtils.sampledValue(null, mv.getTimestamp(), v)).forEach(newReadings::add);
            }
        }
        if (!newReadings.isEmpty()) {
            this.log.info("Saving charge point {} EVSE {} connector {} readings: {}", new Object[]{chargePointId, evse.getId(), evse.getConnectorId(), newReadings});
            this.chargeSessionManager.addChargingSessionReadings(chargePointId, evse.getId(), evse.getConnectorId(), newReadings);
        }
        IdTokenInfo tagInfo = new IdTokenInfo(AuthorizationStatusEnum.ACCEPTED);
        TransactionEventResponse res = new TransactionEventResponse();
        res.setIdTokenInfo(tagInfo);
        resultHandler.handleActionMessageResult(message, (Object)res, null);
    }

    protected void processEndTransaction(ActionMessage<TransactionEventRequest> message, ActionMessageResultHandler<TransactionEventRequest, TransactionEventResponse> resultHandler, ChargePointIdentity chargePointId, TransactionEventRequest request) {
        Transaction tx = request.getTransactionInfo();
        ChargeSession session = this.chargeSessionManager.getActiveChargingSession(chargePointId, tx.getTransactionId());
        if (session == null) {
            resultHandler.handleActionMessageResult(message, (Object)new TransactionEventResponse(), null);
            return;
        }
        long meterEndValue = this.findEnergyReadingSampledValue(request.getMeterValue(), ReadingContextEnum.TRANSACTION_END);
        IdToken idToken = request.getIdToken();
        ChargeSessionEndInfo info = ChargeSessionEndInfo.builder().withChargePointId(chargePointId).withAuthorizationId(idToken != null ? idToken.getIdToken() : null).withTransactionId(tx.getTransactionId()).withMeterEnd(meterEndValue).withTimestampEnd(request.getTimestamp()).withReason(OcppUtils.reason(tx.getStoppedReason())).withTransactionData(this.sampledValues((UUID)session.getId(), request.getMeterValue())).build();
        this.log.info("Received transaction end request: {}", (Object)info);
        AuthorizationInfo authInfo = this.chargeSessionManager.endChargingSession(info);
        IdTokenInfo tokenInfo = null;
        if (authInfo != null) {
            tokenInfo = new IdTokenInfo(OcppUtils.statusForStatus(authInfo.getStatus()));
        }
        TransactionEventResponse res = new TransactionEventResponse();
        res.setIdTokenInfo(tokenInfo);
        resultHandler.handleActionMessageResult(message, (Object)res, null);
    }

    private long findEnergyReadingSampledValue(List<MeterValue> meters, ReadingContextEnum context) {
        if (meters == null) {
            return 0L;
        }
        SampledValue sv = meters.stream().flatMap(m -> m.getSampledValue() != null ? m.getSampledValue().stream() : Collections.emptyList().stream()).filter(s -> !(s.getValue() == null || s.getMeasurand() != MeasurandEnum.ENERGY_ACTIVE_IMPORT_REGISTER || s.getLocation() != null && s.getLocation() != LocationEnum.OUTLET || s.getContext() != null && s.getContext() != context && s.getContext() != ReadingContextEnum.SAMPLE_PERIODIC || s.getPhase() != null)).findFirst().orElse(null);
        if (sv != null) {
            BigDecimal d = BigDecimal.valueOf(sv.getValue());
            UnitOfMeasure unit = sv.getUnitOfMeasure();
            if (unit != null) {
                if (unit.getMultiplier() != null) {
                    d = d.scaleByPowerOfTen(unit.getMultiplier());
                }
                if (net.solarnetwork.ocpp.domain.UnitOfMeasure.kWh.name().equalsIgnoreCase(unit.getUnit())) {
                    d = d.scaleByPowerOfTen(3);
                }
            }
            return d.longValue();
        }
        return 0L;
    }

    private List<net.solarnetwork.ocpp.domain.SampledValue> sampledValues(UUID chargeSessionId, List<MeterValue> transactionData) {
        ArrayList<net.solarnetwork.ocpp.domain.SampledValue> result = null;
        if (transactionData != null && !transactionData.isEmpty()) {
            for (MeterValue v : transactionData) {
                if (v.getSampledValue() == null || v.getSampledValue().isEmpty()) continue;
                for (SampledValue sv : v.getSampledValue()) {
                    if (result == null) {
                        result = new ArrayList<net.solarnetwork.ocpp.domain.SampledValue>(16);
                    }
                    result.add(OcppUtils.sampledValue(chargeSessionId, v.getTimestamp(), sv));
                }
            }
        }
        return result;
    }
}

