/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.v201.service;

import java.util.Collections;
import java.util.Set;
import net.solarnetwork.ocpp.domain.ActionMessage;
import net.solarnetwork.ocpp.domain.ChargePointIdentity;
import net.solarnetwork.ocpp.domain.ChargePointStatus;
import net.solarnetwork.ocpp.domain.ErrorCode;
import net.solarnetwork.ocpp.domain.ErrorCodeException;
import net.solarnetwork.ocpp.domain.StatusNotification;
import net.solarnetwork.ocpp.service.ActionMessageResultHandler;
import net.solarnetwork.ocpp.service.BaseActionMessageProcessor;
import net.solarnetwork.ocpp.service.cs.ChargePointManager;
import net.solarnetwork.ocpp.v201.domain.Action;
import net.solarnetwork.ocpp.v201.domain.ActionErrorCode;
import net.solarnetwork.security.SecurityException;
import ocpp.v201.StatusNotificationRequest;
import ocpp.v201.StatusNotificationResponse;

public class StatusNotificationProcessor
extends BaseActionMessageProcessor<StatusNotificationRequest, StatusNotificationResponse> {
    public static final Set<net.solarnetwork.ocpp.domain.Action> SUPPORTED_ACTIONS = Collections.singleton(Action.StatusNotification);
    private final ChargePointManager chargePointManager;

    public StatusNotificationProcessor(ChargePointManager chargePointManager) {
        super(StatusNotificationRequest.class, StatusNotificationResponse.class, SUPPORTED_ACTIONS);
        if (chargePointManager == null) {
            throw new IllegalArgumentException("The chargePointManager parameter must not be null.");
        }
        this.chargePointManager = chargePointManager;
    }

    public void processActionMessage(ActionMessage<StatusNotificationRequest> message, ActionMessageResultHandler<StatusNotificationRequest, StatusNotificationResponse> resultHandler) {
        ChargePointIdentity identity = message.getClientId();
        StatusNotificationRequest req = (StatusNotificationRequest)message.getMessage();
        if (req == null || identity == null) {
            ErrorCodeException err = new ErrorCodeException((ErrorCode)ActionErrorCode.FormatViolation, "Missing StatusNotificationRequest message.");
            resultHandler.handleActionMessageResult(message, null, (Throwable)err);
            return;
        }
        StatusNotification info = StatusNotification.builder().withEvseId(req.getEvseId().intValue()).withConnectorId(req.getConnectorId().intValue()).withStatus(this.statusValue(req)).withTimestamp(req.getTimestamp()).build();
        try {
            this.chargePointManager.updateChargePointStatus(identity, info);
            resultHandler.handleActionMessageResult(message, (Object)new StatusNotificationResponse(), null);
        }
        catch (SecurityException e) {
            ErrorCodeException err = new ErrorCodeException((ErrorCode)ActionErrorCode.SecurityError, e.getMessage());
            resultHandler.handleActionMessageResult(message, null, (Throwable)err);
        }
        catch (Throwable t) {
            ErrorCodeException err = new ErrorCodeException((ErrorCode)ActionErrorCode.InternalError, "Internal error: " + t.getMessage());
            resultHandler.handleActionMessageResult(message, null, (Throwable)err);
        }
    }

    private ChargePointStatus statusValue(StatusNotificationRequest req) {
        if (req != null && req.getConnectorStatus() != null) {
            try {
                return ChargePointStatus.valueOf((String)req.getConnectorStatus().value());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return ChargePointStatus.Unknown;
    }
}

