/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.v201.service;

import java.util.Collections;
import java.util.Set;
import net.solarnetwork.ocpp.domain.ActionMessage;
import net.solarnetwork.ocpp.domain.AuthorizationInfo;
import net.solarnetwork.ocpp.domain.ErrorCode;
import net.solarnetwork.ocpp.domain.ErrorCodeException;
import net.solarnetwork.ocpp.service.ActionMessageResultHandler;
import net.solarnetwork.ocpp.service.AuthorizationService;
import net.solarnetwork.ocpp.service.BaseActionMessageProcessor;
import net.solarnetwork.ocpp.v201.domain.Action;
import net.solarnetwork.ocpp.v201.domain.ActionErrorCode;
import net.solarnetwork.ocpp.v201.util.OcppUtils;
import ocpp.v201.AuthorizeRequest;
import ocpp.v201.AuthorizeResponse;
import ocpp.v201.IdToken;
import ocpp.v201.IdTokenEnum;
import ocpp.v201.IdTokenInfo;

public class AuthorizeProcessor
extends BaseActionMessageProcessor<AuthorizeRequest, AuthorizeResponse> {
    public static final Set<net.solarnetwork.ocpp.domain.Action> SUPPORTED_ACTIONS = Collections.singleton(Action.Authorize);
    private final AuthorizationService authService;

    public AuthorizeProcessor(AuthorizationService authService) {
        super(AuthorizeRequest.class, AuthorizeResponse.class, SUPPORTED_ACTIONS);
        this.authService = authService;
    }

    public void processActionMessage(ActionMessage<AuthorizeRequest> message, ActionMessageResultHandler<AuthorizeRequest, AuthorizeResponse> resultHandler) {
        AuthorizeRequest req = (AuthorizeRequest)message.getMessage();
        if (req == null) {
            ErrorCodeException err = new ErrorCodeException((ErrorCode)ActionErrorCode.FormatViolation, "Missing AuthorizeRequest message.");
            resultHandler.handleActionMessageResult(message, null, (Throwable)err);
            return;
        }
        try {
            AuthorizationInfo info = this.authService.authorize(message.getClientId(), req.getIdToken().getIdToken());
            IdTokenInfo tagInfo = new IdTokenInfo();
            if (info.getParentId() != null) {
                tagInfo.setGroupIdToken(new IdToken(info.getParentId(), IdTokenEnum.CENTRAL));
            }
            tagInfo.setStatus(OcppUtils.statusForStatus(info.getStatus()));
            if (info.getExpiryDate() != null) {
                tagInfo.setCacheExpiryDateTime(info.getExpiryDate());
            }
            AuthorizeResponse res = new AuthorizeResponse();
            res.setIdTokenInfo(tagInfo);
            resultHandler.handleActionMessageResult(message, (Object)res, null);
        }
        catch (Throwable t) {
            ErrorCodeException err = new ErrorCodeException((ErrorCode)ActionErrorCode.InternalError, "Internal error: " + t.getMessage());
            resultHandler.handleActionMessageResult(message, null, (Throwable)err);
        }
    }
}

