/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.commons;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tomcat.util.http.fileupload.FileItem;
import org.apache.tomcat.util.http.fileupload.FileItemFactory;
import org.apache.tomcat.util.http.fileupload.FileItemIterator;
import org.apache.tomcat.util.http.fileupload.FileUpload;
import org.apache.tomcat.util.http.fileupload.FileUploadException;
import org.apache.tomcat.util.http.fileupload.RequestContext;
import org.apache.tomcat.util.http.fileupload.servlet.ServletRequestContext;
import org.springframework.web.multipart.commons.CommonsMultipartUtils;

public class ServletFileUpload
extends FileUpload {
    private static final String POST_METHOD = "POST";

    public static final boolean isMultipartContent(HttpServletRequest request) {
        if (!POST_METHOD.equalsIgnoreCase(request.getMethod())) {
            return false;
        }
        return CommonsMultipartUtils.isMultipartContent((RequestContext)new ServletRequestContext(request));
    }

    public ServletFileUpload() {
    }

    public ServletFileUpload(FileItemFactory fileItemFactory) {
        this.setFileItemFactory(fileItemFactory);
    }

    public List<FileItem> parseRequest(HttpServletRequest request) throws FileUploadException {
        return this.parseRequest((RequestContext)new ServletRequestContext(request));
    }

    public Map<String, List<FileItem>> parseParameterMap(HttpServletRequest request) throws FileUploadException {
        return this.parseParameterMap((RequestContext)new ServletRequestContext(request));
    }

    public FileItemIterator getItemIterator(HttpServletRequest request) throws FileUploadException, IOException {
        return super.getItemIterator((RequestContext)new ServletRequestContext(request));
    }

    public Map<String, List<FileItem>> parseParameterMap(RequestContext ctx) throws FileUploadException {
        List items = this.parseRequest(ctx);
        HashMap<String, List<FileItem>> itemsMap = new HashMap<String, List<FileItem>>(items.size());
        for (FileItem fileItem : items) {
            String fieldName = fileItem.getFieldName();
            ArrayList<FileItem> mappedItems = (ArrayList<FileItem>)itemsMap.get(fieldName);
            if (mappedItems == null) {
                mappedItems = new ArrayList<FileItem>();
                itemsMap.put(fieldName, mappedItems);
            }
            mappedItems.add(fileItem);
        }
        return itemsMap;
    }
}

