/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.web.support;

import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import net.solarnetwork.central.security.AuthorizationException;
import net.solarnetwork.central.security.SecurityException;
import net.solarnetwork.central.web.support.WebServiceControllerSupport;
import net.solarnetwork.domain.Result;
import net.solarnetwork.util.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.core.annotation.Order;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.PessimisticLockingFailureException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.dao.TransientDataAccessException;
import org.springframework.dao.TransientDataAccessResourceException;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.firewall.RequestRejectedException;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.TransactionException;
import org.springframework.util.unit.DataSize;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

@RestControllerAdvice
@Order(value=1000)
public class WebServiceGlobalControllerSupport {
    private static final Logger log = LoggerFactory.getLogger(WebServiceGlobalControllerSupport.class);
    @Autowired
    private MessageSource messageSource;
    @Value(value="${spring.servlet.multipart.max-file-size:1MB}")
    private DataSize maxUploadSize = DataSize.ofMegabytes((long)1L);

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.UNPROCESSABLE_ENTITY)
    public Result<?> handleMaxUploadSizeExceededException(MaxUploadSizeExceededException e, WebRequest request, Locale locale) {
        log.warn("MaxUploadSizeExceededException for {}; user [{}]", (Object)WebServiceControllerSupport.requestDescription(request), (Object)WebServiceControllerSupport.userPrincipalName(request));
        String msg = "Upload size exceeded";
        String maxSize = NumberUtils.humanReadableCount((long)(e.getMaxUploadSize() > -1L ? e.getMaxUploadSize() : this.maxUploadSize.toBytes()));
        if (this.messageSource != null) {
            msg = this.messageSource.getMessage("error.web.upload-size-exceeded", new Object[]{maxSize}, msg, locale);
        }
        return Result.error((String)"WEB.00100", (String)msg, (Result.ErrorDetail[])new Result.ErrorDetail[0]);
    }

    @ExceptionHandler(value={DataAccessResourceFailureException.class})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.TOO_MANY_REQUESTS)
    public Result<?> handleDataAccessResourceFailureException(DataAccessResourceFailureException e, WebRequest request, Locale locale) {
        log.warn("DataAccessResourceFailureException in request {}; user [{}]: {}", new Object[]{WebServiceControllerSupport.requestDescription(request), WebServiceControllerSupport.userPrincipalName(request), e.toString()});
        String msg = "Temporary connection failure";
        String msgKey = "error.dao.transientDataAccessResource";
        String code = "DAO.00206";
        if (this.messageSource != null) {
            msg = this.messageSource.getMessage(msgKey, new Object[]{e.getMostSpecificCause().getMessage()}, msg, locale);
        }
        return Result.error((String)code, (String)msg, (Result.ErrorDetail[])new Result.ErrorDetail[0]);
    }

    @ExceptionHandler(value={TransientDataAccessException.class})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.TOO_MANY_REQUESTS)
    public Result<?> handleTransientDataAccessException(TransientDataAccessException e, WebRequest request, Locale locale) {
        String code;
        String msgKey;
        String msg;
        log.warn("TransientDataAccessException in request {}; user [{}]: {}", new Object[]{WebServiceControllerSupport.requestDescription(request), WebServiceControllerSupport.userPrincipalName(request), e.toString()});
        if (e instanceof CannotAcquireLockException) {
            msg = "Deadlock loser";
            msgKey = "error.dao.deadlockLoser";
            code = "DAO.00204";
        } else if (e instanceof TransientDataAccessResourceException) {
            msg = "Temporary connection failure";
            msgKey = "error.dao.transientDataAccessResource";
            code = "DAO.00203";
        } else if (e instanceof QueryTimeoutException) {
            msg = "Query timeout";
            msgKey = "error.dao.queryTimeout";
            code = "DAO.00202";
        } else if (e instanceof PessimisticLockingFailureException) {
            msg = "Lock failure";
            msgKey = "error.dao.pessimisticLockingFailure";
            code = "DAO.00201";
        } else if (e instanceof ConcurrencyFailureException) {
            msg = "Concurrency failure";
            msgKey = "error.dao.concurrencyFailure";
            code = "DAO.00205";
        } else {
            msg = "Data integrity violation";
            msgKey = "error.dao.transientDataAccess";
            code = "DAO.00200";
        }
        if (this.messageSource != null) {
            msg = this.messageSource.getMessage(msgKey, new Object[]{e.getMostSpecificCause().getMessage()}, msg, locale);
        }
        return Result.error((String)code, (String)msg, (Result.ErrorDetail[])new Result.ErrorDetail[0]);
    }

    @ExceptionHandler(value={TransactionException.class})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.TOO_MANY_REQUESTS)
    public Result<?> handleTransactionException(TransactionException e, WebRequest request, Locale locale) {
        String code;
        String msgKey;
        String msg;
        log.warn("TransactionException in request {}; user [{}]: {}", new Object[]{WebServiceControllerSupport.requestDescription(request), WebServiceControllerSupport.userPrincipalName(request), e.toString()});
        if (e instanceof CannotCreateTransactionException) {
            Throwable t = e.getRootCause();
            if (t != null && "org.apache.tomcat.jdbc.pool.PoolExhaustedException".equals(t.getClass().getName())) {
                msg = "Connection pool exhausted";
                msgKey = "error.dao.poolExhausted";
                code = "DAO.00302";
            } else {
                msg = "Cannot create transaction";
                msgKey = "error.dao.cannotCreateTransaction";
                code = "DAO.00301";
            }
        } else {
            msg = "Transaction error";
            msgKey = "error.dao.transaction";
            code = "DAO.00300";
        }
        if (this.messageSource != null) {
            msg = this.messageSource.getMessage(msgKey, new Object[]{e.getMostSpecificCause().getMessage()}, msg, locale);
        }
        return Result.error((String)code, (String)msg, (Result.ErrorDetail[])new Result.ErrorDetail[0]);
    }

    @ExceptionHandler(value={AuthorizationException.class})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.FORBIDDEN)
    public Result<?> handleAuthorizationException(AuthorizationException e, WebRequest request) {
        log.debug("AuthorizationException in request {}: {}", (Object)WebServiceControllerSupport.requestDescription(request), (Object)e.getMessage());
        return Result.error(null, (String)e.getReason().toString(), (Result.ErrorDetail[])new Result.ErrorDetail[0]);
    }

    @ExceptionHandler(value={SecurityException.class})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.FORBIDDEN)
    public Result<?> handleSecurityException(SecurityException e, WebRequest request) {
        log.info("SecurityException in request {}; user [{}]: {}", new Object[]{WebServiceControllerSupport.requestDescription(request), WebServiceControllerSupport.userPrincipalName(request), e.getMessage()});
        return Result.error(null, (String)e.getMessage(), (Result.ErrorDetail[])new Result.ErrorDetail[0]);
    }

    @ExceptionHandler(value={BadCredentialsException.class})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.FORBIDDEN)
    public Result<?> handleBadCredentialsException(BadCredentialsException e, WebRequest request) {
        log.info("BadCredentialsException in request {}: {}", (Object)WebServiceControllerSupport.requestDescription(request), (Object)e.getMessage());
        return Result.error(null, (String)e.getMessage(), (Result.ErrorDetail[])new Result.ErrorDetail[0]);
    }

    @ExceptionHandler(value={AuthenticationException.class})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.UNAUTHORIZED)
    public Result<?> handleAuthenticationException(AuthenticationException e, WebRequest request) {
        log.info("AuthenticationException in request {}: {}", (Object)WebServiceControllerSupport.requestDescription(request), (Object)e.getMessage());
        return Result.error(null, (String)e.getMessage(), (Result.ErrorDetail[])new Result.ErrorDetail[0]);
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.FORBIDDEN)
    public Result<?> handleAuthenticationException(AccessDeniedException e, WebRequest request) {
        log.info("AccessDeniedException in request {}: {}", (Object)WebServiceControllerSupport.requestDescription(request), (Object)e.getMessage());
        return Result.error(null, (String)e.getMessage(), (Result.ErrorDetail[])new Result.ErrorDetail[0]);
    }

    @ExceptionHandler(value={RequestRejectedException.class})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.BAD_REQUEST)
    public Result<?> handleRequestRejectedException(RequestRejectedException e, WebRequest request) {
        log.warn("RequestRejectedException in request {}; user [{}]: {}", new Object[]{WebServiceControllerSupport.requestDescription(request), WebServiceControllerSupport.userPrincipalName(request), e.getMessage()});
        return Result.error(null, (String)e.getMessage(), (Result.ErrorDetail[])new Result.ErrorDetail[0]);
    }

    @ExceptionHandler(value={ExecutionException.class})
    @ResponseBody
    @ResponseStatus
    public Result<?> handleExecutionException(ExecutionException e, WebRequest request) {
        log.debug("ExecutionException in request {}; user [{}]", new Object[]{WebServiceControllerSupport.requestDescription(request), WebServiceControllerSupport.userPrincipalName(request), e});
        Throwable cause = e;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        if (cause instanceof IllegalArgumentException) {
            return this.handleIllegalArgumentException((IllegalArgumentException)cause, request);
        }
        return Result.error((String)"EE.00500", (String)cause.getMessage(), (Result.ErrorDetail[])new Result.ErrorDetail[0]);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.UNPROCESSABLE_ENTITY)
    public Result<?> handleIllegalArgumentException(IllegalArgumentException e, WebRequest request) {
        log.debug("IllegalArgumentException in request {}", (Object)WebServiceControllerSupport.requestDescription(request), (Object)e);
        return Result.error(null, (String)("Illegal argument: " + e.getMessage()), (Result.ErrorDetail[])new Result.ErrorDetail[0]);
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseBody
    @ResponseStatus
    public Result<?> handleRuntimeException(RuntimeException e, WebRequest request) {
        Throwable cause = e;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        if (cause instanceof IllegalArgumentException) {
            return this.handleIllegalArgumentException((IllegalArgumentException)cause, request);
        }
        log.error("RuntimeException in request {}; user [{}]", new Object[]{WebServiceControllerSupport.requestDescription(request), WebServiceControllerSupport.userPrincipalName(request), e});
        return Result.error(null, (String)"Internal error", (Result.ErrorDetail[])new Result.ErrorDetail[0]);
    }

    @ExceptionHandler(value={Error.class})
    @ResponseBody
    @ResponseStatus
    public Result<?> handleError(Error e, WebRequest request) {
        log.warn("Error in request {}", (Object)WebServiceControllerSupport.requestDescription(request), (Object)e);
        Throwable cause = e;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return Result.error((String)"E.00500", (String)cause.getMessage(), (Result.ErrorDetail[])new Result.ErrorDetail[0]);
    }

    @ExceptionHandler(value={HttpMessageConversionException.class})
    @ResponseBody
    @ResponseStatus
    public Result<?> handleHttpMessageConversionException(HttpMessageConversionException e, WebRequest request) {
        Object cause = e;
        while (((Throwable)cause).getCause() != null) {
            if (!"org.apache.catalina.connector.ClientAbortException".equals((cause = ((Throwable)cause).getCause()).getClass().getName())) continue;
            log.debug("ClientAbortException in request {}", (Object)WebServiceControllerSupport.requestDescription(request), (Object)e);
            return Result.error((String)"WEB.00201", (String)"Client abort.", (Result.ErrorDetail[])new Result.ErrorDetail[0]);
        }
        log.error("HttpMessageConversionException in request {}; user [{}]", new Object[]{WebServiceControllerSupport.requestDescription(request), WebServiceControllerSupport.userPrincipalName(request), e});
        return Result.error((String)"WEB.00200", (String)e.getMessage(), (Result.ErrorDetail[])new Result.ErrorDetail[0]);
    }

    @ExceptionHandler(value={IOException.class})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.UNPROCESSABLE_ENTITY)
    public Result<?> handleIOException(IOException e, WebRequest request) {
        log.warn("IOException in request {}; user [{}]", new Object[]{WebServiceControllerSupport.requestDescription(request), WebServiceControllerSupport.userPrincipalName(request), e});
        return Result.error((String)"WEB.09000", (String)e.getMessage(), (Result.ErrorDetail[])new Result.ErrorDetail[0]);
    }
}

