/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.web.support;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validator;
import java.security.Principal;
import java.sql.SQLException;
import java.time.DateTimeException;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import net.solarnetwork.central.ValidationException;
import net.solarnetwork.central.support.ExceptionUtils;
import net.solarnetwork.central.web.GlobalExceptionRestController;
import net.solarnetwork.domain.Result;
import net.solarnetwork.util.StringUtils;
import net.solarnetwork.web.jakarta.domain.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.core.annotation.Order;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartException;

@RestControllerAdvice(annotations={GlobalExceptionRestController.class})
@Order(value=100)
public final class WebServiceControllerSupport {
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static final String DEFAULT_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm";
    public static final String DEFAULT_DATE_TIME_FORMAT_Z = "yyyy-MM-dd'T'HH:mm'Z'";
    public static final String ALT_DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm";
    public static final String ALT_DATE_TIME_FORMAT_Z = "yyyy-MM-dd HH:mm'Z'";
    public static final String DEFAULT_TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String DEFAULT_TIMESTAMP_FORMAT_Z = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String ALT_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String ALT_TIMESTAMP_FORMAT_Z = "yyyy-MM-dd HH:mm:ss.SSS'Z'";
    public static final String ANONYMOUS_USER_PRINCIPAL = "anonymous";
    private static final Logger log = LoggerFactory.getLogger(WebServiceControllerSupport.class);
    @Autowired
    private MessageSource messageSource;
    @Autowired(required=false)
    private Validator validator;

    public static String requestDescription(WebRequest request) {
        StringBuilder buf = new StringBuilder(request.getDescription(false));
        Map params = request.getParameterMap();
        if (params != null) {
            buf.append("?");
            boolean next = false;
            for (Map.Entry e : params.entrySet()) {
                if (next) {
                    buf.append('&');
                } else {
                    next = true;
                }
                buf.append((String)e.getKey()).append("=");
                String[] vals = (String[])e.getValue();
                if (vals == null || vals.length < 1) continue;
                if (vals.length == 1) {
                    buf.append(vals[0]);
                    continue;
                }
                int len = vals.length;
                for (int i = 0; i < len; ++i) {
                    if (i > 0) {
                        buf.append(",");
                    }
                    buf.append(vals[i]);
                }
            }
        }
        return buf.toString();
    }

    public static String userPrincipalName(WebRequest request) {
        Principal userPrincipal = request.getUserPrincipal();
        if (userPrincipal != null) {
            return userPrincipal.getName();
        }
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null) {
            String data;
            Map dataMap;
            String name;
            int idx = authHeader.indexOf(32);
            if (idx > 0 && idx < authHeader.length() && (name = (String)(dataMap = StringUtils.commaDelimitedStringToMap((String)(data = authHeader.substring(idx + 1)))).get("Credential")) != null) {
                return name;
            }
            return authHeader;
        }
        return ANONYMOUS_USER_PRINCIPAL;
    }

    @ExceptionHandler(value={BeanInstantiationException.class})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.UNPROCESSABLE_ENTITY)
    public Response<?> handleBeanInstantiationException(BeanInstantiationException e, WebRequest request) {
        log.debug("BeanInstantiationException in request {}: {}", new Object[]{WebServiceControllerSupport.requestDescription(request), e.getMessage(), e});
        return new Response(Boolean.FALSE, "422", "Malformed request data.", null);
    }

    @ExceptionHandler(value={TypeMismatchException.class})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.UNPROCESSABLE_ENTITY)
    public Response<?> handleTypeMismatchException(TypeMismatchException e, WebRequest request, HttpServletResponse response) {
        log.debug("TypeMismatchException in request {}", (Object)WebServiceControllerSupport.requestDescription(request), (Object)e);
        return new Response(Boolean.FALSE, null, "Illegal argument: " + e.getMessage(), null);
    }

    @ExceptionHandler(value={UnsupportedOperationException.class})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.NOT_FOUND)
    public Response<?> handleUnsupportedOperationException(UnsupportedOperationException e, WebRequest request) {
        log.debug("UnsupportedOperationException in request {}", (Object)WebServiceControllerSupport.requestDescription(request), (Object)e);
        return new Response(Boolean.FALSE, "404", e.getMessage(), null);
    }

    @ExceptionHandler(value={JsonParseException.class})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.UNPROCESSABLE_ENTITY)
    public Response<?> handleJsonParseException(JsonProcessingException e, WebRequest request) {
        log.debug("JsonProcessingException in request {}", (Object)WebServiceControllerSupport.requestDescription(request), (Object)e);
        return new Response(Boolean.FALSE, null, "Malformed JSON: " + e.getOriginalMessage(), null);
    }

    @ExceptionHandler(value={DateTimeParseException.class})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.UNPROCESSABLE_ENTITY)
    public Response<?> handleDateTimeParseException(DateTimeParseException e, WebRequest request) {
        log.debug("DateTimeParseException in request {}", (Object)WebServiceControllerSupport.requestDescription(request), (Object)e);
        return new Response(Boolean.FALSE, null, "Malformed date string: " + e.getMessage(), null);
    }

    @ExceptionHandler(value={DateTimeException.class})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.UNPROCESSABLE_ENTITY)
    public Response<?> handleDateTimeException(DateTimeException e, WebRequest request) {
        log.debug("DateTimeException in request {}", (Object)WebServiceControllerSupport.requestDescription(request), (Object)e);
        return new Response(Boolean.FALSE, null, "Date exception: " + e.getMessage(), null);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.UNPROCESSABLE_ENTITY)
    public Response<?> handleHttpMessageNotReadableException(HttpMessageNotReadableException e, WebRequest request) {
        Throwable t = e.getMostSpecificCause();
        if (t instanceof JsonProcessingException) {
            return this.handleJsonParseException((JsonProcessingException)t, request);
        }
        if (t instanceof DateTimeParseException) {
            return this.handleDateTimeParseException((DateTimeParseException)t, request);
        }
        log.warn("HttpMessageNotReadableException in request {}: {}", (Object)WebServiceControllerSupport.requestDescription(request), (Object)e.toString());
        return new Response(Boolean.FALSE, null, "Malformed request: " + e.getMessage(), null);
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.UNPROCESSABLE_ENTITY)
    public Response<?> handleDataIntegrityViolationException(DataIntegrityViolationException e, WebRequest request, Locale locale, HttpServletRequest servletRequest) {
        String code;
        Object msgKey;
        String msg;
        log.warn("DataIntegrityViolationException in request {}: {}", (Object)WebServiceControllerSupport.requestDescription(request), (Object)e.toString());
        Object[] params = new Object[]{e.getMostSpecificCause().getMessage()};
        if (e instanceof DuplicateKeyException) {
            msg = "Duplicate key";
            msgKey = "error.dao.duplicateKey";
            code = "DAO.00101";
        } else {
            SQLException sqlEx = null;
            Object t = e;
            String sqlState = null;
            while (t.getCause() != null) {
                if (!((t = t.getCause()) instanceof SQLException)) continue;
                sqlEx = (SQLException)t;
                break;
            }
            if (sqlEx != null) {
                log.warn("Root SQLException from {}: {}", new Object[]{e.getMessage(), sqlEx.getMessage(), sqlEx});
                sqlState = sqlEx.getSQLState();
                params[0] = sqlEx.getMessage();
            }
            if (sqlState != null && sqlState.startsWith("22")) {
                msg = "Invalid query parameter";
                msgKey = "error.dao.sqlState.class.22";
                code = "DAO.00103";
            } else if (sqlState != null && sqlState.startsWith("23")) {
                msg = "Integrity constraint violation";
                if (sqlState.equals("23503")) {
                    msgKey = "error.dao.sqlState.class.23503";
                    if (HttpMethod.DELETE.matches(servletRequest.getMethod())) {
                        msgKey = (String)msgKey + ".delete";
                    }
                    code = "DAO.00105";
                } else {
                    msgKey = "error.dao.sqlState.class.23";
                    code = "DAO.00104";
                }
            } else {
                msg = "Data integrity violation";
                msgKey = "error.dao.dataIntegrityViolation";
                code = "DAO.00100";
            }
        }
        if (this.messageSource != null) {
            msg = this.messageSource.getMessage((String)msgKey, params, msg, locale);
        }
        return new Response(Boolean.FALSE, code, msg, null);
    }

    @ExceptionHandler(value={DataRetrievalFailureException.class})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.NOT_FOUND)
    public Response<?> handleDataRetrievalFailureException(DataRetrievalFailureException e, WebRequest request, Locale locale) {
        log.debug("DataRetrievalFailureException in request {}, user [{}]", new Object[]{WebServiceControllerSupport.requestDescription(request), WebServiceControllerSupport.userPrincipalName(request), e});
        String msg = "Key not found";
        String msgKey = "error.dao.keyNotFound";
        String code = "DAO.00102";
        if (this.messageSource != null) {
            msg = this.messageSource.getMessage(msgKey, new Object[]{e.getMostSpecificCause().getMessage()}, msg, locale);
        }
        return new Response(Boolean.FALSE, code, msg, null);
    }

    @ExceptionHandler(value={InvalidDataAccessResourceUsageException.class})
    @ResponseBody
    @ResponseStatus
    public Response<?> handleInvalidDataAccessResourceUsageException(InvalidDataAccessResourceUsageException e, WebRequest request, Locale locale) {
        log.error("InvalidDataAccessResourceUsageException in request {}", (Object)WebServiceControllerSupport.requestDescription(request), (Object)e.getMostSpecificCause());
        String msg = "Internal error";
        String msgKey = "error.dao.invalidResourceUsage";
        String code = "DAO.00500";
        if (this.messageSource != null) {
            msg = this.messageSource.getMessage(msgKey, new Object[]{e.getMostSpecificCause().getMessage()}, msg, locale);
        }
        return new Response(Boolean.FALSE, code, msg, null);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.UNPROCESSABLE_ENTITY)
    public Result<Void> handleConstraintViolationException(ConstraintViolationException e, WebRequest request, Locale locale) {
        log.debug("ConstraintViolationException in request {}: {}", (Object)WebServiceControllerSupport.requestDescription(request), (Object)e.toString());
        BindingResult errors = ExceptionUtils.toBindingResult(e, this.validator);
        return ExceptionUtils.generateErrorsResult((Errors)errors, "VAL.00003", locale, this.messageSource);
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.UNPROCESSABLE_ENTITY)
    public Result<?> handleBindException(BindException e, WebRequest request, Locale locale) {
        log.debug("BindException in request {}: {}", (Object)WebServiceControllerSupport.requestDescription(request), (Object)e.toString());
        return ExceptionUtils.generateErrorsResult((Errors)e, "VAL.00004", locale, this.messageSource);
    }

    private String generateErrorsMessage(Errors e, Locale locale, MessageSource msgSrc) {
        String msg;
        String string = msg = msgSrc == null ? "Validation error" : msgSrc.getMessage("error.validation", null, "Validation error", locale);
        if (msgSrc != null && e.hasErrors()) {
            StringBuilder buf = new StringBuilder();
            for (ObjectError error : e.getAllErrors()) {
                if (buf.length() > 0) {
                    buf.append(" ");
                }
                buf.append(msgSrc.getMessage((MessageSourceResolvable)error, locale));
            }
            msg = buf.toString();
        }
        return msg;
    }

    @ExceptionHandler(value={InvalidPropertyException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.UNPROCESSABLE_ENTITY)
    public Result<?> handleInvalidPropertyException(InvalidPropertyException e, WebRequest request, Locale locale) {
        log.info("InvalidPropertyException in request {}: {}", (Object)WebServiceControllerSupport.requestDescription(request), (Object)e.toString());
        return Result.error((String)"VAL.00005", (String)this.messageSource.getMessage("error.invalidProperty", new Object[]{e.getMessage()}, "Invalid request syntax", locale), (Result.ErrorDetail[])new Result.ErrorDetail[0]);
    }

    @ExceptionHandler(value={ValidationException.class})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.UNPROCESSABLE_ENTITY)
    public Response<?> handleValidationException(ValidationException e, WebRequest request, Locale locale) {
        log.debug("ValidationException in request {}: {}", (Object)WebServiceControllerSupport.requestDescription(request), (Object)e.toString());
        String msg = this.generateErrorsMessage(e.getErrors(), locale, e.getMessageSource() != null ? e.getMessageSource() : this.messageSource);
        return new Response(Boolean.FALSE, null, msg, null);
    }

    @ExceptionHandler(value={MultipartException.class})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.UNPROCESSABLE_ENTITY)
    public Response<?> handleMultipartException(MultipartException e, WebRequest request) {
        log.info("MultipartException in request {}; user [{}]: {}", new Object[]{WebServiceControllerSupport.requestDescription(request), WebServiceControllerSupport.userPrincipalName(request), e.toString()});
        StringBuilder buf = new StringBuilder();
        buf.append("Error parsing multipart HTTP request");
        String msg = e.getMostSpecificCause().getMessage();
        if (msg != null && !msg.isEmpty()) {
            buf.append(": ").append(msg);
        }
        return new Response(Boolean.FALSE, "422", buf.toString(), null);
    }

    @ModelAttribute
    public void addVaryResponseHeader(HttpServletResponse response) {
        Collection vary = response.getHeaders("Vary");
        if (vary == null || !vary.contains("Accept")) {
            response.addHeader("Vary", "Accept");
        }
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    @Autowired
    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

