/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.web.support;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.solarnetwork.util.ObjectUtils;

public class UrlEncodingOnAccessMap<K>
implements Map<K, String> {
    private final Map<K, String> delegate;

    public UrlEncodingOnAccessMap(Map<K, String> delegate) {
        this.delegate = (Map)ObjectUtils.requireNonNullArgument(delegate, (String)"delegate");
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public String get(Object key) {
        String val = this.delegate.get(key);
        if (val != null) {
            return URLEncoder.encode(val.toString(), StandardCharsets.UTF_8).replace("+", "%20");
        }
        return null;
    }

    @Override
    public String put(K key, String value) {
        return this.delegate.put(key, value);
    }

    @Override
    public String remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends String> m) {
        this.delegate.putAll(m);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<String> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<K, String>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }
}

