/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.web.support;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipException;
import javax.cache.Cache;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableCacheEntryListenerConfiguration;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import net.solarnetwork.central.support.CacheUtils;
import net.solarnetwork.central.web.support.CachedContent;
import net.solarnetwork.central.web.support.ContentCacheStats;
import net.solarnetwork.central.web.support.ContentCachingService;
import net.solarnetwork.central.web.support.SimpleCachedContent;
import net.solarnetwork.service.PingTest;
import net.solarnetwork.service.PingTestResult;
import net.solarnetwork.util.ObjectUtils;
import net.solarnetwork.util.StatTracker;
import net.solarnetwork.web.jakarta.security.AuthenticationScheme;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class JCacheContentCachingService
implements ContentCachingService,
PingTest,
CacheEntryCreatedListener<String, CachedContent>,
CacheEntryExpiredListener<String, CachedContent>,
CacheEntryUpdatedListener<String, CachedContent>,
CacheEntryRemovedListener<String, CachedContent>,
CacheUtils.CacheEvictionListener<String, CachedContent> {
    public static final int DEFAULT_STAT_LOG_ACCESS_COUNT = 500;
    private static final Pattern SNWS_V1_KEY_PATTERN = Pattern.compile("^" + AuthenticationScheme.V1.getSchemeName() + "\\s+([^:]+):");
    private static final Pattern SNWS_V2_KEY_PATTERN = Pattern.compile("Credential=([^,]+)(?:,|$)");
    private static final Logger log = LoggerFactory.getLogger(JCacheContentCachingService.class);
    private final Cache<String, CachedContent> cache;
    private final StatTracker stats;
    private final String pingTestId;
    private Set<MediaType> compressibleMediaTypes = new HashSet<MediaType>(MediaType.parseMediaTypes((String)"text/*, application/cbor, application/json, application/xml"));
    private int compressMinimumLength = 2048;
    private static final MediaType CSV_MEDIA_TYPE = MediaType.parseMediaType((String)"text/csv");
    private static final byte[] CSV_MEDIA_TYPE_COMPONENT = "+csv".getBytes();
    private static final byte[] JSON_MEDIA_TYPE_COMPONENT = "+json".getBytes();
    private static final byte[] XML_MEDIA_TYPE_COMPONENT = "+xml".getBytes();

    public JCacheContentCachingService(Cache<String, CachedContent> cache) {
        this.cache = (Cache)ObjectUtils.requireNonNullArgument(cache, (String)"cache");
        this.stats = new StatTracker("ContentCache", cache.getName(), LoggerFactory.getLogger(JCacheContentCachingService.class), 500);
        this.pingTestId = String.format("%s-%s", JCacheContentCachingService.class.getName(), cache.getName());
        MutableCacheEntryListenerConfiguration listenerConfiguration = new MutableCacheEntryListenerConfiguration((Factory)new FactoryBuilder.SingletonFactory((Object)this), null, true, false);
        cache.registerCacheEntryListener((CacheEntryListenerConfiguration)listenerConfiguration);
        CacheUtils.registerCacheEvictionListener(cache, this);
    }

    public String getPingTestId() {
        return this.pingTestId;
    }

    public String getPingTestName() {
        return "Content Cache";
    }

    public long getPingTestMaximumExecutionMilliseconds() {
        return 500L;
    }

    public PingTest.Result performPingTest() throws Exception {
        NavigableMap statMap = this.stats.allCounts();
        Long hits = (Long)statMap.get(ContentCacheStats.Hit.name());
        Long misses = (Long)statMap.get(ContentCacheStats.Miss.name());
        long total = (hits != null ? hits : 0L) + (misses != null ? misses : 0L);
        double hitRate = hits == null || hits < 1L ? 0.0 : (double)hits.longValue() / (double)total;
        statMap.put("HitRate", (long)(hitRate * 100.0));
        return new PingTestResult(true, "Cache active.", (Map)statMap);
    }

    private void handleCacheEntryEvent(Iterable<CacheEntryEvent<? extends String, ? extends CachedContent>> events) {
        for (CacheEntryEvent<? extends String, ? extends CachedContent> event : events) {
            CachedContent curr;
            CachedContent old = (CachedContent)event.getOldValue();
            if (old != null) {
                this.stats.add((Enum)ContentCacheStats.EntryCount, -1L);
                this.stats.add((Enum)ContentCacheStats.ByteSize, (long)(-old.getContentLength()), true);
            }
            if ((curr = (CachedContent)event.getValue()) == null || curr == old) continue;
            this.stats.increment((Enum)ContentCacheStats.EntryCount);
            this.stats.add((Enum)ContentCacheStats.ByteSize, (long)curr.getContentLength(), true);
        }
    }

    public void onExpired(Iterable<CacheEntryEvent<? extends String, ? extends CachedContent>> events) throws CacheEntryListenerException {
        this.handleCacheEntryEvent(events);
    }

    public void onCreated(Iterable<CacheEntryEvent<? extends String, ? extends CachedContent>> events) throws CacheEntryListenerException {
        this.handleCacheEntryEvent(events);
    }

    public void onUpdated(Iterable<CacheEntryEvent<? extends String, ? extends CachedContent>> events) throws CacheEntryListenerException {
        this.handleCacheEntryEvent(events);
    }

    public void onRemoved(Iterable<CacheEntryEvent<? extends String, ? extends CachedContent>> events) throws CacheEntryListenerException {
        this.handleCacheEntryEvent(events);
    }

    @Override
    public void onCacheEviction(String key, CachedContent value) {
        this.stats.add((Enum)ContentCacheStats.EntryCount, -1L);
        if (value != null) {
            this.stats.add((Enum)ContentCacheStats.ByteSize, (long)(-value.getContentLength()), true);
        }
    }

    private void addAuthorization(HttpServletRequest request, MessageDigest digest) {
        AuthenticationScheme scheme = null;
        String header = request.getHeader("Authorization");
        if (header != null) {
            for (AuthenticationScheme aScheme : AuthenticationScheme.values()) {
                if (!header.startsWith(aScheme.getSchemeName())) continue;
                scheme = aScheme;
                break;
            }
        }
        Matcher m = null;
        if (scheme != null) {
            switch (scheme) {
                case V1: {
                    m = SNWS_V1_KEY_PATTERN.matcher(header);
                    break;
                }
                case V2: {
                    m = SNWS_V2_KEY_PATTERN.matcher(header);
                }
            }
        }
        if (m != null && m.find()) {
            digest.update(m.group(1).getBytes());
            digest.update((byte)64);
        }
    }

    private void addNormalizedQueryParameters(HttpServletRequest request, MessageDigest digest) {
        Set paramKeys = request.getParameterMap().keySet();
        if (paramKeys.size() < 1) {
            return;
        }
        Object[] keys = paramKeys.toArray(new String[paramKeys.size()]);
        Arrays.sort(keys);
        boolean first = true;
        for (Object key : keys) {
            String[] vals = request.getParameterValues((String)key);
            if (vals == null) continue;
            for (String val : vals) {
                if (first) {
                    digest.update((byte)63);
                    first = false;
                } else {
                    digest.update((byte)38);
                }
                digest.update(((String)key).getBytes());
                digest.update((byte)61);
                digest.update(val.getBytes());
            }
        }
    }

    public List<MediaType> getAccept(HttpServletRequest request) {
        Enumeration acceptHeader = request.getHeaders("Accept");
        StringBuilder buf = new StringBuilder();
        while (acceptHeader.hasMoreElements()) {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append((String)acceptHeader.nextElement());
        }
        String value = buf.toString();
        return value != null && value.length() > 0 ? MediaType.parseMediaTypes((String)value) : Collections.emptyList();
    }

    private void addNormalizedAccept(HttpServletRequest request, MessageDigest digest) {
        List<MediaType> types = this.getAccept(request);
        if (types == null || types.isEmpty()) {
            return;
        }
        for (MediaType type : types) {
            if (type.isWildcardType()) continue;
            if (MediaType.APPLICATION_JSON.isCompatibleWith(type)) {
                digest.update(JSON_MEDIA_TYPE_COMPONENT);
                return;
            }
            if (CSV_MEDIA_TYPE.isCompatibleWith(type)) {
                digest.update(CSV_MEDIA_TYPE_COMPONENT);
                return;
            }
            if (MediaType.APPLICATION_XML.isCompatibleWith(type) || MediaType.TEXT_XML.isCompatibleWith(type)) {
                digest.update(XML_MEDIA_TYPE_COMPONENT);
                return;
            }
            if (type.getType() == null || type.getSubtype() == null) continue;
            digest.update((byte)43);
            digest.update(type.getType().getBytes());
            digest.update((byte)47);
            digest.update(type.getSubtype().getBytes());
        }
    }

    @Override
    public String keyForRequest(HttpServletRequest request) {
        MessageDigest digest = DigestUtils.getMd5Digest();
        this.addAuthorization(request, digest);
        digest.update(request.getMethod().getBytes());
        digest.update(request.getRequestURI().getBytes());
        this.addNormalizedQueryParameters(request, digest);
        this.addNormalizedAccept(request, digest);
        return Hex.encodeHexString((byte[])digest.digest());
    }

    @Override
    public CachedContent sendCachedResponse(String key, HttpServletRequest request, HttpServletResponse response) throws IOException {
        CachedContent content = (CachedContent)this.cache.get((Object)key);
        if (content == null) {
            this.stats.increment((Enum)ContentCacheStats.Miss);
            return null;
        }
        this.stats.increment((Enum)ContentCacheStats.Hit);
        response.setStatus(200);
        MultiValueMap<String, String> headers = content.getHeaders();
        if (headers != null) {
            for (Map.Entry me : headers.entrySet()) {
                for (String value : (List)me.getValue()) {
                    response.addHeader((String)me.getKey(), value);
                }
            }
        }
        response.setHeader("X-SN-Content-Cache", "HIT");
        InputStream in = content.getContent();
        if (in != null) {
            String contentEncoding = content.getContentEncoding();
            String accept = request.getHeader("Accept-Encoding");
            if (accept != null && accept.contains(ContentCachingService.CompressionType.GZIP.getContentEncoding()) && ContentCachingService.CompressionType.GZIP.getContentEncoding().equals(contentEncoding)) {
                response.setHeader("Content-Encoding", contentEncoding);
                response.setContentLength(content.getContentLength());
                String vary = response.getHeader("Vary");
                if (vary == null) {
                    response.setHeader("Vary", "Accept-Encoding");
                } else {
                    Collection varies = response.getHeaders("Vary");
                    boolean addVary = true;
                    for (String v : varies) {
                        if (!"*".equals(v) && !"Accept-Encoding".equals(v)) continue;
                        addVary = false;
                        break;
                    }
                    if (addVary) {
                        response.addHeader("Vary", "Accept-Encoding");
                    }
                }
                FileCopyUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
            } else if (ContentCachingService.CompressionType.GZIP.getContentEncoding().equals(contentEncoding)) {
                try {
                    FileCopyUtils.copy((InputStream)new GZIPInputStream(in), (OutputStream)response.getOutputStream());
                }
                catch (ZipException e) {
                    String base64Content = "";
                    try {
                        ByteArrayOutputStream byos = new ByteArrayOutputStream(content.getContentLength());
                        FileCopyUtils.copy((InputStream)content.getContent(), (OutputStream)byos);
                        base64Content = Base64.getEncoder().encodeToString(byos.toByteArray());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    log.error("Cached content {} for [{}] marked as gzip but not valid ({}). Content size: {}; headers: {}; metadata: {}; content Base64: {}\n", new Object[]{key, request.getRequestURI(), e.getMessage(), content.getContentLength(), content.getHeaders(), content.getMetadata(), base64Content});
                    response.setContentLength(content.getContentLength());
                    FileCopyUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
                }
            } else {
                response.setContentLength(content.getContentLength());
                FileCopyUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
            }
        }
        return content;
    }

    @Override
    public void cacheResponse(String key, HttpServletRequest request, int statusCode, HttpHeaders headers, InputStream content, ContentCachingService.CompressionType compressionType) throws IOException {
        byte[] data = FileCopyUtils.copyToByteArray((InputStream)content);
        String contentEncoding = headers.getFirst("Content-Encoding");
        if (compressionType != null) {
            contentEncoding = compressionType.getContentEncoding();
        } else {
            MediaType type = headers.getContentType();
            if (type != null && data.length >= this.compressMinimumLength) {
                for (MediaType t : this.compressibleMediaTypes) {
                    if (!t.includes(type)) continue;
                    try (ByteArrayOutputStream byos = new ByteArrayOutputStream();
                         GZIPOutputStream out = new GZIPOutputStream(byos);){
                        FileCopyUtils.copy((byte[])data, (OutputStream)out);
                        data = byos.toByteArray();
                        contentEncoding = ContentCachingService.CompressionType.GZIP.getContentEncoding();
                        break;
                    }
                }
            }
        }
        Map<String, ?> metadata = this.getCacheContentMetadata(key, request, statusCode, headers);
        this.cache.put((Object)key, (Object)new SimpleCachedContent((MultiValueMap<String, String>)new LinkedMultiValueMap((Map)headers), data, contentEncoding, metadata));
        this.stats.increment((Enum)ContentCacheStats.Stored);
    }

    protected Map<String, ?> getCacheContentMetadata(String key, HttpServletRequest request, int statusCode, HttpHeaders headers) {
        return null;
    }

    public void setCompressibleMediaTypes(Set<MediaType> compressibleMediaTypes) {
        this.compressibleMediaTypes = (Set)ObjectUtils.requireNonNullArgument(compressibleMediaTypes, (String)"compressibleMediaTypes");
    }

    public void setCompressMinimumLength(int compressMinimumLength) {
        this.compressMinimumLength = compressMinimumLength;
    }

    public void setStatLogAccessCount(int statLogAccessCount) {
        this.stats.setLogFrequency(statLogAccessCount);
    }
}

