/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.web.support;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPOutputStream;
import org.springframework.http.HttpHeaders;
import org.springframework.util.FastByteArrayOutputStream;

public class ContentCachingResponseWrapper
extends HttpServletResponseWrapper {
    private final FastByteArrayOutputStream content = new FastByteArrayOutputStream(1024);
    private final OutputStream cacheStream;
    private final HttpHeaders headers;
    private ServletOutputStream outputStream;
    private PrintWriter outputWriter;
    private boolean cacheStreamFinished;

    public ContentCachingResponseWrapper(HttpServletResponse response, boolean gzip) throws IOException {
        super(response);
        this.cacheStream = gzip ? new GZIPOutputStream((OutputStream)this.content) : this.content;
        this.headers = new HttpHeaders();
    }

    public void setHeader(String name, String value) {
        this.headers.set(name, value);
        super.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this.headers.add(name, value);
        super.addHeader(name, value);
    }

    public void sendError(int sc) throws IOException {
        try {
            super.sendError(sc);
        }
        catch (IllegalStateException ex) {
            super.setStatus(sc);
        }
    }

    public void sendError(int sc, String msg) throws IOException {
        try {
            super.sendError(sc, msg);
        }
        catch (IllegalStateException ex) {
            super.setStatus(sc);
        }
    }

    public void sendRedirect(String location) throws IOException {
        throw new UnsupportedOperationException();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new ResponseServletOutputStream(this.getResponse().getOutputStream());
        }
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.outputWriter == null) {
            String characterEncoding = this.getCharacterEncoding();
            this.outputWriter = new ResponsePrintWriter(this, characterEncoding != null ? characterEncoding : "ISO-8859-1", this.getOutputStream());
        }
        return this.outputWriter;
    }

    public void setBufferSize(int size) {
        if (size > this.content.size()) {
            this.content.resize(size);
        }
    }

    public void resetBuffer() {
        this.content.reset();
    }

    public void reset() {
        super.reset();
        this.content.reset();
    }

    private void finishContentStream() throws IOException {
        if (!this.cacheStreamFinished && this.cacheStream != this.content) {
            this.cacheStream.flush();
            this.cacheStream.close();
            this.cacheStreamFinished = true;
        }
    }

    public byte[] getContentAsByteArray() throws IOException {
        this.finishContentStream();
        return this.content.toByteArray();
    }

    public InputStream getContentInputStream() throws IOException {
        this.finishContentStream();
        return this.content.getInputStream();
    }

    public int getContentSize() throws IOException {
        this.cacheStream.flush();
        return this.content.size();
    }

    public boolean isContentGzip() {
        return this.cacheStream instanceof GZIPOutputStream;
    }

    public HttpHeaders getHttpHeaders() {
        return this.headers;
    }

    private class ResponseServletOutputStream
    extends ServletOutputStream {
        private final ServletOutputStream os;

        public ResponseServletOutputStream(ServletOutputStream os) {
            this.os = os;
        }

        public void write(int b) throws IOException {
            ContentCachingResponseWrapper.this.cacheStream.write(b);
            this.os.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            ContentCachingResponseWrapper.this.cacheStream.write(b, off, len);
            this.os.write(b, off, len);
        }

        public boolean isReady() {
            return this.os.isReady();
        }

        public void setWriteListener(WriteListener writeListener) {
            this.os.setWriteListener(writeListener);
        }

        public void flush() throws IOException {
            ContentCachingResponseWrapper.this.cacheStream.flush();
            super.flush();
        }

        public void close() throws IOException {
            ContentCachingResponseWrapper.this.finishContentStream();
            super.close();
        }
    }

    private class ResponsePrintWriter
    extends PrintWriter {
        public ResponsePrintWriter(ContentCachingResponseWrapper contentCachingResponseWrapper, String characterEncoding, ServletOutputStream os) throws UnsupportedEncodingException {
            super(new OutputStreamWriter((OutputStream)os, characterEncoding));
        }

        @Override
        public void write(char[] buf, int off, int len) {
            super.write(buf, off, len);
            super.flush();
        }

        @Override
        public void write(String s, int off, int len) {
            super.write(s, off, len);
            super.flush();
        }

        @Override
        public void write(int c) {
            super.write(c);
            super.flush();
        }
    }
}

