/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.web.support;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.solarnetwork.central.web.support.ContentCachingResponseWrapper;
import net.solarnetwork.central.web.support.ContentCachingService;
import net.solarnetwork.service.PingTest;
import net.solarnetwork.service.PingTestResult;
import net.solarnetwork.util.ObjectUtils;
import net.solarnetwork.util.StatTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;

public class ContentCachingFilter
implements Filter,
PingTest {
    public static final int DEFAULT_STAT_LOG_ACCESS_COUNT = 500;
    private static final long EPOCH = 1514764800000L;
    private final AtomicLong requestCounter = new AtomicLong(System.currentTimeMillis() - 1514764800L);
    private final ContentCachingService contentCachingService;
    private final BlockingQueue<LockAndCount> lockPool;
    private final ConcurrentMap<String, LockAndCount> requestLocks;
    private final StatTracker stats;
    private final int lockPoolCapacity;
    private final LongAccumulator lockPoolMinize;
    private Set<String> methodsToCache = Collections.singleton("GET");
    private long requestLockTimeout = TimeUnit.SECONDS.toMillis(240L);
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public static BlockingQueue<LockAndCount> lockPoolWithCapacity(int lockPoolCapacity) {
        ArrayList<LockAndCount> locks = new ArrayList<LockAndCount>(lockPoolCapacity);
        for (int i = 0; i < lockPoolCapacity; ++i) {
            locks.add(new LockAndCount(i, new ReentrantLock()));
        }
        return new ArrayBlockingQueue<LockAndCount>(lockPoolCapacity, false, locks);
    }

    public ContentCachingFilter(ContentCachingService contentCachingService, int lockPoolCapacity) {
        this(contentCachingService, ContentCachingFilter.lockPoolWithCapacity(lockPoolCapacity), new ConcurrentHashMap<String, LockAndCount>(128));
    }

    public ContentCachingFilter(ContentCachingService contentCachingService, BlockingQueue<LockAndCount> lockPool, ConcurrentMap<String, LockAndCount> requestLocks) {
        this.contentCachingService = (ContentCachingService)ObjectUtils.requireNonNullArgument((Object)contentCachingService, (String)"contentCachingService");
        this.lockPool = (BlockingQueue)ObjectUtils.requireNonNullArgument(lockPool, (String)"lockPool");
        this.requestLocks = (ConcurrentMap)ObjectUtils.requireNonNullArgument(requestLocks, (String)"requestLocks");
        if (lockPool.isEmpty()) {
            throw new IllegalArgumentException("The lock pool must not be empty.");
        }
        this.stats = new StatTracker("ContentCacheFilter", null, this.log, 500);
        this.lockPoolCapacity = lockPool.size();
        this.lockPoolMinize = new LongAccumulator(Math::min, Long.MAX_VALUE);
        this.lockPoolMinize.accumulate(this.lockPoolCapacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            this.log.debug("Not HTTP request; caching disabled");
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest origRequest = (HttpServletRequest)request;
        String requestUri = origRequest.getRequestURI();
        Long requestId = this.requestCounter.incrementAndGet();
        HttpServletResponse origResponse = (HttpServletResponse)response;
        String method = origRequest.getMethod().toUpperCase();
        if (!this.methodsToCache.contains(method)) {
            this.log.debug("{} [{}] HTTP method {} not supported; caching disabled", new Object[]{requestId, requestUri, method});
            chain.doFilter(request, response);
            return;
        }
        this.stats.increment((Enum)ContentCachingFilterStats.RequestsFiltered);
        String key = this.contentCachingService.keyForRequest(origRequest);
        if (key == null) {
            this.log.debug("[{}] HTTP request not cachable", (Object)requestUri);
            chain.doFilter(request, response);
            return;
        }
        LockAndCount lock = this.requestLocks.computeIfAbsent(key, k -> {
            try {
                LockAndCount l = this.lockPool.poll(this.requestLockTimeout, TimeUnit.MILLISECONDS);
                if (l == null) {
                    this.stats.increment((Enum)ContentCachingFilterStats.LockPoolBorrowFailures);
                } else {
                    this.stats.increment((Enum)ContentCachingFilterStats.LockPoolBorrows, true);
                    this.lockPoolMinize.accumulate(this.lockPool.size());
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("{} [{}] Borrowed lock {} from pool", new Object[]{requestId, requestUri, l.getId()});
                    }
                }
                return l;
            }
            catch (InterruptedException e) {
                return null;
            }
        });
        if (lock == null) {
            origResponse.sendError(HttpStatus.TOO_MANY_REQUESTS.value(), "Timeout waiting for cache lock");
            return;
        }
        this.log.trace("{} [{}] Using lock {} for key {}", new Object[]{requestId, requestUri, lock.getId(), key});
        lock.incrementCount();
        try {
            if (!lock.tryLock(this.requestLockTimeout, TimeUnit.MILLISECONDS)) {
                origResponse.sendError(HttpStatus.TOO_MANY_REQUESTS.value(), "Timeout acquiring cache lock");
                this.stats.increment((Enum)ContentCachingFilterStats.RequestLockFailures);
                this.returnLock(key, lock, requestId, requestUri);
                return;
            }
        }
        catch (InterruptedException e) {
            origResponse.sendError(HttpStatus.TOO_MANY_REQUESTS.value(), "Interrupted acquiring cache lock");
            this.stats.increment((Enum)ContentCachingFilterStats.RequestLockFailures);
            this.returnLock(key, lock, requestId, requestUri);
            return;
        }
        try {
            if (this.contentCachingService.sendCachedResponse(key, origRequest, origResponse) != null) {
                this.log.debug("{} [{}] Sent cached response", (Object)requestId, (Object)requestUri);
                return;
            }
            origResponse.setHeader("X-SN-Content-Cache", "MISS");
            ContentCachingResponseWrapper wrappedResponse = new ContentCachingResponseWrapper(origResponse, true);
            this.log.debug("{} [{}] Cache miss, passing on for processing", (Object)requestId, (Object)requestUri);
            chain.doFilter((ServletRequest)origRequest, (ServletResponse)wrappedResponse);
            HttpStatus status = HttpStatus.valueOf((int)origResponse.getStatus());
            if (status.is2xxSuccessful()) {
                this.log.debug("{} [{}] Caching response", (Object)requestId, (Object)requestUri);
                HttpHeaders headers = wrappedResponse.getHttpHeaders();
                if (origResponse.getContentType() != null) {
                    headers.setContentType(MediaType.parseMediaType((String)origResponse.getContentType()));
                }
                this.contentCachingService.cacheResponse(key, origRequest, wrappedResponse.getStatus(), headers, wrappedResponse.getContentInputStream(), ContentCachingService.CompressionType.GZIP);
            }
            if (this.log.isDebugEnabled()) {
                if (status.is2xxSuccessful()) {
                    this.log.debug("{} [{}] Response cached and sent", (Object)requestId, (Object)requestUri);
                } else {
                    this.log.debug("{} [{}] Response sent without caching", (Object)requestId, (Object)requestUri);
                }
            }
        }
        finally {
            lock.unlock();
            this.returnLock(key, lock, requestId, requestUri);
        }
    }

    private void returnLock(String key, LockAndCount lock, Long requestId, String requestUri) {
        int count = lock.decrementCount();
        if (count < 1 && this.requestLocks.remove(key, lock)) {
            this.log.trace("{} [{}] Removed lock for key {}", new Object[]{requestId, requestUri, key});
            this.returnLockToPool(lock, requestId, requestUri);
        }
    }

    private void returnLockToPool(LockAndCount lock, Long requestId, String requestUri) {
        if (this.lockPool.offer(lock)) {
            this.stats.increment((Enum)ContentCachingFilterStats.LockPoolReturns, true);
            this.log.trace("{} [{}] Lock {} returned to pool", new Object[]{requestId, requestUri, lock.getId()});
        }
    }

    public String getPingTestId() {
        return "net.solarnetwork.central.web.support.ContentCachingFilter";
    }

    public String getPingTestName() {
        return "Content Caching Filter";
    }

    public long getPingTestMaximumExecutionMilliseconds() {
        return 1000L;
    }

    public PingTest.Result performPingTest() throws Exception {
        LinkedHashMap<String, Number> statMap = new LinkedHashMap<String, Number>(ContentCachingFilterStats.values().length + 3);
        statMap.putAll(this.stats.allCounts());
        long activeRequests = this.requestLocks.values().stream().mapToLong(LockAndCount::count).sum();
        statMap.put("LockPoolCapacity", this.lockPoolCapacity);
        statMap.put("LockPoolAvailable", this.lockPool.size());
        statMap.put("LockPoolWatermark", this.lockPoolMinize.get());
        statMap.put("ActiveRequests", activeRequests);
        return new PingTestResult(true, null, statMap);
    }

    public void setMethodsToCache(Set<String> methodsToCache) {
        this.methodsToCache = methodsToCache;
    }

    public void setRequestLockTimeout(long requestLockTimeout) {
        this.requestLockTimeout = requestLockTimeout;
    }

    public void setStatLogAccessCount(int statLogAccessCount) {
        this.stats.setLogFrequency(statLogAccessCount);
    }

    public static class LockAndCount
    implements Lock {
        private final int id;
        private final AtomicInteger count;
        private final ReentrantLock lock;

        private LockAndCount(int id, ReentrantLock lock) {
            this.id = id;
            this.lock = lock;
            this.count = new AtomicInteger(0);
        }

        public int getId() {
            return this.id;
        }

        public int count() {
            return this.count.get();
        }

        private int incrementCount() {
            return this.count.incrementAndGet();
        }

        private int decrementCount() {
            return this.count.decrementAndGet();
        }

        public boolean isLocked() {
            return this.lock.isLocked();
        }

        @Override
        public void lock() {
            this.lock.lock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.lock.lockInterruptibly();
        }

        @Override
        public boolean tryLock() {
            return this.lock.tryLock();
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return this.lock.tryLock(time, unit);
        }

        @Override
        public void unlock() {
            this.lock.unlock();
        }

        @Override
        public Condition newCondition() {
            return this.lock.newCondition();
        }
    }

    public static enum ContentCachingFilterStats {
        RequestsFiltered,
        LockPoolBorrows,
        LockPoolReturns,
        LockPoolBorrowFailures,
        RequestLockFailures;

    }
}

