/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.solarnetwork.central.support.AbstractFilteredResultsProcessor;
import net.solarnetwork.central.support.CsvFilteredResultsProcessor;
import net.solarnetwork.central.support.FilteredResultsProcessor;
import net.solarnetwork.central.support.ObjectMapperFilteredResultsProcessor;
import net.solarnetwork.central.support.OutputSerializationSupportContext;
import org.slf4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.TransientDataAccessException;
import org.springframework.http.MediaType;
import org.springframework.util.MimeType;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public final class WebUtils {
    public static final String TEXT_CSV_MEDIA_TYPE_VALUE = "text/csv";
    public static final MediaType TEXT_CSV_MEDIA_TYPE = MediaType.parseMediaType((String)"text/csv");
    public static final String TEXT_CSV_UTF8_MEDIA_TYPE_VALUE = "text/csv; charset=UTF-8";
    public static final MediaType TEXT_CSV_UTF8_MEDIA_TYPE = MediaType.parseMediaType((String)"text/csv; charset=UTF-8");
    public static final String XLSX_MEDIA_TYPE_VALUE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    public static final MediaType XLSX_MEDIA_TYPE = MediaType.parseMediaType((String)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");

    private WebUtils() {
    }

    public static UriComponents withoutHost(UriComponentsBuilder builder, Object ... uriVariableValues) {
        return builder.scheme(null).host(null).port(null).buildAndExpand(uriVariableValues);
    }

    public static UriComponents withoutHost(UriComponentsBuilder builder, Map<String, ?> uriVariables) {
        return builder.scheme(null).host(null).port(null).buildAndExpand(uriVariables);
    }

    public static URI uriWithoutHost(UriComponentsBuilder builder, Object ... uriVariableValues) {
        return WebUtils.withoutHost(builder, uriVariableValues).toUri();
    }

    public static URI uriWithoutHost(UriComponentsBuilder builder, Map<String, ?> uriVariables) {
        return WebUtils.withoutHost(builder, uriVariables).toUri();
    }

    public static <T> FilteredResultsProcessor<T> filteredResultsProcessorForType(List<MediaType> acceptTypes, HttpServletResponse response, OutputSerializationSupportContext<T> context) throws IOException {
        AbstractFilteredResultsProcessor processor = null;
        Iterator<MediaType> iterator = acceptTypes.iterator();
        if (iterator.hasNext()) {
            MediaType acceptType = iterator.next();
            if (MediaType.APPLICATION_CBOR.isCompatibleWith(acceptType)) {
                processor = new ObjectMapperFilteredResultsProcessor<T>(context.cborObjectMapper().createGenerator((OutputStream)response.getOutputStream()), context.cborObjectMapper().getSerializerProvider(), MimeType.valueOf((String)"application/cbor"), context.jsonSerializer());
            } else if (MediaType.APPLICATION_JSON.isCompatibleWith(acceptType)) {
                processor = new ObjectMapperFilteredResultsProcessor<T>(context.jsonObjectMapper().createGenerator((OutputStream)response.getOutputStream()), context.jsonObjectMapper().getSerializerProvider(), MimeType.valueOf((String)"application/json"), context.jsonSerializer());
            } else if (TEXT_CSV_MEDIA_TYPE.isCompatibleWith(acceptType)) {
                Charset cs = acceptType.getCharset();
                if (cs == null) {
                    cs = StandardCharsets.UTF_8;
                }
                processor = new CsvFilteredResultsProcessor(new OutputStreamWriter((OutputStream)response.getOutputStream(), cs), (MimeType)TEXT_CSV_MEDIA_TYPE, true, context.registrar());
            } else {
                throw new IllegalArgumentException(String.format("The [%s] media type is not supported.", acceptType));
            }
        }
        response.setContentType(processor.getMimeType().toString());
        return processor;
    }

    public static String requestUriWithQueryParameters(HttpServletRequest request) {
        String url = request.getRequestURI();
        String q = request.getQueryString();
        if (q != null) {
            return url + "?" + q;
        }
        return url;
    }

    public static void handleTransientDataAccessExceptionRetry(HttpServletRequest req, DataAccessException e, int retries, long retryDelay, Logger log) {
        if (retries > 0) {
            log.warn("Transient {} exception in request {}, will retry up to {} more times after a delay of {}ms: {}", new Object[]{((Object)((Object)e)).getClass().getSimpleName(), WebUtils.requestUriWithQueryParameters(req), retries, retryDelay, e.toString()});
            if (retryDelay > 0L) {
                try {
                    Thread.sleep(retryDelay);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            throw e;
        }
    }

    public static <T> T doWithTransientDataAccessExceptionRetry(Supplier<T> action, HttpServletRequest req, int tries, long retryDelay, Logger log) {
        while (true) {
            try {
                return action.get();
            }
            catch (DataAccessResourceFailureException | TransientDataAccessException e) {
                WebUtils.handleTransientDataAccessExceptionRetry(req, (DataAccessException)e, --tries, retryDelay, log);
                continue;
            }
            break;
        }
    }
}

