/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.web;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.solarnetwork.service.PingTest;
import net.solarnetwork.service.PingTestResult;
import net.solarnetwork.service.PingTestResultDisplay;
import net.solarnetwork.web.jakarta.domain.Response;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

public class PingController {
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool((ThreadFactory)new CustomizableThreadFactory("Ping-"));
    private final List<PingTest> tests;

    public PingController(List<PingTest> tests) {
        this.tests = tests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private PingResults executeTests() {
        Instant now = Instant.now();
        TreeMap<String, PingTestResultDisplay> results = null;
        ArrayList<PingTest> allTests = new ArrayList<PingTest>();
        if (this.tests != null) {
            allTests.addAll(this.tests);
        }
        if (!allTests.isEmpty()) {
            results = new TreeMap<String, PingTestResultDisplay>();
            for (final PingTest t : allTests) {
                Instant start = Instant.now();
                PingTestResult pingTestResult = null;
                Future<PingTest.Result> f = null;
                try {
                    f = EXECUTOR.submit(new Callable<PingTest.Result>(){

                        @Override
                        public PingTest.Result call() throws Exception {
                            return t.performPingTest();
                        }
                    });
                    pingTestResult = f.get(t.getPingTestMaximumExecutionMilliseconds(), TimeUnit.MILLISECONDS);
                    results.put(t.getPingTestId(), new PingTestResultDisplay(t, (PingTest.Result)pingTestResult, start));
                }
                catch (TimeoutException e) {
                    if (f != null) {
                        f.cancel(true);
                    }
                    pingTestResult = new PingTestResult(false, "Timeout: no result provided within " + t.getPingTestMaximumExecutionMilliseconds() + "ms");
                    results.put(t.getPingTestId(), new PingTestResultDisplay(t, (PingTest.Result)pingTestResult, start));
                }
                catch (Throwable e2) {
                    Throwable root = e2;
                    while (root.getCause() != null) {
                        root = root.getCause();
                    }
                    pingTestResult = new PingTestResult(false, "Exception: " + root.toString());
                    results.put(t.getPingTestId(), new PingTestResultDisplay(t, (PingTest.Result)pingTestResult, start));
                    {
                        catch (Throwable throwable) {
                            results.put(t.getPingTestId(), new PingTestResultDisplay(t, pingTestResult, start));
                            throw throwable;
                        }
                    }
                }
            }
        }
        return new PingResults(now, results);
    }

    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Response<PingResults> executePingTest() {
        return Response.response((Object)this.executeTests());
    }

    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"text/html"})
    public String executePingTest(Model model) {
        PingResults results = this.executeTests();
        model.addAttribute("results", (Object)results);
        return "ping";
    }

    public List<PingTest> getTests() {
        return this.tests;
    }

    @JsonPropertyOrder(value={"allGood", "date", "results"})
    public static class PingResults {
        private final Instant date;
        private final Map<String, PingTestResultDisplay> results;
        private final boolean allGood;

        public PingResults(Instant date, Map<String, PingTestResultDisplay> results) {
            this.date = date;
            boolean allOK = true;
            if (results == null) {
                this.results = Collections.emptyMap();
                allOK = false;
            } else {
                this.results = results;
                for (PingTestResultDisplay r : results.values()) {
                    if (r.isSuccess()) continue;
                    allOK = false;
                    break;
                }
            }
            this.allGood = allOK;
        }

        public Map<String, PingTestResultDisplay> getResults() {
            return this.results;
        }

        public Instant getDate() {
            return this.date;
        }

        public boolean isAllGood() {
            return this.allGood;
        }
    }
}

