/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.web;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Locale;
import net.solarnetwork.web.jakarta.support.MessagesSource;
import net.solarnetwork.web.jakarta.support.WebUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/msg"})
public class MessageController {
    @Autowired
    private MessageSource messageSource;
    private String viewName;

    @RequestMapping(method={RequestMethod.GET}, value={"/msg.*"})
    public String getMessage(HttpServletRequest request, Model model, Locale locale, @RequestParam(value="key") String msgKey, @RequestParam(required=false, value="param") String[] params) {
        String value = this.messageSource.getMessage(msgKey, (Object[])params, locale);
        model.addAttribute("message", (Object)value);
        return WebUtils.resolveViewFromUrlExtension((HttpServletRequest)request, (String)this.getViewName());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/msgs.*"})
    public String getAllMessages(HttpServletRequest request, Model model, Locale locale) {
        if (!(this.messageSource instanceof MessagesSource)) {
            throw new RuntimeException("MessageSource does not implement MessagesSource.");
        }
        MessagesSource ms = (MessagesSource)this.messageSource;
        Enumeration enumeration = ms.getKeys(locale);
        LinkedHashMap<String, String> messages = new LinkedHashMap<String, String>();
        while (enumeration.hasMoreElements()) {
            String msgKey = (String)enumeration.nextElement();
            String val = ms.getMessage(msgKey, null, locale);
            if (val == null) continue;
            messages.put(msgKey, val);
        }
        model.addAttribute("messages", messages);
        return WebUtils.resolveViewFromUrlExtension((HttpServletRequest)request, (String)this.getViewName());
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }
}

