/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.support.xslt;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import net.solarnetwork.central.support.BasicSharedValueCache;
import net.solarnetwork.central.support.SharedValueCache;
import net.solarnetwork.service.IdentifiableConfiguration;
import net.solarnetwork.settings.support.BaseSettingsSpecifierLocalizedServiceInfoProvider;
import net.solarnetwork.util.ObjectUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.util.FileCopyUtils;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class BaseXsltService
extends BaseSettingsSpecifierLocalizedServiceInfoProvider<String>
implements EntityResolver {
    public static final String SETTING_XSLT = "xslt";
    public static final String SETTING_XSLT_CACHE_DURATION = "cache-seconds";
    public static final String XSLT_PARAM_JSON = "input-json";
    protected final TransformerFactory transformerFactory;
    protected final DocumentBuilderFactory documentBuilderFactory;
    protected final ObjectMapper objectMapper;
    protected final Duration templatesCacheTtl;
    protected final SharedValueCache<String, Templates, String> templatesCache;
    public static final Pattern DOCTYPE_PAT = Pattern.compile("<!DOCTYPE[^>]*>", 2);

    public BaseXsltService(String serviceId, DocumentBuilderFactory documentBuilderFactory, TransformerFactory transformerFactory, ObjectMapper objectMapper, Duration templatesCacheTtl) {
        this(serviceId, documentBuilderFactory, transformerFactory, objectMapper, templatesCacheTtl, new BasicSharedValueCache<String, Templates, String>());
    }

    public BaseXsltService(String serviceId, DocumentBuilderFactory documentBuilderFactory, TransformerFactory transformerFactory, ObjectMapper objectMapper, Duration templatesCacheTtl, SharedValueCache<String, Templates, String> templatesCache) {
        super((Comparable)((Object)serviceId));
        this.documentBuilderFactory = (DocumentBuilderFactory)ObjectUtils.requireNonNullArgument((Object)documentBuilderFactory, (String)"documentBuilderFactory");
        this.transformerFactory = (TransformerFactory)ObjectUtils.requireNonNullArgument((Object)transformerFactory, (String)"transformerFactory");
        this.objectMapper = (ObjectMapper)ObjectUtils.requireNonNullArgument((Object)objectMapper, (String)"objectMapper");
        this.templatesCacheTtl = templatesCacheTtl != null && templatesCache != null ? templatesCacheTtl : Duration.ZERO;
        this.templatesCache = templatesCache;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return null;
    }

    protected DocumentBuilder documentBuilder() throws ParserConfigurationException {
        DocumentBuilder db = this.documentBuilderFactory.newDocumentBuilder();
        db.setEntityResolver(this);
        return db;
    }

    protected Templates templates(String xslt, IdentifiableConfiguration config, Object cacheKey) throws IOException {
        long cacheTtlSeconds = this.templatesCacheTtlSeconds(config);
        String xsltCacheKey = null;
        String xsltSharedKey = null;
        Templates t = null;
        if (cacheTtlSeconds > 0L) {
            if (cacheKey != null) {
                xsltCacheKey = cacheKey.toString();
            } else {
                xsltSharedKey = xsltCacheKey = DigestUtils.sha256Hex((String)xslt);
            }
            t = this.templatesCache.get(xsltCacheKey);
            if (t != null) {
                return t;
            }
        }
        Function<String, Templates> provider = key -> {
            Templates templates;
            StringReader xsltInput = new StringReader(xslt);
            try {
                Document xsltDoc = this.documentBuilder().parse(new InputSource(xsltInput));
                templates = this.transformerFactory.newTemplates(new DOMSource(xsltDoc));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)xsltInput).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    this.log.debug("Error parsing XSLT source: {}", (Object)e.getMessage(), (Object)e);
                    throw new IllegalStateException("Error parsing XSLT source.", e);
                }
                catch (TransformerConfigurationException e) {
                    this.log.debug("Error creating XSLT source: {}", (Object)e.getMessage(), (Object)e);
                    throw new IllegalStateException("Error creating XSLT source.", e);
                }
            }
            ((Reader)xsltInput).close();
            return templates;
        };
        if (xsltSharedKey == null) {
            xsltSharedKey = DigestUtils.sha256Hex((String)xslt);
        }
        try {
            t = xsltCacheKey != null ? this.templatesCache.put(xsltCacheKey, xsltSharedKey, provider, cacheTtlSeconds) : provider.apply(xsltCacheKey);
        }
        catch (IllegalStateException e) {
            throw new IOException(e.getMessage(), e.getCause());
        }
        return t;
    }

    protected long templatesCacheTtlSeconds(IdentifiableConfiguration config) {
        Object val;
        Map props = config != null ? config.getServiceProperties() : null;
        Object object = val = props != null ? (Object)props.get(SETTING_XSLT_CACHE_DURATION) : null;
        if (val != null) {
            if (val instanceof Number) {
                Number n = (Number)val;
                return n.longValue();
            }
            try {
                return Long.parseLong(val.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.templatesCacheTtl.getSeconds();
    }

    protected static String inputText(Object input) throws IOException {
        String result = "";
        if (input instanceof InputStream) {
            InputStream stream = (InputStream)input;
            result = FileCopyUtils.copyToString((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
        } else if (input instanceof Reader) {
            Reader reader = (Reader)input;
            result = FileCopyUtils.copyToString((Reader)reader);
        } else if (input != null) {
            result = input.toString();
        }
        return DOCTYPE_PAT.matcher(result).replaceFirst("");
    }
}

