/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.support;

import java.text.MessageFormat;
import java.time.Instant;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.cache.Cache;
import net.solarnetwork.central.dao.VersionedMessageDao;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.context.support.AbstractMessageSource;

public class VersionedMessageDaoMessageSource
extends AbstractMessageSource {
    private final VersionedMessageDao dao;
    private final String[] bundleNames;
    private final Instant version;
    private final Cache<String, VersionedMessageDao.VersionedMessages> cache;

    public VersionedMessageDaoMessageSource(VersionedMessageDao dao, String[] bundleNames, Instant version, Cache<String, VersionedMessageDao.VersionedMessages> cache) {
        this.dao = (VersionedMessageDao)ObjectUtils.requireNonNullArgument((Object)dao, (String)"dao");
        this.bundleNames = (String[])ObjectUtils.requireNonNullArgument((Object)bundleNames, (String)"bundleNames");
        this.version = version != null ? version : Instant.now();
        this.cache = cache;
    }

    protected MessageFormat resolveCode(String code, Locale locale) {
        Properties props = this.propertiesForLocale(locale);
        if (props == null) {
            return null;
        }
        String msg = props.getProperty(code);
        if (msg == null) {
            return null;
        }
        return new MessageFormat(msg, locale);
    }

    private String cacheKey(String locale) {
        StringBuilder buf = new StringBuilder();
        for (String bundleName : this.bundleNames) {
            buf.append(bundleName).append('.');
        }
        buf.append(locale).append('.').append(this.version.toEpochMilli());
        return buf.toString();
    }

    public Properties propertiesForLocale(Locale locale) {
        Object localeCode;
        String origLocaleCode = locale.toString();
        Properties props = null;
        if (locale.getLanguage() != null && !((String)(localeCode = locale.getLanguage())).equals(origLocaleCode)) {
            props = this.getPropsForLocale((String)localeCode);
        }
        if (locale.getLanguage() != null && locale.getCountry() != null && !locale.getCountry().isEmpty() && !((String)(localeCode = locale.getLanguage() + "_" + locale.getCountry())).equals(origLocaleCode)) {
            Properties countryLangProps = this.getPropsForLocale((String)localeCode);
            if (props == null) {
                props = countryLangProps;
            } else if (countryLangProps != null) {
                props.putAll((Map<?, ?>)countryLangProps);
            }
        }
        Properties fullProps = this.getPropsForLocale(origLocaleCode);
        if (props == null) {
            props = fullProps;
        } else if (fullProps != null) {
            props.putAll((Map<?, ?>)fullProps);
        }
        return props;
    }

    private Properties getPropsForLocale(String locale) {
        VersionedMessageDao.VersionedMessages msgs = null;
        String cacheKey = null;
        if (this.cache != null) {
            cacheKey = this.cacheKey(locale);
            msgs = (VersionedMessageDao.VersionedMessages)this.cache.get((Object)cacheKey);
        }
        if (msgs == null) {
            Properties props = this.dao.findMessages(this.version, this.bundleNames, locale);
            if (props == null) {
                props = new Properties();
            }
            msgs = new VersionedMessageDao.VersionedMessages(this.version, this.bundleNames, locale, props);
            if (this.cache != null) {
                this.cache.putIfAbsent((Object)cacheKey, (Object)msgs);
            }
        }
        return msgs.getProperties().isEmpty() ? null : msgs.getProperties();
    }
}

