/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.support;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Map;
import net.solarnetwork.central.domain.UserEvent;
import net.solarnetwork.codec.JsonUtils;

public class UserEventSerializer
extends StdSerializer<UserEvent> {
    private static final long serialVersionUID = -193553636996367260L;
    public static final UserEventSerializer INSTANCE = new UserEventSerializer();

    public UserEventSerializer() {
        super(UserEvent.class);
    }

    public void serialize(UserEvent event, JsonGenerator generator, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (event == null) {
            generator.writeNull();
            return;
        }
        boolean haveMessage = event.getMessage() != null && !event.getMessage().isBlank();
        boolean haveData = event.getData() != null && !event.getData().isBlank();
        generator.writeStartObject((Object)event, 4 + (haveMessage ? 1 : 0) + (haveData ? 1 : 0));
        generator.writeNumberField("userId", event.getUserId().longValue());
        generator.writeObjectField("created", (Object)event.getCreated());
        generator.writeStringField("eventId", event.getEventId().toString());
        generator.writeFieldName("tags");
        generator.writeArray(event.getTags(), 0, event.getTags().length);
        if (haveMessage) {
            generator.writeStringField("message", event.getMessage());
        }
        if (haveData) {
            generator.writeFieldName("data");
            try {
                generator.writeRawValue(event.getData());
            }
            catch (UnsupportedOperationException e) {
                Map dataMap = JsonUtils.getStringMap((String)event.getData());
                generator.writeObject((Object)dataMap);
            }
        }
        generator.writeEndObject();
    }
}

