/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.solarnetwork.central.domain.SolarLocation;
import net.solarnetwork.central.domain.SourceLocation;
import net.solarnetwork.domain.MutableSortDescriptor;
import net.solarnetwork.domain.SerializeIgnore;
import net.solarnetwork.domain.SortDescriptor;
import org.springframework.util.StringUtils;

public class SourceLocationFilter
implements Serializable,
SourceLocation {
    private static final long serialVersionUID = 5979398734497676907L;
    private Long id;
    private String source;
    private SolarLocation location;
    private List<MutableSortDescriptor> sorts;
    private Integer offset;
    private Integer max;

    public SourceLocationFilter() {
        this(null, null);
    }

    public SourceLocationFilter(String source, String locationName) {
        this.source = source;
        this.location = new SolarLocation();
        this.location.setName(locationName);
    }

    public String toString() {
        return "SourceLocationFilter{source=" + this.source + ",location=" + String.valueOf(this.location) + "}";
    }

    public void removeEmptyValues() {
        if (!StringUtils.hasText((String)this.source)) {
            this.source = null;
        }
        if (this.location != null) {
            this.location.removeEmptyValues();
        }
    }

    @Override
    @SerializeIgnore
    public Map<String, ?> getFilter() {
        LinkedHashMap<String, String> filter = new LinkedHashMap<String, String>();
        if (this.source != null) {
            filter.put("source", this.source);
        }
        if (this.location != null) {
            filter.putAll(this.location.getFilter());
        }
        return filter;
    }

    @SerializeIgnore
    public String getLocationName() {
        return this.location == null ? null : this.location.getName();
    }

    public void setLocationName(String locationName) {
        if (this.location == null) {
            this.location = new SolarLocation();
        }
        this.location.setName(locationName);
    }

    @SerializeIgnore
    public String getSourceName() {
        return this.getSource();
    }

    public void setSourceName(String sourceName) {
        this.setSource(sourceName);
    }

    @Override
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public SolarLocation getLocation() {
        return this.location;
    }

    public void setLocation(SolarLocation location) {
        this.location = location;
    }

    public List<SortDescriptor> getSortDescriptors() {
        if (this.sorts == null) {
            return Collections.emptyList();
        }
        return new ArrayList<MutableSortDescriptor>(this.sorts);
    }

    public String getTimeZoneId() {
        return this.location == null ? null : this.location.getTimeZoneId();
    }

    public void setTimeZoneId(String timeZoneId) {
        if (this.location == null) {
            this.location = new SolarLocation();
        }
        this.location.setTimeZoneId(timeZoneId);
    }

    public List<MutableSortDescriptor> getSorts() {
        return this.sorts;
    }

    public void setSorts(List<MutableSortDescriptor> sorts) {
        this.sorts = sorts;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.max == null ? 0 : this.max.hashCode());
        result = 31 * result + (this.offset == null ? 0 : this.offset.hashCode());
        result = 31 * result + (this.sorts == null ? 0 : this.sorts.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceLocationFilter)) {
            return false;
        }
        SourceLocationFilter other = (SourceLocationFilter)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.max == null ? other.max != null : !this.max.equals(other.max)) {
            return false;
        }
        if (this.offset == null ? other.offset != null : !this.offset.equals(other.offset)) {
            return false;
        }
        if (this.sorts == null ? other.sorts != null : !this.sorts.equals(other.sorts)) {
            return false;
        }
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }
}

