/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import net.solarnetwork.util.CachedResult;
import net.solarnetwork.util.ObjectUtils;

public class SimpleCache<K, V>
implements Cache<K, V> {
    public static final long DEFAULT_TTL = 60L;
    public static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.SECONDS;
    private final String name;
    private final ConcurrentMap<K, CachedValue> data;
    private long ttl = 60L;
    private TimeUnit timeUnit = DEFAULT_TIME_UNIT;

    public SimpleCache(String name) {
        this(name, new ConcurrentHashMap(64, 0.9f, 2));
    }

    public SimpleCache(String name, ConcurrentMap<K, ? extends CachedResult<V>> data) {
        this.name = (String)ObjectUtils.requireNonNullArgument((Object)name, (String)"name");
        this.data = (ConcurrentMap)ObjectUtils.requireNonNullArgument(data, (String)"data");
    }

    public V get(K key) {
        CachedValue result = (CachedValue)((Object)this.data.get(key));
        return (V)(result != null && result.isValid() ? result.getResult() : null);
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<K, V> result = new HashMap<K, V>(keys.size());
        for (K key : keys) {
            V v = this.get(key);
            if (v == null) continue;
            result.put(key, v);
        }
        return result;
    }

    public boolean containsKey(K key) {
        return this.get(key) != null;
    }

    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
        throw new UnsupportedOperationException();
    }

    public void put(K key, V value) {
        this.data.put(key, new CachedValue(this, key, value));
    }

    public V getAndPut(K key, V value) {
        CachedValue result = this.data.put(key, new CachedValue(this, key, value));
        return (V)(result != null && result.isValid() ? result.getResult() : null);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        if (map == null) {
            return;
        }
        for (Map.Entry<K, V> e : map.entrySet()) {
            this.data.put(e.getKey(), new CachedValue(this, e.getKey(), e.getValue()));
        }
    }

    public boolean putIfAbsent(K key, V value) {
        CachedValue result = this.data.compute(key, (k, v) -> {
            if (v == null || !v.isValid()) {
                return new CachedValue(this, key, value);
            }
            return null;
        });
        return result != null;
    }

    public boolean remove(K key) {
        return this.data.remove(key) != null;
    }

    public boolean remove(K key, V oldValue) {
        return this.data.remove(key, (Object)new CachedValue(this, key, oldValue));
    }

    public V getAndRemove(K key) {
        CachedValue result = (CachedValue)((Object)this.data.remove(key));
        return (V)(result != null && result.isValid() ? result.getResult() : null);
    }

    public boolean replace(K key, V oldValue, V newValue) {
        return this.data.replace(key, new CachedValue(this, key, oldValue), new CachedValue(this, key, newValue));
    }

    public boolean replace(K key, V value) {
        return this.data.replace(key, new CachedValue(this, key, value)) != null;
    }

    public V getAndReplace(K key, V value) {
        AtomicReference old = new AtomicReference();
        this.data.compute(key, (k, v) -> {
            if (v != null && v.isValid()) {
                old.set(v.getResult());
                return new CachedValue(this, key, value);
            }
            old.set(null);
            return null;
        });
        return old.get();
    }

    public void removeAll(Set<? extends K> keys) {
        if (keys == null) {
            return;
        }
        for (K key : keys) {
            this.data.remove(key);
        }
    }

    public void removeAll() {
        this.data.clear();
    }

    public void clear() {
        this.data.clear();
    }

    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        throw new UnsupportedOperationException();
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        throw new UnsupportedOperationException();
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.name;
    }

    public CacheManager getCacheManager() {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    public boolean isClosed() {
        return false;
    }

    public <T> T unwrap(Class<T> clazz) {
        throw new UnsupportedOperationException();
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        throw new UnsupportedOperationException();
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        throw new UnsupportedOperationException();
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        return new Iterator<Cache.Entry<K, V>>(){
            private final Iterator<Map.Entry<K, CachedValue>> itr;
            private Map.Entry<K, CachedValue> e;
            {
                this.itr = SimpleCache.this.data.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                this.e = null;
                while (this.itr.hasNext()) {
                    Map.Entry next = this.itr.next();
                    if (next.getValue().isValid()) {
                        this.e = next;
                        return true;
                    }
                    this.itr.remove();
                }
                return false;
            }

            @Override
            public Cache.Entry<K, V> next() {
                Map.Entry entry = this.e;
                if (entry == null) {
                    throw new NoSuchElementException();
                }
                return entry.getValue();
            }
        };
    }

    public long getTtl() {
        return this.ttl;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public final class CachedValue
    extends CachedResult<V>
    implements Cache.Entry<K, V> {
        private final K key;

        private CachedValue(SimpleCache this$0, K key, V value) {
            super(value, this$0.ttl, this$0.timeUnit);
            this.key = ObjectUtils.requireNonNullArgument(key, (String)"key");
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.getResult();
        }

        public <T> T unwrap(Class<T> clazz) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (CachedValue.class.isAssignableFrom(obj.getClass())) {
                CachedValue v = (CachedValue)((Object)obj);
                return Objects.equals(this.key, v.key) && Objects.equals(this.getResult(), v.getResult());
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.key, this.getResult());
        }
    }
}

