/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.support;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.solarnetwork.util.SearchFilter;
import net.solarnetwork.util.StringUtils;

public final class SearchFilterUtils {
    private SearchFilterUtils() {
    }

    public static String toSqlJsonPath(SearchFilter filter) {
        if (filter == null) {
            return null;
        }
        final LinkedList ancestors = new LinkedList();
        final StringBuilder buf = new StringBuilder();
        filter.walk(new SearchFilter.VisitorCallback(){

            public boolean visit(SearchFilter node, SearchFilter parentNode) {
                StackObj ref = null;
                if (parentNode == null) {
                    buf.append("$ ? (");
                }
                boolean found = false;
                Iterator itr = ancestors.iterator();
                while (itr.hasNext()) {
                    StackObj so = (StackObj)itr.next();
                    SearchFilter f = so.node;
                    if (f == parentNode) {
                        found = true;
                        ref = so;
                        continue;
                    }
                    if (!found) continue;
                    itr.remove();
                    if (so.op == SearchFilter.LogicOperator.NOT) continue;
                    buf.append(")");
                }
                if (!found) {
                    ref = new StackObj(parentNode != null ? parentNode.getLogicOperator() : node.getLogicOperator(), parentNode != null ? parentNode : node);
                    ancestors.add(ref);
                }
                if (node.hasNestedFilter()) {
                    if (ref.count > 0) {
                        switch (ref.op) {
                            case AND: {
                                buf.append(" && ");
                                break;
                            }
                            case OR: {
                                buf.append(" || ");
                                break;
                            }
                        }
                    }
                    if (node.getLogicOperator() == SearchFilter.LogicOperator.NOT) {
                        ++ref.count;
                    }
                    if (node.getLogicOperator() != SearchFilter.LogicOperator.NOT && parentNode != null) {
                        buf.append("(");
                    }
                }
                if (!node.hasNestedFilter()) {
                    SearchFilter.LogicOperator op = ref.op;
                    for (Map.Entry e : node.getFilter().entrySet()) {
                        switch (op) {
                            case AND: {
                                if (ref.count <= 0) break;
                                buf.append(" && ");
                                break;
                            }
                            case OR: {
                                if (ref.count <= 0) break;
                                buf.append(" || ");
                                break;
                            }
                            case NOT: {
                                buf.append("!(");
                            }
                        }
                        String k = (String)e.getKey();
                        Object v = e.getValue();
                        if (k != null && v != null) {
                            String s = v.toString();
                            Number n = StringUtils.numberValue((String)s);
                            if (node.getCompareOperator() == SearchFilter.CompareOperator.PRESENT) {
                                buf.append("exists (@.").append(k).append(")");
                            } else {
                                buf.append("@.").append(k).append(" ");
                                switch (node.getCompareOperator()) {
                                    case APPROX: 
                                    case OVERLAP: 
                                    case SUBSTRING: {
                                        buf.append("like_regex");
                                        break;
                                    }
                                    case EQUAL: {
                                        buf.append("==");
                                        break;
                                    }
                                    case GREATER_THAN: {
                                        buf.append(">");
                                        break;
                                    }
                                    case GREATER_THAN_EQUAL: {
                                        buf.append(">=");
                                        break;
                                    }
                                    case LESS_THAN: {
                                        buf.append("<");
                                        break;
                                    }
                                    case LESS_THAN_EQUAL: {
                                        buf.append("<=");
                                        break;
                                    }
                                    case NOT_EQUAL: {
                                        buf.append("!=");
                                        break;
                                    }
                                    case SUBSTRING_AT_START: {
                                        buf.append("starts with");
                                        break;
                                    }
                                }
                                buf.append(" ");
                                switch (node.getCompareOperator()) {
                                    case APPROX: 
                                    case OVERLAP: 
                                    case SUBSTRING: {
                                        this.appendJsonString(s);
                                        break;
                                    }
                                    default: {
                                        if (n == null) {
                                            this.appendJsonString(s);
                                            break;
                                        }
                                        buf.append(n);
                                    }
                                }
                            }
                        }
                        if (op == SearchFilter.LogicOperator.NOT) continue;
                        ++ref.count;
                    }
                    if (op == SearchFilter.LogicOperator.NOT) {
                        buf.append(")");
                    }
                }
                return true;
            }

            private void appendJsonString(String s) {
                buf.append("\"");
                buf.append(s.replace("\"", "\\\""));
                buf.append("\"");
            }
        });
        while (!ancestors.isEmpty()) {
            StackObj ref = (StackObj)ancestors.remove();
            if (ref.count <= 0) continue;
            buf.append(")");
        }
        return !buf.isEmpty() ? buf.toString() : null;
    }

    private static class StackObj {
        private final SearchFilter.LogicOperator op;
        private final SearchFilter node;
        private int count;

        private StackObj(SearchFilter.LogicOperator op, SearchFilter node) {
            this.op = op;
            this.node = node;
            this.count = 0;
        }

        public String toString() {
            return "StackObj{" + String.valueOf(this.node) + "," + this.count + "}";
        }
    }
}

