/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.support;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import net.solarnetwork.common.mqtt.BaseMqttConnectionService;
import net.solarnetwork.common.mqtt.MqttConnection;
import net.solarnetwork.common.mqtt.MqttConnectionFactory;
import net.solarnetwork.common.mqtt.MqttConnectionObserver;
import net.solarnetwork.service.ServiceLifecycleObserver;
import net.solarnetwork.util.ObjectUtils;
import net.solarnetwork.util.StatTracker;

public class ObservableMqttConnection
extends BaseMqttConnectionService
implements ServiceLifecycleObserver,
MqttConnectionObserver {
    public static final String DEFAULT_MQTT_HOST = "mqtts://influx.solarnetwork.net:8884";
    public static final String DEFAULT_MQTT_USERNAME = "solarnet-ocpp";
    private final String name;
    private final List<MqttConnectionObserver> connectionObservers;

    public ObservableMqttConnection(MqttConnectionFactory connectionFactory, StatTracker mqttStats, String name, List<MqttConnectionObserver> connectionObservers) {
        super(connectionFactory, mqttStats);
        this.name = (String)ObjectUtils.requireNonNullArgument((Object)name, (String)"name");
        this.connectionObservers = (List)ObjectUtils.requireNonNullArgument(connectionObservers, (String)"connectionObservers");
        this.getMqttConfig().setUsername(DEFAULT_MQTT_USERNAME);
        try {
            this.getMqttConfig().setServerUri(new URI(DEFAULT_MQTT_HOST));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String getPingTestName() {
        return this.name;
    }

    public String getPingTestId() {
        return ((Object)((Object)this)).getClass().getName() + "-" + this.name.replace(" ", "-");
    }

    public void serviceDidStartup() {
        this.init();
    }

    public void serviceDidShutdown() {
        this.shutdown();
    }

    public void onMqttServerConnectionEstablished(MqttConnection connection, boolean reconnected) {
        if (this.connectionObservers != null) {
            for (MqttConnectionObserver o : this.connectionObservers) {
                try {
                    o.onMqttServerConnectionEstablished(connection, reconnected);
                }
                catch (Throwable t) {
                    Throwable root = t;
                    while (root.getCause() != null) {
                        root = root.getCause();
                    }
                    this.log.error("Unhandled error in MQTT connection {} established observer {}: {}", new Object[]{this.getMqttConfig().getServerUri(), o, root.getMessage(), root});
                }
            }
        }
    }

    public void onMqttServerConnectionLost(MqttConnection connection, boolean willReconnect, Throwable cause) {
        if (this.connectionObservers != null) {
            for (MqttConnectionObserver o : this.connectionObservers) {
                try {
                    o.onMqttServerConnectionLost(connection, willReconnect, cause);
                }
                catch (Throwable t) {
                    Throwable root = t;
                    while (root.getCause() != null) {
                        root = root.getCause();
                    }
                    this.log.error("Unhandled error in MQTT connection {} lost observer {}: {}", new Object[]{this.getMqttConfig().getServerUri(), o, root.getMessage(), root});
                }
            }
        }
    }

    public List<MqttConnectionObserver> getConnectionObservers() {
        return this.connectionObservers;
    }
}

