/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.support;

import java.util.LinkedList;
import java.util.List;
import net.solarnetwork.central.dao.ObjectCriteria;
import net.solarnetwork.central.domain.Filter;
import net.solarnetwork.central.support.ObjectSearchFilter;

public class ObjectSearchFilters<T extends Filter>
implements Cloneable,
ObjectCriteria<T> {
    private ObjectCriteria.JoinType joinType = ObjectCriteria.JoinType.AND;
    private List<ObjectSearchFilter<T>> filters = new LinkedList<ObjectSearchFilter<T>>();
    private List<ObjectSearchFilters<T>> nestedFilters = new LinkedList<ObjectSearchFilters<T>>();
    private Integer resultOffset;
    private Integer resultMax;

    public ObjectSearchFilters(ObjectCriteria.JoinType joinType) {
        this.joinType = joinType;
    }

    public ObjectSearchFilters(T filter) {
        this(ObjectCriteria.JoinType.AND, filter);
    }

    public ObjectSearchFilters(ObjectCriteria.JoinType joinType, T filter) {
        this(joinType, filter, joinType);
    }

    public ObjectSearchFilters(ObjectCriteria.JoinType joinType, T filter, ObjectCriteria.JoinType filterJoinType) {
        this.joinType = joinType;
        this.filters.add(new ObjectSearchFilter<T>(filter, ObjectCriteria.MatchType.EQUAL, filterJoinType));
    }

    public ObjectSearchFilters<T> addNestedFilters(ObjectCriteria.JoinType nestedJoinType) {
        ObjectSearchFilters<T> sf = new ObjectSearchFilters<T>(nestedJoinType);
        this.nestedFilters.add(sf);
        return sf;
    }

    public void addObjectSearchFilter(ObjectSearchFilter<T> filter) {
        this.filters.add(filter);
    }

    public void addObjectSearchFilter(T filter, ObjectCriteria.MatchType mode, ObjectCriteria.JoinType joinType) {
        ObjectSearchFilter<T> osf = new ObjectSearchFilter<T>(filter, mode, joinType);
        this.filters.add(osf);
    }

    public void appendLdapSearchFilter(StringBuilder buf) {
        buf.append("(");
        if (this.filters == null && this.nestedFilters == null) {
            buf.append("objectClass=*");
        } else if (this.filters != null) {
            buf.append((Object)this.joinType);
        }
        if (this.filters != null) {
            for (ObjectSearchFilter objectSearchFilter : this.filters) {
                objectSearchFilter.appendLdapSearchFilter(buf);
            }
        }
        if (this.nestedFilters != null) {
            for (ObjectSearchFilters objectSearchFilters : this.nestedFilters) {
                objectSearchFilters.appendLdapSearchFilter(buf);
            }
        }
        buf.append(")");
    }

    public String asLdapSearchFilterString() {
        StringBuilder buf = new StringBuilder();
        this.appendLdapSearchFilter(buf);
        return buf.toString();
    }

    public Object clone() {
        try {
            ObjectSearchFilters clone = (ObjectSearchFilters)super.clone();
            clone.filters = new LinkedList<ObjectSearchFilter<T>>();
            for (ObjectSearchFilter<T> objectSearchFilter : this.filters) {
                clone.filters.add((ObjectSearchFilter)objectSearchFilter.clone());
            }
            clone.nestedFilters = new LinkedList<ObjectSearchFilters<T>>();
            for (ObjectSearchFilters objectSearchFilters : this.nestedFilters) {
                clone.nestedFilters.add((ObjectSearchFilters)objectSearchFilters.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.asLdapSearchFilterString();
    }

    private ObjectSearchFilter<T> getSimpleSearchFilter() {
        if (this.filters == null || this.filters.size() < 1) {
            return null;
        }
        return this.filters.get(0);
    }

    @Override
    public T getSimpleFilter() {
        ObjectSearchFilter<T> filter = this.getSimpleSearchFilter();
        if (filter == null) {
            return null;
        }
        return filter.getFilter();
    }

    @Override
    public ObjectCriteria.JoinType getSimpleJoinType() {
        ObjectSearchFilter<T> filter = this.getSimpleSearchFilter();
        if (filter == null) {
            return null;
        }
        return filter.getJoinType();
    }

    @Override
    public ObjectCriteria.MatchType getSimpleMatchType() {
        ObjectSearchFilter<T> filter = this.getSimpleSearchFilter();
        if (filter == null) {
            return null;
        }
        return filter.getMode();
    }

    public ObjectCriteria.JoinType getJoinType() {
        return this.joinType;
    }

    public List<ObjectSearchFilters<T>> getNestedFilters() {
        return this.nestedFilters;
    }

    public void setFilters(List<ObjectSearchFilter<T>> newFilters) {
        this.filters = newFilters;
    }

    public void setJoinType(ObjectCriteria.JoinType newJoinType) {
        this.joinType = newJoinType;
    }

    public void setNestedFilters(List<ObjectSearchFilters<T>> newNestedLdapSearchFilters) {
        this.nestedFilters = newNestedLdapSearchFilters;
    }

    @Override
    public Integer getResultOffset() {
        return this.resultOffset;
    }

    public void setResultOffset(Integer resultOffset) {
        this.resultOffset = resultOffset;
    }

    @Override
    public Integer getResultMax() {
        return this.resultMax;
    }

    public void setResultMax(Integer resultMax) {
        this.resultMax = resultMax;
    }
}

