/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.support;

import java.util.Arrays;
import java.util.Map;
import net.solarnetwork.central.dao.ObjectCriteria;
import net.solarnetwork.central.domain.Filter;

public class ObjectSearchFilter<T extends Filter>
implements Cloneable {
    private T filter;
    private ObjectCriteria.MatchType mode;
    private ObjectCriteria.JoinType joinType;

    public ObjectSearchFilter(T filter) {
        this(filter, ObjectCriteria.MatchType.EQUAL, ObjectCriteria.JoinType.AND);
    }

    public ObjectSearchFilter(T filter, ObjectCriteria.MatchType mode, ObjectCriteria.JoinType joinType) {
        this.filter = filter;
        this.mode = mode;
        this.joinType = joinType;
    }

    public void appendLdapSearchFilter(StringBuilder buf) {
        if (this.filter == null) {
            return;
        }
        Map<String, ?> filterMap = this.filter.getFilter();
        if (filterMap == null || filterMap.size() < 1) {
            return;
        }
        if (filterMap.size() > 1) {
            buf.append('(');
        }
        int idx = 0;
        for (Map.Entry<String, ?> me : filterMap.entrySet()) {
            if (idx > 0) {
                buf.append(this.joinType.toString());
            }
            String attributeName = me.getKey();
            Object value = me.getValue();
            buf.append('(');
            buf.append(attributeName);
            switch (this.mode) {
                case GREATER_THAN: {
                    buf.append(">");
                    break;
                }
                case GREATER_THAN_EQUAL: {
                    buf.append(">=");
                    break;
                }
                case LESS_THAN: {
                    buf.append("<");
                    break;
                }
                case LESS_THAN_EQUAL: {
                    buf.append("<=");
                    break;
                }
                case PRESENT: {
                    buf.append("=*");
                    break;
                }
                case APPROX: {
                    buf.append("~=");
                    break;
                }
                default: {
                    buf.append("=");
                }
            }
            if (this.mode == ObjectCriteria.MatchType.SUBSTRING) {
                if (value == null) {
                    buf.append("*");
                } else {
                    buf.append("*");
                    buf.append(value);
                    buf.append("*");
                }
            } else if (this.mode == ObjectCriteria.MatchType.SUBSTRING_AT_START) {
                if (value != null) {
                    buf.append(value);
                }
                buf.append("*");
            } else if (this.mode != ObjectCriteria.MatchType.PRESENT) {
                if (value == null) {
                    buf.append("*");
                } else if (value.getClass().isArray()) {
                    buf.append(Arrays.toString((Object[])value));
                } else {
                    buf.append(value);
                }
            }
            buf.append(')');
            ++idx;
        }
        if (filterMap.size() > 1) {
            buf.append(')');
        }
    }

    public String asLdapSearchFilterString() {
        StringBuilder buf = new StringBuilder();
        this.appendLdapSearchFilter(buf);
        return buf.toString();
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.asLdapSearchFilterString();
    }

    public T getFilter() {
        return this.filter;
    }

    public ObjectCriteria.MatchType getMode() {
        return this.mode;
    }

    public ObjectCriteria.JoinType getJoinType() {
        return this.joinType;
    }
}

