/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.support;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Map;
import net.solarnetwork.central.support.AbstractFilteredResultsProcessor;
import net.solarnetwork.codec.BasicObjectDatumStreamDataSetSerializer;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.util.MimeType;

public class ObjectMapperFilteredResultsProcessor<R>
extends AbstractFilteredResultsProcessor<R> {
    public static final SerializedString SUCCESS_FIELD_NAME = new SerializedString("success");
    private final JsonGenerator generator;
    private final SerializerProvider provider;
    private final JsonSerializer<R> serializer;
    private final MimeType mimeType;
    private int resultIndex = 0;

    public ObjectMapperFilteredResultsProcessor(JsonGenerator generator, SerializerProvider provider, MimeType mimeType, JsonSerializer<R> serializer) {
        this.generator = (JsonGenerator)ObjectUtils.requireNonNullArgument((Object)generator, (String)"generator");
        this.provider = (SerializerProvider)ObjectUtils.requireNonNullArgument((Object)provider, (String)"provider");
        this.mimeType = (MimeType)ObjectUtils.requireNonNullArgument((Object)mimeType, (String)"mimeType");
        this.serializer = serializer;
        this.generator.enable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
    }

    @Override
    public MimeType getMimeType() {
        return this.mimeType;
    }

    @Override
    public void start(Long totalResultCount, Integer startingOffset, Integer expectedResultCount, Map<String, ?> attributes) throws IOException {
        int count = 1 + (expectedResultCount != null ? 1 : 0) + (startingOffset != null ? 1 : 0) + (totalResultCount != null ? 1 : 0);
        this.generator.writeStartObject((Object)this, count);
        this.generator.writeFieldName((SerializableString)SUCCESS_FIELD_NAME);
        this.generator.writeBoolean(true);
        if (expectedResultCount != null) {
            this.generator.writeFieldName((SerializableString)BasicObjectDatumStreamDataSetSerializer.RETURNED_RESULT_COUNT_FIELD_NAME);
            this.generator.writeNumber(expectedResultCount.intValue());
        }
        if (startingOffset != null) {
            this.generator.writeFieldName((SerializableString)BasicObjectDatumStreamDataSetSerializer.STARTING_OFFSET_FIELD_NAME);
            this.generator.writeNumber(startingOffset.intValue());
        }
        if (totalResultCount != null) {
            this.generator.writeFieldName((SerializableString)BasicObjectDatumStreamDataSetSerializer.TOTAL_RESULT_COUNT_FIELD_NAME);
            this.generator.writeNumber(totalResultCount.longValue());
        }
    }

    @Override
    public void handleResultItem(R item) throws IOException {
        if (this.resultIndex == 0) {
            this.generator.writeFieldName((SerializableString)BasicObjectDatumStreamDataSetSerializer.DATA_FIELD_NAME);
            this.generator.writeStartArray();
        }
        if (this.serializer != null) {
            this.serializer.serialize(item, this.generator, this.provider);
        } else {
            this.generator.writeObject(item);
        }
        ++this.resultIndex;
    }

    @Override
    public void flush() throws IOException {
        this.generator.flush();
    }

    @Override
    public void close() throws IOException {
        if (!this.generator.isClosed()) {
            if (this.resultIndex > 0) {
                this.generator.writeEndArray();
            }
            this.generator.writeEndObject();
            this.generator.flush();
            this.generator.close();
        }
    }
}

