/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.support;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.time.Instant;
import net.solarnetwork.central.domain.NodeMetadata;
import net.solarnetwork.codec.JsonUtils;
import net.solarnetwork.domain.datum.GeneralDatumMetadata;

public class NodeMetadataSerializer
extends StdSerializer<NodeMetadata> {
    private static final long serialVersionUID = 6524627619550315956L;

    public NodeMetadataSerializer() {
        super(NodeMetadata.class);
    }

    public void serialize(NodeMetadata meta, JsonGenerator generator, SerializerProvider provider) throws IOException, JsonGenerationException {
        GeneralDatumMetadata metadata;
        Instant dt;
        if (meta == null) {
            generator.writeNull();
            return;
        }
        generator.writeStartObject();
        Long l = meta.getNodeId();
        if (l != null) {
            generator.writeNumberField("nodeId", l.longValue());
        }
        if ((dt = meta.getCreated()) != null) {
            generator.writeObjectField("created", (Object)dt);
        }
        if ((dt = meta.getUpdated()) != null) {
            generator.writeObjectField("updated", (Object)dt);
        }
        if ((metadata = meta.getMetadata()) != null) {
            JsonUtils.writeMetadata((JsonGenerator)generator, (GeneralDatumMetadata)metadata);
        }
        generator.writeEndObject();
    }
}

