/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.support;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Function;
import net.solarnetwork.central.RemoteServiceException;
import net.solarnetwork.central.support.BaseMqttConnectionObserver;
import net.solarnetwork.common.mqtt.BasicMqttMessage;
import net.solarnetwork.common.mqtt.MqttConnection;
import net.solarnetwork.common.mqtt.MqttMessage;
import net.solarnetwork.common.mqtt.MqttQos;
import net.solarnetwork.util.ObjectUtils;

public class MqttJsonPublisher<T>
extends BaseMqttConnectionObserver
implements Function<T, Future<?>> {
    private final ObjectMapper objectMapper;
    private final Function<T, String> topicFn;

    public MqttJsonPublisher(String name, ObjectMapper objectMapper, Function<T, String> topicFn, boolean retained, MqttQos publishQos) {
        this.setDisplayName((String)ObjectUtils.requireNonNullArgument((Object)name, (String)"name"));
        this.objectMapper = (ObjectMapper)ObjectUtils.requireNonNullArgument((Object)objectMapper, (String)"objectMapper");
        this.topicFn = (Function)ObjectUtils.requireNonNullArgument(topicFn, (String)"topicFn");
        this.setRetained(retained);
        this.setPublishQos((MqttQos)ObjectUtils.requireNonNullArgument((Object)publishQos, (String)"publishQos"));
    }

    @Override
    public Future<?> apply(T item) {
        String topic = this.topicFn.apply(item);
        return this.publish(item, topic);
    }

    protected Future<?> publish(T item, String topic) {
        return this.publish(item, topic, this.isRetained(), this.getPublishQos());
    }

    protected Future<?> publish(T item, String topic, boolean retained, MqttQos qos) {
        if (item == null || topic == null) {
            return CompletableFuture.completedFuture(null);
        }
        MqttConnection conn = (MqttConnection)this.mqttConnection.get();
        if (conn == null || !conn.isEstablished()) {
            this.log.debug("MQTT client not avaialable for publishing [{}] to SolarFlux", item);
            return CompletableFuture.failedFuture(new RemoteServiceException("Not connected to SolarFlux"));
        }
        try {
            byte[] payload = this.objectMapper.writeValueAsBytes(item);
            if (this.log.isDebugEnabled()) {
                JsonNode jsonData = this.objectMapper.valueToTree(item);
                this.log.debug("Publishing to MQTT topic {} JSON:\n{}", (Object)topic, (Object)jsonData);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Publishing to MQTT topic {}\n{}", (Object)topic, (Object)Base64.getEncoder().encodeToString(payload));
            }
            return conn.publish((MqttMessage)new BasicMqttMessage(topic, retained, qos, payload));
        }
        catch (IOException e) {
            Throwable root = e;
            while (root.getCause() != null) {
                root = root.getCause();
            }
            this.log.error("Error publishing {} to SolarFlux topic {}: {}", new Object[]{item, topic, root.toString(), e});
            return CompletableFuture.failedFuture(e);
        }
    }
}

