/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.support;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.SequencedSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class LinkedHashSetBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private final int capacity;
    private final AtomicInteger count = new AtomicInteger(0);
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private final Condition notFull = this.lock.newCondition();
    private final SequencedSet<E> delegate;

    public LinkedHashSetBlockingQueue(int capacity) {
        this(new LinkedHashSet(capacity), capacity);
    }

    public LinkedHashSetBlockingQueue(SequencedSet<E> delegate, int capacity) {
        this.delegate = delegate;
        this.capacity = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        AtomicInteger count = this.count;
        if (count.get() == this.capacity) {
            return false;
        }
        int c = -1;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (count.get() < this.capacity) {
                boolean wasAdded = this.delegate.add(e);
                int n = c = wasAdded ? count.getAndIncrement() : count.get();
                if (c + 1 < this.capacity) {
                    this.notFull.signal();
                }
            }
            if (c == 0) {
                this.notEmpty.signal();
            }
        }
        finally {
            lock.unlock();
        }
        return c >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        AtomicInteger count = this.count;
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            int c;
            while (count.get() == this.capacity) {
                this.notFull.await();
            }
            boolean wasAdded = this.delegate.add(e);
            int n = c = wasAdded ? count.getAndIncrement() : count.get();
            if (c + 1 < this.capacity) {
                this.notFull.signal();
            }
            if (c == 0) {
                this.notEmpty.signal();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        long nanos = unit.toNanos(timeout);
        AtomicInteger count = this.count;
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            int c;
            while (count.get() == this.capacity) {
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.notFull.awaitNanos(nanos);
            }
            boolean wasAdded = this.delegate.add(e);
            int n = c = wasAdded ? count.getAndIncrement() : count.get();
            if (c + 1 < this.capacity) {
                this.notFull.signal();
            }
            if (c == 0) {
                this.notEmpty.signal();
            }
        }
        finally {
            lock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        Object x;
        AtomicInteger count = this.count;
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (count.get() == 0) {
                this.notEmpty.await();
            }
            x = this.delegate.removeFirst();
            int c = count.getAndDecrement();
            if (c > 1) {
                this.notEmpty.signal();
            }
            if (c == this.capacity) {
                this.notFull.signal();
            }
        }
        finally {
            lock.unlock();
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        E x = null;
        long nanos = unit.toNanos(timeout);
        AtomicInteger count = this.count;
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (count.get() == 0) {
                if (nanos <= 0L) {
                    E e = null;
                    return e;
                }
                nanos = this.notEmpty.awaitNanos(nanos);
            }
            x = this.delegate.removeFirst();
            int c = count.getAndDecrement();
            if (c > 1) {
                this.notEmpty.signal();
            }
            if (c == this.capacity) {
                this.notFull.signal();
            }
        }
        finally {
            lock.unlock();
        }
        return x;
    }

    @Override
    public int remainingCapacity() {
        return this.capacity - this.size();
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        AtomicInteger count = this.count;
        ReentrantLock lock = this.lock;
        boolean signalNotFull = false;
        lock.lock();
        try {
            int n = Math.min(maxElements, count.get());
            Iterator it = this.delegate.iterator();
            for (int i = 0; i < n && it.hasNext(); ++i) {
                Object x = it.next();
                c.add(x);
            }
            count.getAndAdd(-n);
            if (signalNotFull) {
                this.notFull.signal();
            }
            int n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        Object x;
        AtomicInteger count = this.count;
        if (count.get() == 0) {
            return null;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (count.get() == 0) {
                E e = null;
                return e;
            }
            x = this.delegate.removeFirst();
            int c = count.getAndDecrement();
            if (c > 1) {
                this.notEmpty.signal();
            }
            if (c == this.capacity) {
                this.notFull.signal();
            }
        }
        finally {
            lock.unlock();
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        AtomicInteger count = this.count;
        if (count.get() == 0) {
            return null;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Iterator it = this.delegate.iterator();
            if (it.hasNext()) {
                Object e = it.next();
                return e;
            }
            E e = null;
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        final ReentrantLock lock = this.lock;
        final Iterator it = this.delegate.iterator();
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                lock.lock();
                try {
                    boolean bl = it.hasNext();
                    return bl;
                }
                finally {
                    lock.unlock();
                }
            }

            @Override
            public E next() {
                lock.lock();
                try {
                    Object e = it.next();
                    return e;
                }
                finally {
                    lock.unlock();
                }
            }

            @Override
            public void remove() {
                lock.lock();
                try {
                    it.remove();
                    LinkedHashSetBlockingQueue.this.count.getAndDecrement();
                }
                finally {
                    lock.unlock();
                }
            }
        };
    }

    @Override
    public int size() {
        return this.count.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        AtomicInteger count = this.count;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.delegate.remove(o)) {
                if (count.getAndDecrement() == this.capacity) {
                    this.notFull.signal();
                }
                boolean bl = true;
                return bl;
            }
        }
        finally {
            lock.unlock();
        }
        return false;
    }

    @Override
    public void clear() {
        AtomicInteger count = this.count;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.delegate.clear();
            count.set(0);
        }
        finally {
            lock.unlock();
        }
    }
}

