/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.support;

import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.AccessedExpiryPolicy;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.EternalExpiryPolicy;
import javax.cache.expiry.ModifiedExpiryPolicy;
import javax.cache.expiry.TouchedExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;
import javax.cache.spi.CachingProvider;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expirations;
import org.ehcache.jsr107.Eh107Configuration;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class JCacheFactoryBean<K, V>
implements FactoryBean<Cache<K, V>>,
InitializingBean {
    private final CacheManager cacheManager;
    private final Class<K> keyType;
    private final Class<V> valueType;
    private String name = "default";
    private boolean storeByValue = false;
    private boolean statisticsEnabled = false;
    private ExpiryPolicy expiryPolicy = null;
    private javax.cache.expiry.Duration expiryDuration = null;
    private Factory<? extends CacheLoader<K, V>> readThroughLoaderFactory;
    private boolean readThrough = false;
    private Factory<? extends CacheWriter<K, V>> writeThroughWriterFactory;
    private boolean writeThrough = false;
    private Integer heapMaxEntries = null;
    private Integer diskMaxSizeMB = null;
    private boolean diskPersistent = false;
    private Cache<K, V> cache;

    public JCacheFactoryBean(CacheManager cacheManager, Class<K> keyType, Class<V> valueType) {
        this.cacheManager = cacheManager;
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public void afterPropertiesSet() throws Exception {
        CachingProvider provider = this.cacheManager.getCachingProvider();
        Configuration cacheConfig = null;
        if (this.heapMaxEntries != null || this.diskMaxSizeMB != null && "org.ehcache.jsr107.EhcacheCachingProvider".equals(provider.getClass().getName())) {
            CacheConfigurationBuilder cacheConfigBuilder = CacheConfigurationBuilder.newCacheConfigurationBuilder(this.keyType, this.valueType, (Builder)ResourcePoolsBuilder.heap((long)Integer.MAX_VALUE));
            ResourcePoolsBuilder poolsBuilder = ResourcePoolsBuilder.newResourcePoolsBuilder();
            if (this.heapMaxEntries != null) {
                poolsBuilder = poolsBuilder.heap(this.heapMaxEntries.longValue(), (ResourceUnit)EntryUnit.ENTRIES);
            }
            if (this.diskMaxSizeMB != null) {
                poolsBuilder = poolsBuilder.disk(this.diskMaxSizeMB.longValue(), MemoryUnit.MB, this.diskPersistent);
            }
            cacheConfigBuilder = (CacheConfigurationBuilder)cacheConfigBuilder.withResourcePools((Builder)poolsBuilder);
            if (this.expiryPolicy != null) {
                switch (this.expiryPolicy.ordinal()) {
                    case 0: 
                    case 2: 
                    case 3: {
                        cacheConfigBuilder = cacheConfigBuilder.withExpiry(Expirations.timeToIdleExpiration((Duration)Duration.of((long)this.expiryDuration.getDurationAmount(), (TimeUnit)this.expiryDuration.getTimeUnit())));
                        break;
                    }
                    case 1: {
                        cacheConfigBuilder = cacheConfigBuilder.withExpiry(Expirations.timeToLiveExpiration((Duration)Duration.of((long)this.expiryDuration.getDurationAmount(), (TimeUnit)this.expiryDuration.getTimeUnit())));
                        break;
                    }
                    case 4: {
                        cacheConfigBuilder = cacheConfigBuilder.withExpiry(Expirations.noExpiration());
                    }
                }
            }
            cacheConfig = Eh107Configuration.fromEhcacheCacheConfiguration((CacheConfiguration)cacheConfigBuilder.build());
        }
        if (cacheConfig == null) {
            MutableConfiguration configuration = new MutableConfiguration().setTypes(this.keyType, this.valueType).setStoreByValue(this.storeByValue).setStatisticsEnabled(this.statisticsEnabled);
            if (this.expiryPolicy != null) {
                switch (this.expiryPolicy.ordinal()) {
                    case 0: {
                        configuration.setExpiryPolicyFactory(AccessedExpiryPolicy.factoryOf((javax.cache.expiry.Duration)this.expiryDuration));
                        break;
                    }
                    case 1: {
                        configuration.setExpiryPolicyFactory(CreatedExpiryPolicy.factoryOf((javax.cache.expiry.Duration)this.expiryDuration));
                        break;
                    }
                    case 2: {
                        configuration.setExpiryPolicyFactory(ModifiedExpiryPolicy.factoryOf((javax.cache.expiry.Duration)this.expiryDuration));
                        break;
                    }
                    case 3: {
                        configuration.setExpiryPolicyFactory(TouchedExpiryPolicy.factoryOf((javax.cache.expiry.Duration)this.expiryDuration));
                        break;
                    }
                    case 4: {
                        configuration.setExpiryPolicyFactory(EternalExpiryPolicy.factoryOf());
                    }
                }
            }
            if (this.readThroughLoaderFactory != null && this.readThrough) {
                configuration.setCacheLoaderFactory(this.readThroughLoaderFactory).setReadThrough(true);
            }
            if (this.writeThroughWriterFactory != null && this.writeThrough) {
                configuration.setCacheWriterFactory(this.writeThroughWriterFactory).setWriteThrough(true);
            }
            cacheConfig = configuration;
        }
        this.cache = this.cacheManager.createCache(this.name, cacheConfig);
    }

    public Cache<K, V> getObject() throws Exception {
        if (this.cache == null) {
            this.afterPropertiesSet();
        }
        return this.cache;
    }

    public Class<?> getObjectType() {
        return this.cache != null ? this.cache.getClass() : Cache.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStoreByValue(boolean storeByValue) {
        this.storeByValue = storeByValue;
    }

    public void setExpiryPolicy(ExpiryPolicy expiryPolicy) {
        this.expiryPolicy = expiryPolicy;
    }

    public void setExpiryDuration(javax.cache.expiry.Duration expiryDuration) {
        this.expiryDuration = expiryDuration;
    }

    public void setReadThrough(boolean readThrough) {
        this.readThrough = readThrough;
    }

    public void setWriteThrough(boolean writeThrough) {
        this.writeThrough = writeThrough;
    }

    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    public void setReadThroughLoaderFactory(Factory<? extends CacheLoader<K, V>> readThroughLoaderFactory) {
        this.readThroughLoaderFactory = readThroughLoaderFactory;
    }

    public void setWriteThroughWriterFactory(Factory<? extends CacheWriter<K, V>> writeThroughWriterFactory) {
        this.writeThroughWriterFactory = writeThroughWriterFactory;
    }

    public void setHeapMaxEntries(Integer heapMaxEntries) {
        this.heapMaxEntries = heapMaxEntries;
    }

    public void setDiskMaxSizeMB(Integer diskMaxSizeMB) {
        this.diskMaxSizeMB = diskMaxSizeMB;
    }

    public boolean isDiskPersistent() {
        return this.diskPersistent;
    }

    public void setDiskPersistent(boolean diskPersistent) {
        this.diskPersistent = diskPersistent;
    }

    public static enum ExpiryPolicy {
        Accessed,
        Created,
        Updated,
        Touched,
        Eternal;

    }
}

