/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.support;

import java.text.ParseException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.format.Formatter;

public class InstantFormatter
implements Formatter<Instant> {
    private final DateTimeFormatter formatter;
    private final DateTimeFormatter[] fallbackFormatters;

    public InstantFormatter(DateTimeFormatter formatter) {
        this(formatter, null);
    }

    public InstantFormatter(DateTimeFormatter formatter, DateTimeFormatter ... fallbackFormatters) {
        this.formatter = (DateTimeFormatter)ObjectUtils.requireNonNullArgument((Object)formatter, (String)"formatter");
        this.fallbackFormatters = fallbackFormatters;
    }

    public String print(Instant object, Locale locale) {
        return this.formatter.format(object);
    }

    public Instant parse(String text, Locale locale) throws ParseException {
        try {
            return this.formatter.parse((CharSequence)text, Instant::from);
        }
        catch (DateTimeParseException e) {
            if (this.fallbackFormatters != null) {
                for (DateTimeFormatter fmt : this.fallbackFormatters) {
                    try {
                        return fmt.parse((CharSequence)text, Instant::from);
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                    }
                }
            }
            throw e;
        }
    }
}

