/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.support;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.EventType;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import net.solarnetwork.util.ObjectUtils;

public class ExpandedEventsCache<K, V>
implements Cache<K, V> {
    private final Cache<K, V> delegate;
    private CacheEntryRemovedListener<? super K, ? super V> removedListener;

    public ExpandedEventsCache(Cache<K, V> delegate) {
        this.delegate = (Cache)ObjectUtils.requireNonNullArgument(delegate, (String)"delegate");
    }

    public void forEach(Consumer<? super Cache.Entry<K, V>> action) {
        this.delegate.forEach(action);
    }

    public Spliterator<Cache.Entry<K, V>> spliterator() {
        return this.delegate.spliterator();
    }

    public V get(K key) {
        return (V)this.delegate.get(key);
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        return this.delegate.getAll(keys);
    }

    public boolean containsKey(K key) {
        return this.delegate.containsKey(key);
    }

    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
        this.delegate.loadAll(keys, replaceExistingValues, completionListener);
    }

    public void put(K key, V value) {
        this.delegate.put(key, value);
    }

    public V getAndPut(K key, V value) {
        return (V)this.delegate.getAndPut(key, value);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.delegate.putAll(map);
    }

    public boolean putIfAbsent(K key, V value) {
        return this.delegate.putIfAbsent(key, value);
    }

    public boolean remove(K key) {
        return this.delegate.remove(key);
    }

    public boolean remove(K key, V oldValue) {
        return this.delegate.remove(key, oldValue);
    }

    public V getAndRemove(K key) {
        Object old = this.delegate.getAndRemove(key);
        if (old != null) {
            this.publishRemovedEvent(key, old);
        }
        return (V)old;
    }

    public boolean replace(K key, V oldValue, V newValue) {
        return this.delegate.replace(key, oldValue, newValue);
    }

    public boolean replace(K key, V value) {
        return this.delegate.replace(key, value);
    }

    public V getAndReplace(K key, V value) {
        return (V)this.delegate.getAndReplace(key, value);
    }

    public void removeAll(Set<? extends K> keys) {
        this.delegate.removeAll(keys);
    }

    public void removeAll() {
        this.delegate.removeAll();
    }

    public void clear() {
        this.delegate.clear();
    }

    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        return (C)this.delegate.getConfiguration(clazz);
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        return (T)this.delegate.invoke(key, entryProcessor, arguments);
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        return this.delegate.invokeAll(keys, entryProcessor, arguments);
    }

    public String getName() {
        return this.delegate.getName();
    }

    public CacheManager getCacheManager() {
        return this.delegate.getCacheManager();
    }

    public void close() {
        this.delegate.close();
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)this.delegate.unwrap(clazz);
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> config) {
        CacheEntryListener listener = (CacheEntryListener)config.getCacheEntryListenerFactory().create();
        if (listener instanceof CacheEntryRemovedListener) {
            this.removedListener = (CacheEntryRemovedListener)listener;
        }
        this.delegate.registerCacheEntryListener(config);
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> config) {
        CacheEntryListener listener = (CacheEntryListener)config.getCacheEntryListenerFactory().create();
        if (listener instanceof CacheEntryRemovedListener) {
            this.removedListener = null;
        }
        this.delegate.deregisterCacheEntryListener(config);
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        return this.delegate.iterator();
    }

    private void publishRemovedEvent(K key, V value) {
        if (this.removedListener != null) {
            this.removedListener.onRemoved(Collections.singleton(new CacheEntryEventImpl(key, value, EventType.REMOVED)));
        }
    }

    private final class CacheEntryEventImpl
    extends CacheEntryEvent<K, V> {
        private static final long serialVersionUID = 6369201595734400543L;
        private final K key;
        private final V value;

        private CacheEntryEventImpl(K key, V value, EventType eventType) {
            super((Cache)ExpandedEventsCache.this, eventType);
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public <T> T unwrap(Class<T> arg0) {
            throw new UnsupportedOperationException();
        }

        public V getOldValue() {
            return null;
        }

        public boolean isOldValueAvailable() {
            return false;
        }
    }
}

