/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.support;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import net.solarnetwork.domain.Result;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;
import org.springframework.validation.beanvalidation.SpringValidatorAdapter;

public final class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static String generateErrorsMessage(Errors e, Locale locale, MessageSource msgSrc) {
        String msg;
        String string = msg = msgSrc == null ? "Validation error" : msgSrc.getMessage("error.validation", null, "Validation error", locale);
        if (msgSrc != null && e != null && e.hasErrors()) {
            StringBuilder buf = new StringBuilder();
            for (ObjectError error : e.getAllErrors()) {
                if (buf.length() > 0) {
                    buf.append(" ");
                }
                buf.append(msgSrc.getMessage((MessageSourceResolvable)error, locale));
            }
            msg = buf.toString();
        }
        return msg;
    }

    public static <V> Result<V> generateErrorsResult(Errors e, String code, Locale locale, MessageSource msgSrc) {
        return ExceptionUtils.generateErrorsResult(e, code, ExceptionUtils.generateErrorsMessage(e, locale, msgSrc), locale, msgSrc);
    }

    public static <V> Result<V> generateErrorsResult(Errors e, String code, String message, Locale locale, MessageSource msgSrc) {
        ArrayList<Result.ErrorDetail> details = null;
        if (msgSrc != null && e != null && e.hasErrors()) {
            for (ObjectError error : e.getGlobalErrors()) {
                if (details == null) {
                    details = new ArrayList<Result.ErrorDetail>(4);
                }
                details.add(new Result.ErrorDetail(error.getObjectName(), null, msgSrc.getMessage((MessageSourceResolvable)error, locale)));
            }
            for (ObjectError error : e.getFieldErrors()) {
                String rejectedValueDescription;
                if (details == null) {
                    details = new ArrayList(4);
                }
                ConstraintViolation violation = null;
                if (error.contains(ConstraintViolation.class)) {
                    violation = (ConstraintViolation)error.unwrap(ConstraintViolation.class);
                }
                String location = violation != null ? violation.getPropertyPath().toString() : String.format("%s.%s", error.getObjectName(), error.getField());
                String violationCode = violation != null ? violation.getConstraintDescriptor().getAnnotation().annotationType().getSimpleName() : null;
                rejectedValueDescription = error.getRejectedValue() != null ? (rejectedValueDescription = error.getRejectedValue().toString()) : null;
                details.add(new Result.ErrorDetail(location, violationCode, rejectedValueDescription, msgSrc.getMessage((MessageSourceResolvable)error, locale)));
            }
        }
        return Result.error((String)code, (String)message, details);
    }

    public static BindingResult toBindingResult(ConstraintViolationException e, Validator validator) {
        Object violation;
        Object object = null;
        Iterator iterator = e.getConstraintViolations().iterator();
        if (iterator.hasNext()) {
            violation = (ConstraintViolation)iterator.next();
            object = violation.getLeafBean() != null ? violation.getLeafBean() : violation.getRootBean();
        }
        try {
            BeanPropertyBindingResult bindingResult = new BeanPropertyBindingResult(object, "input");
            new SpringValidatorAdapterSupport(validator, e, (BindingResult)bindingResult);
            return bindingResult;
        }
        catch (IllegalStateException e2) {
            violation = e.getConstraintViolations().iterator();
            if (violation.hasNext()) {
                ConstraintViolation violation2 = (ConstraintViolation)violation.next();
                object = violation2.getRootBean();
            }
            BeanPropertyBindingResult bindingResult = new BeanPropertyBindingResult(object, "input");
            try {
                new SpringValidatorAdapterSupport(validator, e, (BindingResult)bindingResult);
                return bindingResult;
            }
            catch (IllegalStateException e3) {
                bindingResult.addError(new ObjectError("input", "Input is invalid."));
                return bindingResult;
            }
        }
    }

    private static class SpringValidatorAdapterSupport
    extends SpringValidatorAdapter {
        private SpringValidatorAdapterSupport(Validator validator, ConstraintViolationException exception, BindingResult errors) {
            super(validator);
            this.processConstraintViolations(exception.getConstraintViolations(), (Errors)errors);
        }
    }
}

