/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.support;

import java.util.Map;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.SmartValidator;
import org.springframework.validation.Validator;

public class DelegatingValidator
implements SmartValidator {
    private final Map<String, Validator> validators;

    public DelegatingValidator(Map<String, Validator> validators) {
        this.validators = (Map)ObjectUtils.requireNonNullArgument(validators, (String)"validators");
    }

    public boolean supports(Class<?> clazz) {
        return this.validators.containsKey(clazz.getName());
    }

    public void validate(Object target, Errors errors) {
        this.validate(target, errors, null);
    }

    public void validate(Object target, Errors errors, Object ... validationHints) {
        String key;
        String string = key = target != null ? target.getClass().getName() : null;
        if (key == null) {
            errors.reject("validation.null", "Object must not be null.");
            return;
        }
        Validator delegate = this.validators.get(key);
        if (delegate == null) {
            return;
        }
        if (delegate instanceof SmartValidator) {
            ((SmartValidator)delegate).validate(target, errors, validationHints);
        } else {
            delegate.validate(target, errors);
        }
    }
}

