/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.support;

import java.text.ParseException;
import java.util.Locale;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.format.Parser;

public class DelegatingParser<T>
implements Parser<T> {
    final Parser<T>[] delegates;

    @SafeVarargs
    public DelegatingParser(Parser<T> ... delegates) {
        this.delegates = (Parser[])ObjectUtils.requireNonNullArgument(delegates, (String)"delegates");
        if (delegates.length < 1) {
            throw new IllegalArgumentException("At least one delegate parser must be provided.");
        }
    }

    public T parse(String text, Locale locale) throws ParseException {
        ParseException exception = null;
        RuntimeException runtimeException = null;
        for (Parser<T> p : this.delegates) {
            try {
                return (T)p.parse(text, locale);
            }
            catch (ParseException e) {
                if (exception != null) continue;
                exception = e;
            }
            catch (RuntimeException e) {
                if (runtimeException != null) continue;
                runtimeException = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
        return null;
    }
}

