/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.support;

import java.time.Clock;
import java.time.Duration;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Queue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.solarnetwork.central.biz.AsyncProcessor;
import net.solarnetwork.service.PingTest;
import net.solarnetwork.service.PingTestResult;
import net.solarnetwork.service.ServiceLifecycleObserver;
import net.solarnetwork.util.ObjectUtils;
import net.solarnetwork.util.StatTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;

public abstract class DelayedOcassionalProcessor<T>
implements AsyncProcessor<T>,
Runnable,
ServiceLifecycleObserver,
PingTest {
    public static final Duration DEFAULT_DELAY = Duration.ofSeconds(2L);
    public static final int DEFAULT_QUEUE_SIZE_ALERT_THRESHOLD = 500;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Clock clock;
    protected final StatTracker stats;
    private final TaskScheduler scheduler;
    private final Queue<T> items;
    private Duration delay = DEFAULT_DELAY;
    private int queueSizeAlertThreshold = 500;
    private final Lock flushLock;
    private ScheduledFuture<?> flushTask;

    public DelayedOcassionalProcessor(Clock clock, StatTracker stats, TaskScheduler scheduler, Queue<T> items) {
        this.clock = (Clock)ObjectUtils.requireNonNullArgument((Object)clock, (String)"clock");
        this.stats = (StatTracker)ObjectUtils.requireNonNullArgument((Object)stats, (String)"stats");
        this.scheduler = (TaskScheduler)ObjectUtils.requireNonNullArgument((Object)scheduler, (String)"scheduler");
        this.items = (Queue)ObjectUtils.requireNonNullArgument(items, (String)"statuses");
        this.flushLock = new ReentrantLock();
    }

    public void serviceDidStartup() {
    }

    public void serviceDidShutdown() {
        this.flushLock.lock();
        try {
            if (this.flushTask != null && this.flushTask.isDone()) {
                this.flushTask.cancel(true);
            }
            T item = null;
            while (true) {
                T t = this.items.poll();
                item = t;
                if (t != null) {
                    this.stats.increment((Enum)Stats.ItemsRemoved);
                    try {
                        this.processItemInternal(item);
                        this.stats.increment((Enum)Stats.ItemsProcessed);
                    }
                    catch (Exception e) {
                        this.stats.increment((Enum)Stats.ItemsFailed);
                        this.log.error("Error processing delayed item [{}]: {}", new Object[]{item, e.getMessage(), e});
                    }
                    continue;
                }
                break;
            }
        }
        finally {
            this.flushLock.unlock();
        }
    }

    @Override
    public void asyncProcessItem(T item) {
        this.items.add(item);
        this.stats.increment((Enum)Stats.ItemsAdded);
        this.flushLock.lock();
        try {
            if (this.flushTask == null || this.flushTask.isDone()) {
                this.scheduleFlushTask();
            }
        }
        finally {
            this.flushLock.unlock();
        }
    }

    @Override
    public boolean cancelAsyncProcessItem(T item) {
        boolean result = false;
        this.flushLock.lock();
        try {
            result = this.items.remove(item);
        }
        finally {
            this.flushLock.unlock();
        }
        if (result) {
            this.stats.increment((Enum)Stats.ItemsRemoved);
        }
        return result;
    }

    protected abstract void processItemInternal(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.stats.increment((Enum)Stats.Batches);
        try {
            T item = null;
            while (true) {
                T t = this.items.poll();
                item = t;
                if (t != null) {
                    this.stats.increment((Enum)Stats.ItemsRemoved);
                    try {
                        this.processItemInternal(item);
                        this.stats.increment((Enum)Stats.ItemsProcessed);
                    }
                    catch (Exception e) {
                        this.log.error("Error processing delayed item [{}]: {}", new Object[]{item, e.getMessage(), e});
                    }
                    continue;
                }
                break;
            }
        }
        finally {
            this.flushLock.lock();
            try {
                if (this.items.isEmpty()) {
                    this.flushTask = null;
                } else {
                    this.scheduleFlushTask();
                }
            }
            finally {
                this.flushLock.unlock();
            }
        }
    }

    private void scheduleFlushTask() {
        Duration delay = this.getDelay();
        this.flushTask = this.scheduler.schedule((Runnable)this, this.clock.instant().plus(delay));
    }

    public String getPingTestId() {
        return this.stats.getUid() != null ? this.stats.getUid() : this.getClass().getName();
    }

    public String getPingTestName() {
        return this.stats.getDisplayName();
    }

    public long getPingTestMaximumExecutionMilliseconds() {
        return 1000L;
    }

    public PingTest.Result performPingTest() throws Exception {
        int size = this.items.size();
        int threshold = this.queueSizeAlertThreshold;
        NavigableMap statMap = this.stats.allCounts();
        statMap.put(Stats.QueueSize.name(), Long.valueOf(size));
        return new PingTestResult(size <= threshold, size > threshold ? "Queue size %d is over %d.".formatted(size, threshold) : null, (Map)statMap);
    }

    public final Duration getDelay() {
        return this.delay;
    }

    public final void setDelay(Duration delay) {
        this.delay = delay;
    }

    public final int getQueueSizeAlertThreshold() {
        return this.queueSizeAlertThreshold;
    }

    public final void setQueueSizeAlertThreshold(int queueSizeAlertThreshold) {
        this.queueSizeAlertThreshold = queueSizeAlertThreshold;
    }

    public static enum Stats {
        ItemsAdded,
        ItemsRemoved,
        ItemsProcessed,
        ItemsFailed,
        QueueSize,
        Batches;

    }
}

