/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.support;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.solarnetwork.central.support.AbstractFilteredResultsProcessor;
import net.solarnetwork.codec.PropertySerializerRegistrar;
import net.solarnetwork.domain.SerializeIgnore;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.MimeType;
import org.supercsv.io.CsvListWriter;
import org.supercsv.io.ICsvListWriter;
import org.supercsv.prefs.CsvPreference;

public class CsvFilteredResultsProcessor<R>
extends AbstractFilteredResultsProcessor<R> {
    public static final MimeType TEXT_CSV_MIME_TYPE = MimeType.valueOf((String)"text/csv");
    public static final Set<String> DEFAULT_JAVA_BEAN_IGNORE_PROPERTIES = Collections.singleton("class");
    public static final Set<Class<?>> DEFAULT_JAVA_BEAN_STRING_VALUES = Collections.singleton(Class.class);
    private final PropertySerializerRegistrar propertySerializerRegistrar;
    private final Set<String> javaBeanIgnoreProperties;
    private final Set<Class<?>> javaBeanTreatAsStringValues;
    private final boolean includeHeader;
    private final MimeType mimeType;
    private final ICsvListWriter writer;
    private Map<String, Integer> columnOrder = new LinkedHashMap<String, Integer>(8);
    private int columnCount = 0;
    private long rowNum = -1L;
    private Map<Class<?>, Map<String, Boolean>> ignoredProperties = new HashMap(8);
    private Map<Class<?>, String[]> propertyOrder = new HashMap(8);

    public CsvFilteredResultsProcessor(Writer out) {
        this(out, true);
    }

    public CsvFilteredResultsProcessor(Writer out, boolean includeHeader) {
        this(out, TEXT_CSV_MIME_TYPE, includeHeader, null, DEFAULT_JAVA_BEAN_IGNORE_PROPERTIES, DEFAULT_JAVA_BEAN_STRING_VALUES);
    }

    public CsvFilteredResultsProcessor(Writer out, MimeType mimeType, boolean includeHeader, PropertySerializerRegistrar propertySerializerRegistrar) {
        this(out, mimeType, includeHeader, propertySerializerRegistrar, DEFAULT_JAVA_BEAN_IGNORE_PROPERTIES, DEFAULT_JAVA_BEAN_STRING_VALUES);
    }

    public CsvFilteredResultsProcessor(Writer out, MimeType mimeType, boolean includeHeader, PropertySerializerRegistrar propertySerializerRegistrar, Set<String> javaBeanIgnoreProperties, Set<Class<?>> javaBeanTreatAsStringValues) {
        this.writer = new CsvListWriter((Writer)ObjectUtils.requireNonNullArgument((Object)out, (String)"out"), CsvPreference.STANDARD_PREFERENCE);
        this.mimeType = mimeType;
        this.includeHeader = includeHeader;
        this.propertySerializerRegistrar = propertySerializerRegistrar;
        this.javaBeanIgnoreProperties = (Set)ObjectUtils.requireNonNullArgument(javaBeanIgnoreProperties, (String)"javaBeanIgnoreProperties");
        this.javaBeanTreatAsStringValues = (Set)ObjectUtils.requireNonNullArgument(javaBeanTreatAsStringValues, (String)"javaBeanTreatAsStringValues");
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    @Override
    public MimeType getMimeType() {
        return this.mimeType;
    }

    @Override
    public void handleResultItem(R item) throws IOException {
        if (item == null) {
            return;
        }
        Map<String, Object> rowProperties = this.extractProperties(item);
        if (rowProperties == null) {
            return;
        }
        ++this.rowNum;
        if (this.rowNum == 0L && this.includeHeader) {
            this.writer.writeHeader((String[])this.columnOrder.keySet().stream().toArray(String[]::new));
        }
        Object[] row = new Object[this.columnCount];
        int i = 0;
        for (String key : this.columnOrder.keySet()) {
            row[i++] = rowProperties.get(key);
        }
        this.writer.write(row);
    }

    private void updateColumnOrder(String key) {
        this.columnOrder.computeIfAbsent(key, aKey -> {
            int size = this.columnOrder.size();
            this.columnCount = size + 1;
            return size;
        });
    }

    private Map<String, Object> extractProperties(Object item) {
        if (this.propertySerializerRegistrar != null && (item = this.propertySerializerRegistrar.serializeProperty("rowNum", item.getClass(), item, item)) == null) {
            return null;
        }
        if (item instanceof Map) {
            Map map = (Map)item;
            HashMap<String, Object> result = new HashMap<String, Object>(map.size());
            for (Map.Entry e : map.entrySet()) {
                String key;
                Object val;
                Object k2 = e.getKey();
                if (k2 == null || (val = this.getRowPropertyValue(item, key = k2.toString(), e.getValue(), null)) == null) continue;
                this.updateColumnOrder(key);
                result.put(key, val);
            }
        } else {
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)item);
            PropertyDescriptor[] descriptors = wrapper.getPropertyDescriptors();
            Class<?> clazz = item.getClass();
            if (descriptors != null) {
                String[] propOrder = this.propertyOrder.computeIfAbsent(clazz, k -> {
                    JsonPropertyOrder order = (JsonPropertyOrder)AnnotationUtils.findAnnotation((Class)clazz, JsonPropertyOrder.class);
                    if (order != null) {
                        return order.value();
                    }
                    return new String[0];
                });
                if (propOrder.length > 0) {
                    Arrays.sort(descriptors, (l, r) -> {
                        int lIdx = -1;
                        int rIdx = -1;
                        for (int i = 0; i < propOrder.length && lIdx < 0 && rIdx < 0; ++i) {
                            if (propOrder[i].equals(l.getName())) {
                                lIdx = i;
                                continue;
                            }
                            if (!propOrder[i].equals(r.getName())) continue;
                            rIdx = i;
                        }
                        return Integer.compare(rIdx, lIdx);
                    });
                }
                HashMap<String, Object> result = new HashMap<String, Object>(descriptors.length);
                for (PropertyDescriptor desc : descriptors) {
                    String key = desc.getName();
                    if (this.javaBeanIgnoreProperties.contains(key) || !wrapper.isReadableProperty(key) || this.shouldIgnoreProperty(item, key, desc)) continue;
                    Object val = wrapper.getPropertyValue(key);
                    if ((val = this.getRowPropertyValue(item, key, val, wrapper)) == null) continue;
                    this.updateColumnOrder(key);
                    result.put(key, val);
                }
                return result;
            }
        }
        return null;
    }

    private boolean shouldIgnoreProperty(Object item, String key, PropertyDescriptor desc) {
        Map<String, Boolean> classMap = this.ignoredProperties.get(item.getClass());
        if (classMap != null && classMap.containsKey(key)) {
            return classMap.get(key);
        }
        boolean result = false;
        Method m = desc.getReadMethod();
        if (AnnotationUtils.getAnnotation((Method)m, JsonIgnore.class) != null || AnnotationUtils.getAnnotation((Method)m, SerializeIgnore.class) != null) {
            result = true;
        } else {
            String[] ignored;
            JsonIgnoreProperties annot = (JsonIgnoreProperties)AnnotationUtils.findAnnotation(item.getClass(), JsonIgnoreProperties.class);
            if (annot != null && (ignored = annot.value()) != null) {
                for (String prop : ignored) {
                    if (!prop.equals(key)) continue;
                    result = true;
                    break;
                }
            }
        }
        this.ignoredProperties.computeIfAbsent(item.getClass(), k -> new HashMap(8)).put(key, result);
        return result;
    }

    private Object getRowPropertyValue(Object row, String name, Object val, BeanWrapper wrapper) {
        if (val != null) {
            PropertyEditor editor;
            if (this.getPropertySerializerRegistrar() != null) {
                val = this.getPropertySerializerRegistrar().serializeProperty(name, val.getClass(), row, val);
            } else if (wrapper != null && (editor = wrapper.findCustomEditor(null, name)) != null) {
                editor.setValue(val);
                val = editor.getAsText();
            }
            if (val instanceof Enum || this.javaBeanTreatAsStringValues != null && this.javaBeanTreatAsStringValues.contains(val.getClass())) {
                val = val.toString();
            }
        }
        return val;
    }

    public PropertySerializerRegistrar getPropertySerializerRegistrar() {
        return this.propertySerializerRegistrar;
    }

    public Set<String> getJavaBeanIgnoreProperties() {
        return this.javaBeanIgnoreProperties;
    }

    public Set<Class<?>> getJavaBeanTreatAsStringValues() {
        return this.javaBeanTreatAsStringValues;
    }

    public boolean isIncludeHeader() {
        return this.includeHeader;
    }
}

