/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.support;

import java.util.EnumSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.cache.Cache;
import net.solarnetwork.util.ObjectUtils;
import org.ehcache.config.CacheRuntimeConfiguration;
import org.ehcache.event.CacheEvent;
import org.ehcache.event.CacheEventListener;
import org.ehcache.event.EventFiring;
import org.ehcache.event.EventOrdering;
import org.ehcache.event.EventType;
import org.ehcache.jsr107.Eh107Configuration;

public final class CacheUtils {
    private static final ConcurrentMap<CacheEvictionListener<?, ?>, CacheEvictionListenerAdapter<?, ?>> REGISTRATIONS = new ConcurrentHashMap(8);

    public static <K, V> void registerCacheEvictionListener(Cache<K, V> cache, CacheEvictionListener<K, V> listener) {
        CacheEvictionListenerAdapter<K, V> l = new CacheEvictionListenerAdapter<K, V>(listener);
        if (REGISTRATIONS.putIfAbsent(listener, l) != null) {
            return;
        }
        try {
            CacheRuntimeConfiguration config = (CacheRuntimeConfiguration)((Eh107Configuration)cache.getConfiguration(Eh107Configuration.class)).unwrap(CacheRuntimeConfiguration.class);
            config.registerCacheEventListener(l, EventOrdering.UNORDERED, EventFiring.ASYNCHRONOUS, EnumSet.of(EventType.EVICTED));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static <K, V> void deregisterCacheEvictionListener(Cache<K, V> cache, CacheEvictionListener<K, V> listener) {
        CacheEvictionListenerAdapter l = (CacheEvictionListenerAdapter)REGISTRATIONS.remove(listener);
        if (l == null) {
            return;
        }
        try {
            CacheRuntimeConfiguration config = (CacheRuntimeConfiguration)((Eh107Configuration)cache.getConfiguration(Eh107Configuration.class)).unwrap(CacheRuntimeConfiguration.class);
            config.deregisterCacheEventListener((CacheEventListener)l);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static class CacheEvictionListenerAdapter<K, V>
    implements CacheEventListener<K, V> {
        private final CacheEvictionListener<K, V> delegate;

        private CacheEvictionListenerAdapter(CacheEvictionListener<K, V> delegate) {
            this.delegate = (CacheEvictionListener)ObjectUtils.requireNonNullArgument(delegate, (String)"delegate");
        }

        public void onEvent(CacheEvent<? extends K, ? extends V> event) {
            if (event.getType() == EventType.EVICTED) {
                Object key = event.getKey();
                Object val = event.getOldValue();
                this.delegate.onCacheEviction(key, val);
            }
        }
    }

    @FunctionalInterface
    public static interface CacheEvictionListener<K, V> {
        public void onCacheEviction(K var1, V var2);
    }
}

