/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.support;

import java.time.Duration;
import javax.cache.Cache;
import javax.cache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.jsr107.Eh107Configuration;

public class CacheSettings {
    public static final long DEFAULT_TIME_TO_IDLE = 0L;
    public static final long DEFAULT_TIME_TO_LIVE = 60L;
    public static final long DEFAULT_HEAP_MAX_ENTRIES = 10000L;
    public static final long DEFAULT_DISK_MAX_SIZE_MB = 100L;
    public static final boolean DEFAULT_DISK_PERSISTENT = false;
    private long tti = 0L;
    private long ttl = 60L;
    private long heapMaxEntries = 10000L;
    private long diskMaxSizeMb = 100L;
    private boolean diskPersistent = false;

    public <K, V> Cache<K, V> createCache(CacheManager cacheManager, Class<K> keyType, Class<V> valueType, String name) {
        CacheConfigurationBuilder cacheConfigBuilder = CacheConfigurationBuilder.newCacheConfigurationBuilder(keyType, valueType, (Builder)ResourcePoolsBuilder.heap((long)Integer.MAX_VALUE));
        ResourcePoolsBuilder poolsBuilder = ResourcePoolsBuilder.newResourcePoolsBuilder();
        if (this.heapMaxEntries > 0L) {
            poolsBuilder = poolsBuilder.heap(this.heapMaxEntries, (ResourceUnit)EntryUnit.ENTRIES);
        }
        if (this.diskMaxSizeMb > 0L) {
            poolsBuilder = poolsBuilder.disk(this.diskMaxSizeMb, MemoryUnit.MB, this.diskPersistent);
        }
        cacheConfigBuilder = (CacheConfigurationBuilder)cacheConfigBuilder.withResourcePools((Builder)poolsBuilder);
        if (this.tti > 0L) {
            cacheConfigBuilder = cacheConfigBuilder.withExpiry(ExpiryPolicyBuilder.timeToIdleExpiration((Duration)Duration.ofSeconds(this.tti)));
        }
        if (this.ttl > 0L) {
            cacheConfigBuilder = cacheConfigBuilder.withExpiry(ExpiryPolicyBuilder.timeToLiveExpiration((Duration)Duration.ofSeconds(this.ttl)));
        }
        return cacheManager.createCache(name, Eh107Configuration.fromEhcacheCacheConfiguration((Builder)cacheConfigBuilder));
    }

    public long getTti() {
        return this.tti;
    }

    public void setTti(long tti) {
        this.tti = tti;
    }

    public long getTtl() {
        return this.ttl;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public long getHeapMaxEntries() {
        return this.heapMaxEntries;
    }

    public void setHeapMaxEntries(long heapMaxEntries) {
        this.heapMaxEntries = heapMaxEntries;
    }

    public long getDiskMaxSizeMb() {
        return this.diskMaxSizeMb;
    }

    public void setDiskMaxSizeMb(long diskMaxSizeMb) {
        this.diskMaxSizeMb = diskMaxSizeMb;
    }

    public boolean isDiskPersistent() {
        return this.diskPersistent;
    }

    public void setDiskPersistent(boolean diskPersistent) {
        this.diskPersistent = diskPersistent;
    }
}

