/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import net.solarnetwork.util.UnionIterator;

public class BufferingDelegatingCache<K, V>
implements Cache<K, V> {
    private final Cache<K, V> delegate;
    private final int internalCapacity;
    private final ConcurrentMap<K, V> internalStore;
    private final AtomicInteger size;
    private final AtomicInteger maxSize;
    private CacheEntryCreatedListener<? super K, ? super V> createdListener;
    private CacheEntryUpdatedListener<? super K, ? super V> updatedListener;
    private CacheEntryRemovedListener<? super K, ? super V> removedListener;

    public BufferingDelegatingCache(Cache<K, V> delegate, int internalCapacity) {
        this(delegate, internalCapacity, new ConcurrentHashMap(internalCapacity));
    }

    public BufferingDelegatingCache(Cache<K, V> delegate, int internalCapacity, ConcurrentMap<K, V> internalStore) {
        this.delegate = delegate;
        this.internalCapacity = internalCapacity;
        this.internalStore = internalStore;
        this.size = new AtomicInteger(0);
        this.maxSize = new AtomicInteger(0);
    }

    public int getInternalCapacity() {
        return this.internalCapacity;
    }

    public int getInternalSize() {
        return this.size.get();
    }

    public int getInternalSizeWatermark() {
        return this.maxSize.get();
    }

    public synchronized void clear() {
        this.internalStore.clear();
        this.delegate.clear();
        this.size.set(0);
        this.maxSize.set(0);
    }

    public synchronized void close() {
        if (!this.delegate.isClosed()) {
            for (Map.Entry e : this.internalStore.entrySet()) {
                this.delegate.put(e.getKey(), e.getValue());
            }
            this.internalStore.clear();
            this.size.set(0);
            this.maxSize.set(0);
            this.delegate.close();
        }
    }

    public boolean containsKey(K key) {
        return this.internalStore.containsKey(key) || this.delegate.containsKey(key);
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> config) {
        CacheEntryListener listener = (CacheEntryListener)config.getCacheEntryListenerFactory().create();
        if (listener instanceof CacheEntryCreatedListener) {
            this.createdListener = null;
        }
        if (listener instanceof CacheEntryUpdatedListener) {
            this.updatedListener = null;
        }
        if (listener instanceof CacheEntryRemovedListener) {
            this.removedListener = null;
        }
        this.delegate.deregisterCacheEntryListener(config);
    }

    public V get(K key) {
        Object v = this.internalStore.get(key);
        return (V)(v != null ? v : this.delegate.get(key));
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap result = new HashMap(keys.size());
        for (K k : keys) {
            Object v = this.internalStore.get(k);
            if (v == null) {
                v = this.delegate.get(k);
            }
            if (v == null) continue;
            result.put(k, v);
        }
        return result;
    }

    public V getAndPut(K key, V value) {
        int currSize;
        if (value == null) {
            throw new IllegalArgumentException("Null values are not allowed.");
        }
        Object result = null;
        do {
            if ((result = (Object)this.internalStore.replace(key, value)) == null) {
                result = this.delegate.getAndReplace(key, value);
            }
            if (result != null) {
                this.publishUpdatedEvent(key, value);
                return (V)result;
            }
            currSize = this.size.get();
            int newSize = currSize + 1;
            if (currSize >= this.internalCapacity || !this.size.compareAndSet(currSize, newSize)) continue;
            result = this.internalStore.put(key, value);
            if (result != null) {
                this.size.decrementAndGet();
                this.publishUpdatedEvent(key, value);
            } else {
                this.maxSize.getAndUpdate(m -> m < newSize ? newSize : m);
                this.publishCreatedEvent(key, value);
            }
            return (V)result;
        } while (currSize < this.internalCapacity);
        return (V)this.delegate.getAndPut(key, value);
    }

    public V getAndRemove(K key) {
        Object old = this.internalStore.remove(key);
        if (old != null) {
            this.size.decrementAndGet();
        } else {
            old = this.delegate.getAndRemove(key);
        }
        if (old != null) {
            this.publishRemovedEvent(key, old);
        }
        return old;
    }

    public V getAndReplace(K key, V value) {
        if (value == null) {
            throw new IllegalArgumentException("Null values are not allowed.");
        }
        Object old = this.internalStore.replace(key, value);
        if (old != null) {
            this.publishUpdatedEvent(key, value);
        } else {
            old = this.delegate.getAndReplace(key, value);
        }
        return old;
    }

    public CacheManager getCacheManager() {
        return this.delegate.getCacheManager();
    }

    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        return (C)this.delegate.getConfiguration(clazz);
    }

    public String getName() {
        return this.delegate.getName();
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> processor, Object ... arg2) throws EntryProcessorException {
        throw new UnsupportedOperationException();
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> arg0, EntryProcessor<K, V, T> arg1, Object ... arg2) {
        throw new UnsupportedOperationException();
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        ArrayList<Iterator> combined = new ArrayList<Iterator>(2);
        combined.add(new EntryIteratorAdaptor(this.internalStore.entrySet().iterator()));
        combined.add(this.delegate.iterator());
        return new UnionIterator(combined);
    }

    public void loadAll(Set<? extends K> keys, boolean arg1, CompletionListener arg2) {
        throw new UnsupportedOperationException();
    }

    public void put(K key, V value) {
        int currSize;
        if (value == null) {
            throw new IllegalArgumentException("Null values are not allowed.");
        }
        do {
            if (this.internalStore.replace(key, value) != null) {
                this.publishUpdatedEvent(key, value);
                return;
            }
            if (this.delegate.replace(key, value)) {
                return;
            }
            currSize = this.size.get();
            int newSize = currSize + 1;
            if (currSize >= this.internalCapacity || !this.size.compareAndSet(currSize, newSize)) continue;
            if (this.internalStore.put(key, value) != null) {
                this.size.decrementAndGet();
                this.publishUpdatedEvent(key, value);
            } else {
                this.maxSize.getAndUpdate(m -> m < newSize ? newSize : m);
                this.publishCreatedEvent(key, value);
            }
            return;
        } while (currSize < this.internalCapacity);
        assert (this.internalStore.get(key) == null);
        this.delegate.put(key, value);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry<K, V> me : map.entrySet()) {
            this.put(me.getKey(), me.getValue());
        }
    }

    public boolean putIfAbsent(K key, V value) {
        throw new UnsupportedOperationException();
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> config) {
        CacheEntryListener listener = (CacheEntryListener)config.getCacheEntryListenerFactory().create();
        if (listener instanceof CacheEntryCreatedListener) {
            this.createdListener = (CacheEntryCreatedListener)listener;
        }
        if (listener instanceof CacheEntryUpdatedListener) {
            this.updatedListener = (CacheEntryUpdatedListener)listener;
        }
        if (listener instanceof CacheEntryRemovedListener) {
            this.removedListener = (CacheEntryRemovedListener)listener;
        }
        this.delegate.registerCacheEntryListener(config);
    }

    public boolean remove(K key) {
        Object oldValue = this.internalStore.remove(key);
        if (oldValue != null) {
            this.size.decrementAndGet();
            this.publishRemovedEvent(key, oldValue);
            return true;
        }
        return this.delegate.remove(key);
    }

    public boolean remove(K key, V expected) {
        if (this.internalStore.remove(key, expected)) {
            this.size.decrementAndGet();
            this.publishRemovedEvent(key, expected);
            return true;
        }
        return this.delegate.remove(key, expected);
    }

    public synchronized void removeAll() {
        this.internalStore.clear();
        this.size.set(0);
        this.delegate.removeAll();
    }

    public void removeAll(Set<? extends K> keys) {
        HashSet<K> keysToRemove = new HashSet<K>(keys);
        Iterator itr = keysToRemove.iterator();
        while (itr.hasNext()) {
            Object k = itr.next();
            Object oldValue = this.internalStore.remove(k);
            if (oldValue == null) continue;
            this.size.decrementAndGet();
            this.publishRemovedEvent(k, oldValue);
            itr.remove();
        }
        if (!keysToRemove.isEmpty()) {
            this.delegate.removeAll(keysToRemove);
        }
    }

    public boolean replace(K key, V value) {
        V oldValue = this.internalStore.replace(key, value);
        if (oldValue != null) {
            this.publishUpdatedEvent(key, value);
            return true;
        }
        return this.delegate.replace(key, value);
    }

    public boolean replace(K key, V oldValue, V newValue) {
        if (this.internalStore.replace(key, oldValue, newValue)) {
            this.publishUpdatedEvent(key, newValue);
            return true;
        }
        return this.delegate.replace(key, oldValue, newValue);
    }

    private void publishCreatedEvent(K key, V value) {
        if (this.createdListener != null) {
            this.createdListener.onCreated(Collections.singleton(new CacheEntryEventImpl(key, value, EventType.CREATED)));
        }
    }

    private void publishUpdatedEvent(K key, V value) {
        if (this.updatedListener != null) {
            this.updatedListener.onUpdated(Collections.singleton(new CacheEntryEventImpl(key, value, EventType.UPDATED)));
        }
    }

    private void publishRemovedEvent(K key, V value) {
        if (this.removedListener != null) {
            this.removedListener.onRemoved(Collections.singleton(new CacheEntryEventImpl(key, value, EventType.REMOVED)));
        }
    }

    public <T> T unwrap(Class<T> arg0) {
        throw new UnsupportedOperationException();
    }

    private class EntryIteratorAdaptor
    implements Iterator<Cache.Entry<K, V>> {
        private final Iterator<Map.Entry<K, V>> itr;

        private EntryIteratorAdaptor(Iterator<Map.Entry<K, V>> itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public Cache.Entry<K, V> next() {
            Map.Entry e = this.itr.next();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return new EntryAdaptor(BufferingDelegatingCache.this, e);
        }
    }

    private final class CacheEntryEventImpl
    extends CacheEntryEvent<K, V> {
        private static final long serialVersionUID = 6369201595734400543L;
        private final K key;
        private final V value;

        private CacheEntryEventImpl(K key, V value, EventType eventType) {
            super((Cache)BufferingDelegatingCache.this, eventType);
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public <T> T unwrap(Class<T> arg0) {
            throw new UnsupportedOperationException();
        }

        public V getOldValue() {
            return null;
        }

        public boolean isOldValueAvailable() {
            return false;
        }
    }

    private class EntryAdaptor
    implements Cache.Entry<K, V> {
        private final Map.Entry<K, V> e;

        private EntryAdaptor(BufferingDelegatingCache bufferingDelegatingCache, Map.Entry<K, V> e) {
            this.e = e;
        }

        public K getKey() {
            return this.e.getKey();
        }

        public V getValue() {
            return this.e.getValue();
        }

        public <T> T unwrap(Class<T> clazz) {
            throw new UnsupportedOperationException();
        }
    }
}

