/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.support;

import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.solarnetwork.central.support.SharedValueCache;
import net.solarnetwork.util.CachedResult;
import net.solarnetwork.util.ObjectUtils;

public class BasicSharedValueCache<K, V, S>
implements SharedValueCache<K, V, S> {
    private final ConcurrentMap<K, CachedResult<V>> cache;
    private final ConcurrentMap<S, V> sharedCache;

    public BasicSharedValueCache() {
        this(new ConcurrentHashMap(64, 0.9f, 2), new ConcurrentHashMap(64, 0.9f, 2));
    }

    public BasicSharedValueCache(ConcurrentMap<K, CachedResult<V>> cache, ConcurrentMap<S, V> sharedCache) {
        this.cache = (ConcurrentMap)ObjectUtils.requireNonNullArgument(cache, (String)"cache");
        this.sharedCache = (ConcurrentMap)ObjectUtils.requireNonNullArgument(sharedCache, (String)"sharedCache");
    }

    @Override
    public V get(K key) {
        CachedResult entry = (CachedResult)this.cache.get(key);
        return (V)(entry != null && entry.isValid() ? entry.getResult() : null);
    }

    @Override
    public V put(K key, S shareKey, Function<S, V> valueProvider, long ttl) {
        if (ttl < 1L) {
            CachedResult entry = (CachedResult)this.cache.remove(key);
            return (V)(entry != null ? entry.getResult() : null);
        }
        V sharedValue = this.sharedCache.computeIfAbsent(shareKey, valueProvider);
        CachedResult entry = new CachedResult(sharedValue, ttl, TimeUnit.SECONDS);
        this.cache.put(key, entry);
        return sharedValue;
    }

    @Override
    public void prune() {
        HashSet<Object> inUse = new HashSet<Object>(32);
        Iterator itr = this.cache.values().iterator();
        while (itr.hasNext()) {
            CachedResult entry = (CachedResult)itr.next();
            if (!entry.isValid()) {
                itr.remove();
                continue;
            }
            Object value = entry.getResult();
            if (inUse.contains(value)) continue;
            inUse.add(value);
        }
        Iterator sharedValueItr = this.sharedCache.values().iterator();
        while (sharedValueItr.hasNext()) {
            Object value = sharedValueItr.next();
            if (inUse.contains(value)) continue;
            sharedValueItr.remove();
        }
    }
}

