/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.support;

import java.util.concurrent.atomic.AtomicReference;
import net.solarnetwork.common.mqtt.MqttConnection;
import net.solarnetwork.common.mqtt.MqttConnectionObserver;
import net.solarnetwork.common.mqtt.MqttQos;
import net.solarnetwork.service.support.BasicIdentifiable;
import net.solarnetwork.util.ObjectUtils;
import net.solarnetwork.util.StatTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMqttConnectionObserver
extends BasicIdentifiable
implements MqttConnectionObserver {
    public static final int DEFAULT_PUBLISH_TIMEOUT_SECONDS = 10;
    public static final int DEFAULT_SUBSCRIBE_TIMEOUT_SECONDS = 10;
    public static final int DEFAULT_TRANSIENT_ERROR_TRIES = 3;
    public static final MqttQos DEFAULT_PUBLISH_QOS = MqttQos.AtMostOnce;
    public static final MqttQos DEFAULT_SUBSCRIBE_QOS = MqttQos.AtLeastOnce;
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final AtomicReference<MqttConnection> mqttConnection = new AtomicReference();
    private boolean retained;
    private MqttQos publishQos = DEFAULT_PUBLISH_QOS;
    private MqttQos subscribeQos = DEFAULT_SUBSCRIBE_QOS;
    private int publishTimeoutSeconds = 10;
    private int subscribeTimeoutSeconds = 10;
    private int transientErrorTries = 3;
    private StatTracker mqttStats;

    public void onMqttServerConnectionEstablished(MqttConnection connection, boolean reconnected) {
        this.log.info("MQTT connection established for {}", (Object)this);
        this.mqttConnection.set(connection);
    }

    public void onMqttServerConnectionLost(MqttConnection connection, boolean willReconnect, Throwable cause) {
        this.log.info("MQTT connection lost for {}", (Object)this);
        this.mqttConnection.compareAndSet(connection, null);
    }

    public boolean isConnected() {
        MqttConnection conn = this.mqttConnection.get();
        return conn != null && conn.isEstablished();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(((Object)((Object)this)).getClass().getSimpleName());
        buf.append('{');
        String s = this.getDisplayName();
        if (s != null && !s.isEmpty()) {
            buf.append(s);
        } else {
            s = this.getUid();
            if (s != null && !s.isEmpty()) {
                buf.append(s);
            } else {
                buf.append(Integer.toHexString(System.identityHashCode((Object)this)));
            }
        }
        buf.append('}');
        return buf.toString();
    }

    public int getTransientErrorTries() {
        return this.transientErrorTries;
    }

    public void setTransientErrorTries(int transientErrorTries) {
        if (transientErrorTries < 1) {
            transientErrorTries = 1;
        }
        this.transientErrorTries = transientErrorTries;
    }

    public StatTracker getMqttStats() {
        return this.mqttStats;
    }

    public void setMqttStats(StatTracker mqttStats) {
        this.mqttStats = mqttStats;
    }

    public MqttQos getSubscribeQos() {
        return this.subscribeQos;
    }

    public void setSubscribeQos(MqttQos subscribeQos) {
        this.subscribeQos = (MqttQos)ObjectUtils.requireNonNullArgument((Object)subscribeQos, (String)"subscribeQos");
    }

    public void setSubscribeQosLevel(int level) {
        this.setSubscribeQos(MqttQos.valueOf((int)level));
    }

    public int getSubscribeTimeoutSeconds() {
        return this.subscribeTimeoutSeconds;
    }

    public void setSubscribeTimeoutSeconds(int subscribeTimeoutSeconds) {
        this.subscribeTimeoutSeconds = subscribeTimeoutSeconds;
    }

    public boolean isRetained() {
        return this.retained;
    }

    public void setRetained(boolean retained) {
        this.retained = retained;
    }

    public MqttQos getPublishQos() {
        return this.publishQos;
    }

    public void setPublishQos(MqttQos publishQos) {
        this.publishQos = (MqttQos)ObjectUtils.requireNonNullArgument((Object)publishQos, (String)"publishQos");
    }

    public void setPublishQosLevel(int level) {
        this.setPublishQos(MqttQos.valueOf((int)level));
    }

    public int getPublishTimeoutSeconds() {
        return this.publishTimeoutSeconds;
    }

    public void setPublishTimeoutSeconds(int publishTimeoutSeconds) {
        this.publishTimeoutSeconds = publishTimeoutSeconds;
    }
}

