/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.support;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.solarnetwork.central.domain.Filter;
import net.solarnetwork.central.domain.MetadataFilter;
import net.solarnetwork.central.domain.TagFilter;

public class BaseFilterSupport
implements Filter,
Serializable,
MetadataFilter,
TagFilter {
    private static final long serialVersionUID = 4146553587756173455L;
    private Long[] userIds;
    private String[] tags;
    private String metadataFilter;

    @Override
    public Map<String, ?> getFilter() {
        LinkedHashMap<String, Object> filter = new LinkedHashMap<String, Object>(8);
        if (this.userIds != null) {
            filter.put("userIds", this.userIds);
        }
        if (this.tags != null) {
            filter.put("tags", this.tags);
        }
        if (this.metadataFilter != null && !this.metadataFilter.trim().isEmpty()) {
            filter.put("metadataFilter", this.metadataFilter);
        }
        return filter;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FilterSupport{");
        if (this.userIds != null) {
            builder.append("userIds=");
            builder.append(Arrays.toString((Object[])this.userIds));
            builder.append(", ");
        }
        if (this.tags != null) {
            builder.append("tags=");
            builder.append(Arrays.toString(this.tags));
            builder.append(", ");
        }
        if (this.metadataFilter != null) {
            builder.append("metadataFilter=");
            builder.append(this.metadataFilter);
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    @JsonIgnore
    public String getTag() {
        return this.tags == null || this.tags.length < 1 ? null : this.tags[0];
    }

    @JsonSetter
    public void setTag(String tag) {
        String[] stringArray;
        if (tag == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = tag;
        }
        this.tags = stringArray;
    }

    @Override
    public String[] getTags() {
        return this.tags;
    }

    public void setTags(String[] tags) {
        this.tags = tags;
    }

    @JsonSetter
    public void setUserId(Long userId) {
        Long[] longArray;
        if (userId == null) {
            longArray = null;
        } else {
            Long[] longArray2 = new Long[1];
            longArray = longArray2;
            longArray2[0] = userId;
        }
        this.userIds = longArray;
    }

    @JsonIgnore
    public Long getUserId() {
        return this.userIds == null || this.userIds.length < 1 ? null : this.userIds[0];
    }

    public Long[] getUserIds() {
        return this.userIds;
    }

    public void setUserIds(Long[] userIds) {
        this.userIds = userIds;
    }

    @Override
    public String getMetadataFilter() {
        return this.metadataFilter;
    }

    public void setMetadataFilter(String metadataFilter) {
        this.metadataFilter = metadataFilter;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.tags);
        result = 31 * result + Arrays.hashCode((Object[])this.userIds);
        result = 31 * result + Objects.hash(this.metadataFilter);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BaseFilterSupport)) {
            return false;
        }
        BaseFilterSupport other = (BaseFilterSupport)obj;
        return Arrays.equals(this.tags, other.tags) && Arrays.equals((Object[])this.userIds, (Object[])other.userIds) && Objects.equals(this.metadataFilter, other.metadataFilter);
    }
}

