/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.security.web.support;

import java.time.Instant;
import java.util.Map;
import net.solarnetwork.central.security.SecurityToken;
import net.solarnetwork.central.security.web.AuthenticationTokenService;
import net.solarnetwork.security.Snws2AuthorizationBuilder;
import net.solarnetwork.web.jakarta.security.AuthenticationScheme;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;

public class UserDetailsAuthenticationTokenService
implements AuthenticationTokenService {
    private final UserDetailsService userDetailsService;

    public UserDetailsAuthenticationTokenService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    @Override
    public byte[] computeAuthenticationTokenSigningKey(AuthenticationScheme scheme, SecurityToken token, Map<String, ?> properties) {
        UserDetails user = this.userDetailsService.loadUserByUsername(token.getToken());
        switch (scheme) {
            case V1: {
                return user.getPassword().getBytes();
            }
            case V2: {
                if (!(properties.get("signDate") instanceof Instant)) {
                    throw new IllegalArgumentException("The signDate property must be an Instant");
                }
                Instant ts = (Instant)properties.get("signDate");
                return new Snws2AuthorizationBuilder(token.getToken()).computeSigningKey(ts, user.getPassword());
            }
        }
        throw new UnsupportedOperationException("Scheme " + String.valueOf(scheme) + " not supported");
    }
}

