/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.security.web;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Instant;
import java.util.Set;
import net.solarnetwork.central.security.SecurityPolicy;
import net.solarnetwork.central.security.SecurityToken;
import net.solarnetwork.central.security.config.SecurityTokenFilterSettings;
import net.solarnetwork.web.jakarta.security.AuthenticationData;
import net.solarnetwork.web.jakarta.security.AuthenticationDataFactory;
import net.solarnetwork.web.jakarta.security.SecurityException;
import net.solarnetwork.web.jakarta.security.SecurityHttpServletRequestWrapper;
import net.solarnetwork.web.jakarta.security.SecurityTokenAuthenticationEntryPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.http.MediaType;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.transaction.TransactionException;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.PathMatcher;
import org.springframework.util.unit.DataSize;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

public class SecurityTokenAuthenticationFilter
extends OncePerRequestFilter
implements Filter {
    public static final int AUTH_TOKEN_LENGTH = 20;
    public static final int DEFAULT_MAX_REQUEST_BODY_SIZE = 65535;
    private AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource = new WebAuthenticationDetailsSource();
    private SecurityTokenAuthenticationEntryPoint authenticationEntryPoint;
    private UserDetailsService userDetailsService;
    private final PathMatcher pathMatcher;
    private final String pathMatcherPrefixStrip;
    private final SecurityTokenFilterSettings settings;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public SecurityTokenAuthenticationFilter() {
        this(null, null, null);
    }

    public SecurityTokenAuthenticationFilter(PathMatcher pathMatcher, String pathMatcherPrefixStrip) {
        this(pathMatcher, pathMatcherPrefixStrip, null);
    }

    public SecurityTokenAuthenticationFilter(PathMatcher pathMatcher, String pathMatcherPrefixStrip, SecurityTokenFilterSettings settings) {
        this.pathMatcher = pathMatcher;
        this.pathMatcherPrefixStrip = pathMatcherPrefixStrip;
        this.settings = settings != null ? settings : new SecurityTokenFilterSettings();
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.userDetailsService, (String)"A UserDetailsService is required");
        Assert.notNull((Object)this.authenticationEntryPoint, (String)"A SecurityTokenAuthenticationEntryPoint is required");
    }

    protected void doFilterInternal(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws ServletException, IOException {
        String computedDigest;
        UserDetails user;
        AuthenticationData data;
        SecurityHttpServletRequestWrapper request = new SecurityHttpServletRequestWrapper(req, (int)this.settings.getMaxRequestBodySize().toBytes(), true, (int)this.settings.getMinimumCompressLength().toBytes(), this.settings.getCompressibleContentTypePattern(), (int)this.settings.getMinimumSpoolLength().toBytes(), this.settings.getSpoolDirectory());
        HttpServletResponse response = res;
        if (req.getContentType() != null && MediaType.MULTIPART_FORM_DATA.isCompatibleWith(MimeType.valueOf((String)req.getContentType()))) {
            request.getContentSHA256();
        }
        try {
            data = AuthenticationDataFactory.authenticationDataForAuthorizationHeader((SecurityHttpServletRequestWrapper)request);
        }
        catch (SecurityException e) {
            this.deny(request, response, (Exception)new MaxUploadSizeExceededException((long)((int)this.settings.getMaxRequestBodySize().toBytes()), (Throwable)e));
            return;
        }
        catch (java.lang.SecurityException e) {
            this.deny(request, response, e);
            return;
        }
        catch (AuthenticationException e) {
            this.fail(request, response, e);
            return;
        }
        if (data == null) {
            this.log.trace("Missing Authorization header or unsupported scheme");
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            user = this.userDetailsService.loadUserByUsername(data.getAuthTokenId());
        }
        catch (AuthenticationException e) {
            this.log.debug("Auth token [{}] exception: {}", (Object)data.getAuthTokenId(), (Object)e.getMessage());
            this.fail(request, response, (AuthenticationException)new BadCredentialsException("Bad credentials"));
            return;
        }
        catch (DataAccessException | TransactionException e) {
            this.log.debug("Auth token [{}] transient DAO exception: {}", (Object)data.getAuthTokenId(), (Object)e.getMessage());
            this.failDao(request, response, (Exception)e);
            return;
        }
        catch (Exception e) {
            this.log.debug("Auth token [{}] exception: {}", (Object)data.getAuthTokenId(), (Object)e.getMessage());
            this.fail(request, response, (AuthenticationException)new AuthenticationServiceException("Unable to verify credentials", (Throwable)e));
            return;
        }
        if (user instanceof SecurityToken) {
            SecurityPolicy policy = ((SecurityToken)user).getPolicy();
            if (policy != null && !policy.isValidAt(Instant.now())) {
                this.fail(request, response, (AuthenticationException)new CredentialsExpiredException("Expired token"));
                return;
            }
            if (!this.isValidApiPath((HttpServletRequest)request, policy)) {
                this.fail(request, response, (AuthenticationException)new BadCredentialsException("Access denied"));
                return;
            }
        }
        if (!(computedDigest = data.computeSignatureDigest(user.getPassword())).equals(data.getSignatureDigest())) {
            this.log.debug("Expected response: [{}] but received: [{}]", (Object)computedDigest, (Object)data.getSignatureDigest());
            this.fail(request, response, (AuthenticationException)new BadCredentialsException("Bad credentials"));
            return;
        }
        if (!data.isDateValid(this.settings.getMaxDateSkew())) {
            this.log.debug("Request date [{}] diff too large: {}", (Object)data.getDate(), (Object)data.getDateSkew());
            this.fail(request, response, (AuthenticationException)new BadCredentialsException("Date skew too large"));
            return;
        }
        this.log.debug("Authentication success for user: [{}]", (Object)user.getUsername());
        SecurityContextHolder.getContext().setAuthentication(this.createSuccessfulAuthentication((HttpServletRequest)request, user));
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean isValidApiPath(HttpServletRequest request, SecurityPolicy policy) {
        Set<String> apiPaths;
        Set<String> set = apiPaths = policy != null ? policy.getApiPaths() : null;
        if (apiPaths == null || apiPaths.isEmpty()) {
            return true;
        }
        if (request == null) {
            return false;
        }
        String path = request.getRequestURI();
        if (path == null) {
            return false;
        }
        String ctxPath = request.getContextPath();
        if (ctxPath != null && !ctxPath.isEmpty()) {
            path = path.substring(ctxPath.length());
        }
        if (this.pathMatcherPrefixStrip != null && !this.pathMatcherPrefixStrip.isEmpty() && path.startsWith(this.pathMatcherPrefixStrip)) {
            path = path.substring(this.pathMatcherPrefixStrip.length());
        }
        for (String allowedPath : apiPaths) {
            boolean inverted;
            if (allowedPath == null || allowedPath.isEmpty()) continue;
            if (allowedPath.startsWith("!")) {
                inverted = true;
                allowedPath = allowedPath.substring("!".length());
            } else {
                inverted = false;
            }
            boolean match = this.pathMatcher != null ? this.pathMatcher.match(allowedPath, path) : allowedPath.equals(path);
            if (inverted) {
                boolean bl = match = !match;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    private Authentication createSuccessfulAuthentication(HttpServletRequest request, UserDetails user) {
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)user, (Object)user.getPassword(), user.getAuthorities());
        authRequest.eraseCredentials();
        authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
        return authRequest;
    }

    private void fail(SecurityHttpServletRequestWrapper request, HttpServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        SecurityContextHolder.getContext().setAuthentication(null);
        request.deleteCachedContent();
        this.authenticationEntryPoint.commence((HttpServletRequest)request, response, failed);
    }

    private void deny(SecurityHttpServletRequestWrapper request, HttpServletResponse response, Exception e) throws IOException, ServletException {
        SecurityContextHolder.getContext().setAuthentication(null);
        request.deleteCachedContent();
        String msg = e.getMessage();
        if (msg == null) {
            msg = "Access denied.";
        }
        this.authenticationEntryPoint.handle((HttpServletRequest)request, response, new AccessDeniedException(msg, (Throwable)e));
    }

    private void failDao(SecurityHttpServletRequestWrapper request, HttpServletResponse response, Exception failed) throws IOException, ServletException {
        SecurityContextHolder.getContext().setAuthentication(null);
        request.deleteCachedContent();
        this.authenticationEntryPoint.handleTransientResourceException((HttpServletRequest)request, response, failed);
    }

    public UserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource) {
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public void setMaxDateSkew(long maxDateSkew) {
        this.settings.setMaxDateSkew(maxDateSkew);
    }

    public void setAuthenticationEntryPoint(SecurityTokenAuthenticationEntryPoint entryPoint) {
        this.authenticationEntryPoint = entryPoint;
    }

    public void setMaxRequestBodySize(int maxRequestBodySize) {
        this.settings.setMaxRequestBodySize(DataSize.ofBytes((long)maxRequestBodySize));
    }

    public SecurityTokenFilterSettings getSettings() {
        return this.settings;
    }
}

