/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.security.web;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import net.solarnetwork.util.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.web.firewall.RequestRejectedException;
import org.springframework.security.web.firewall.RequestRejectedHandler;
import org.springframework.web.servlet.HandlerExceptionResolver;

public class HandlerExceptionResolverRequestRejectedHandler
implements RequestRejectedHandler {
    private static final Logger log = LoggerFactory.getLogger(HandlerExceptionResolverRequestRejectedHandler.class);
    private final HandlerExceptionResolver handlerExceptionResolver;

    public HandlerExceptionResolverRequestRejectedHandler(HandlerExceptionResolver handlerExceptionResolver) {
        this.handlerExceptionResolver = (HandlerExceptionResolver)ObjectUtils.requireNonNullArgument((Object)handlerExceptionResolver, (String)"handlerExceptionResolver");
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, RequestRejectedException e) throws IOException, ServletException {
        if (this.handleWithResolver(request, response, (Exception)e)) {
            return;
        }
        log.info("RequestRejectedException in request {}: {}", (Object)request.getRequestURL(), (Object)e.getMessage());
        response.sendError(HttpStatus.BAD_REQUEST.value());
    }

    private boolean handleWithResolver(HttpServletRequest request, HttpServletResponse response, Exception exception) throws ServletException {
        if (this.handlerExceptionResolver != null) {
            try {
                if (this.handlerExceptionResolver.resolveException(request, response, null, exception) != null) {
                    return true;
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        return false;
    }
}

